#include "rtppack.h"

/***************** Declaration ************************************************/
#if 0
typedef union Global_union {
  PyraGlobal *pyra;
  H263Global *h263;
} Global;
#endif
/***************** Funktionen ************************************************
  ChopByteSync
  findGOBindices
  rtp_packetize
*****************************************************************************/

/***************** Anmerkung ************************************************/



/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ChopByteSync --    Zum Einlesen eines Frames aus Bitstream-Files  
 *
 * Author:           Juergen Weigert
 *
 * Created:          
 *
 * Purpose:          ChopByteSync finds the first nbits bits of pat in the file 
 *                   referenced by fp. Start of the sync pattern pat is expected 
 *                   to be byte aligned. all material from the current file position 
 *                   up to and including the bytes containing pat are appended to *d.
 *                   to read an unlimited amount of bytes use 0 for max.
 *
 * Arguments in:     FILE*      fp              fd
 *                   int        max             max. Anzahl Bytes zum Einlesen
 *                   u_char*    pat             
 *                   int        nbits           
 *                                              
 * Arguments in/out: dstring**  dp              Zeiger auf
 *
 * Arguments out:    
 *
 * Return values:    int        nonzero at EOF
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         
 *
 * Modified:         04.98 by Markus Sebeck
 *
 *****************************************************************************/
int ChopByteSync(dstring **dp, FILE *fp, int max, unsigned char *pat, int nbits)
/***********************************************************CommentEnd********/
{
  unsigned char *ss, *pp = pat;
  dstring *dd = *dp;
  int cc, need = nbits;
  int nbytes = (nbits + 7) >> 3;

  /* if (!dd) dstring_append(&dd, 0, NULL, 8192);*/
  if (!dd) dstring_append(&dd, 0, NULL, MAX_FRAMESIZE);

  if (max) max++;

  for (;;)
    {
      if (((cc = getc(fp)) == EOF) || !--max)
	{
	  dd->buf[dd->length] = '\0';
	  *dp = dd;
	  return -1;
	}
      /*if (dd->allocated <= dd->length) dstring_append(&dd, -1, NULL, 8192);*/
      if (dd->allocated <= dd->length) dstring_append(&dd, -1, NULL, MAX_FRAMESIZE);  /*!! gross genug???*/
      *(ss = dd->buf + dd->length++) = cc;

      if (dd->length < nbytes)
        continue;
	
      ss += 1-nbytes;
      
      while (need >= 8)
        {
	  if (*ss == *pp)
	    {
	      ss++; pp++;
	      need -= 8;
	    }
	  else
	    break;
	}
      if (!need || ((need < 8) && ((*ss >> (8-need)) == (*pp >> (8-need)))))
        break;
      pp = pat;
      need = nbits; 
    }
  dd->buf[dd->length] = '\0';
  *dp = dd;
  return 0;
}

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- findGOBindices --    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          Schreibt ein RTP-Paket in ein File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     FILE*      fileptr         Ausgabefile
 *                   u_char*    packetptr       Zeiger auf Bitstream
 *                   int        packetlen       Laenge des Bitstreams in Byte
 *                   
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 * Comment:          Vorsicht!!! GOB-Indizes sind Bitindizes, waehrend die 
 *                   Sync-Positionen in Bytes angegeben werden!!!
 *
 *****************************************************************************/
int findGOBindices(dstring *ds, LayerData *ld)
/***********************************************************CommentEnd********/
{
    int i;
    unsigned char *start, *curpos, *end;

    start = ds->buf;
    end = ds->buf + ds->length;
    curpos = start;
    ld->mbind = (int*) malloc((ld->gobs_per_frame*ld->mbs_per_gob + 1)*sizeof(int));
    
    /* Speicherbereich initialisieren (nur zum Ueberpruefen von Fehlern) */
    for (i=0;i<(ld->gobs_per_frame*ld->mbs_per_gob + 1);i++)
        ld->mbind[i]=0;

    /* printf("GOB-Nr.: "); */

    if(ld->datatype == H263_ID)
    {
        for (i=0;i<ld->gobs_per_frame;i++)
	{
	    curpos = FindH263Sync(curpos, end);
	    /* printf("%d, ",ShowH263GOBnumber(curpos)); */
	    ld->mbind[i*ld->mbs_per_gob] = (curpos - start) << 3;  /*!! Ueberpruefen */
	    curpos += 3;
	}
	ld->mbind[ld->gobs_per_frame*ld->mbs_per_gob] = ds->length << 3;
	if (ShowH263GOBnumber(curpos-3) != ld->gobs_per_frame - 1)
	{
	    fprintf(stderr, "%d GOBs found instead of %d ",(ShowH263GOBnumber(curpos-3) +1), ld->gobs_per_frame);
	    return 1;
	}
    }
    else
    {
        for (i=0;i<ld->gobs_per_frame;i++)
	{
	    curpos = FindPyraSync(curpos, end);
	    /* printf("%d, ",ShowPyraGOBnumber(curpos)); */
	    ld->mbind[i*ld->mbs_per_gob] = (curpos - start) << 3;  /*!! Ueberpruefen */
	    curpos += 4;
	}
	ld->mbind[ld->gobs_per_frame*ld->mbs_per_gob] = ds->length << 3;
	if (ShowPyraGOBnumber(curpos-4) != ld->gobs_per_frame - 1)
	{
	    fprintf(stderr, "%d GOBs found instead of %d ",(ShowPyraGOBnumber(curpos-3) +1), ld->gobs_per_frame);
	    return 1;
	}
    }
    return 0;
}



/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- rtp_packetize -- 
 *
 * Author:           Markus Sebeck
 *
 * Created:          14-Apr-98
 *
 * Purpose:          
 *
 * Arguments in:     int        layernum        Anzahl der Layer
 *                   int*       layerind        Indizes der Layer in aufsteigender
 *                                              Reihenfolge (z.B.: [0,1,3])
 *                   char**     filesIn         komplette Namen der Bitstreamfiles
 *                   char**     filesOut        komplette(r) Name(n) der Paketfiles
 *                   int        outputmode      Ausgabemodus der Pakete
 *                                              0: Senden 
 *                                              1: Ausgabe in 1 File
 *                                              2: Ausgabe in layernum Files
 * Arguments in/out: -
 *
 * Arguments out:    -
 *
 * Return values:    int        number of bits used.
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 * Comment:          Vorsicht mit der Struktur dstring. Kann bei jedem Aufruf der 
 *                   Funktion ChopByteSync neu im Speicher angelegt werden.
 *
 *****************************************************************************/
int rtp_packetize(int layernum, int* layerind, char** filesIn, char** filesOut,
		  char *outpath, int outputmode)
/***********************************************************CommentEnd********/
{
    int i;
    /* int j, index; */
    int error=0;

    LayerData *ld[MAX_LAYERS];    /* Informationen zu den Bitstreams der Layer */
    RtpData *rd[MAX_LAYERS];      /* Informationen zu den Bitstreams der Layer */
    dstring *ds[MAX_LAYERS];
    int layerfreq[MAX_LAYERS];    /*  */
    int syncbytes[MAX_LAYERS];	  /* Byteanzahl der Syncs */

    /* Statistik */
    unsigned long int read_bytes[MAX_LAYERS] = {0};  /* Anzahl der ausgelesenen Bytes aus den Files */
    unsigned long int sent_bytes[MAX_LAYERS] = {0};  /* Anzahl der gesendeten Bytes (Daten + Header) */
    /* unsigned long int sent_packets[MAX_LAYERS];/ Anzahl der gesendeten Pakete */

    /* Flags */
    int getframe[MAX_LAYERS] = {0};    /* =1: naechsten Frame einlesen */
    int noframe[MAX_LAYERS] = {0};     /* =1: kein Frame mehr vorhanden */
    int eof[MAX_LAYERS] = {0};	       /* =1: End of File reached */
    
    /*  */
    int continueFlag = layernum;       /* bei jedem komplett ausgelesenen File um 1 erniedrigen */
    int curl;                          /* Index des aktuellen Layers (current layer) */
    int type;			       /* Datentyp des akt. Layers */
    unsigned int layermask;            /* Bit n=1, wenn zum akt. Zeitpunkt Layer n codiert */
    long int temp;
    unsigned char time, starttime=255;
    char *protocolname;                
    FILE *protocol;                    /* File zur Ausgabe von Protokolldaten */

    /* statische Daten */
    static unsigned char *picsync[2] = {"\0\0\200",	/* h.263 picture sync pattern */
					"\0\0\1\0"};	/* pyra picture sync pattern */
    static int syncbits[2] = {17+5, 24+5};
                 /* Bildformate:  SQCIF QCIF CIF 4CIF 16CIF */
    static int gobs_per_frame[5] = {  6,   9, 18,  18,   18};
    static int mbs_per_gob[5] = {     8,  11, 22,  88,  352};
    Global these[MAX_LAYERS];
    int method[MAX_LAYERS], isbaselayer, lastAvailLayer;

    /********************* end of declarations/definitions ****************************/

    /* Protokollfile oeffnen */
    protocolname = (char*) malloc((strlen(outpath) + 15) * sizeof(char));
    protocolname[0] = '\0';
    sprintf(protocolname, "%sprotocol", outpath);
    if ( (protocol = fopen(protocolname,"w")) == NULL ) 
        fprintf(stderr,"Can't open %s for writing.\n", protocolname);

    /* Stukturen RtpData und LayerData allokieren, dstring initialisieren */
    for (i=0;i<layernum;i++)
    {
        curl = layerind[i];
	rd[curl] = (RtpData*) malloc(sizeof(RtpData));
	ld[curl] = (LayerData*) malloc(sizeof(LayerData));
	/* ds[curl] = (struct dstring*) malloc(sizeof(dstring));*/
	ds[curl] = NULL;
    }

    /* Bitstream-Files oeffnen */
    printf("\nOpen bitstream files.\n\n");
    for (i=0;i<layernum;i++)
    {
        curl = layerind[i];
        ld[curl]->infilePtr = fopen(filesIn[curl],"rb");
	if (ld[curl]->infilePtr == NULL)
	{
	    printf("\nBitstream file %s not found.\n",filesIn[curl]);
	    error = 1;
	}
	getframe[curl] = 1;      /* Flags setzen */
        ld[curl]->outfilePtr = fopen(filesOut[curl],"wb");
	if (ld[curl]->outfilePtr == NULL)
	{
	    printf("\nCould not open file %s for output.\n",filesOut[curl]);
	    error = 1;
	}
    }
    if (error) exit(5);

    /* Bytes des 1. Picture Sync einlesen und Datentyp bestimmen (H.263,Pyra) */
    for (i=0;i<layernum;i++)
    {
        curl = layerind[i];
	if (ChopByteSync(&ds[curl], ld[curl]->infilePtr, 4,
			 picsync[PYRA_ID-1], syncbits[PYRA_ID-1]))
	{
	    ld[curl]->datatype = H263_ID;
            method[curl] = H263;
	    ds[curl]->length = 0;
	    rewind(ld[curl]->infilePtr);
	    if (ChopByteSync(&ds[curl], ld[curl]->infilePtr, 4,
			     picsync[H263_ID-1], syncbits[H263_ID-1]))
	    {
		fprintf(stderr, "\n\nhmm, %s does not start with Pyra or H263 PictSync...\n", filesIn[curl]);
	  	exit(6);
	    }            
      	    else
		printf("Type of bitstream in file %s is H.263.\n", filesIn[curl]);
	}
	else
        {
	    ld[curl]->datatype = PYRA_ID;
            method[curl] = PYRA;
	    printf("Type of bitstream in file %s is Pyra.\n", filesIn[curl]);
	}
        syncbytes[curl] = ds[curl]->length;
    }

    /* fuer jeden Layer RTP-Informationen und Bitstream-Infos initialisieren */
    for (i=0;i<layernum;i++)
    {
        curl = layerind[i];
	/*!! Wie sollen die folgenden Werte ermittelt werden? */
	rd[curl]->ssrc = curl;   /* einmalig festlegen */
	rd[curl]->timestamp = 0;
	rd[curl]->sequencenr = 0;
	ld[curl]->framecount = 0;
    }

    /* Startzeitpunkt ermitteln (kleinste temporal reference) 
     * (Filezeiger unveraendert lassen) */
    /*!! ist das notwendig oder beginnt Sequenz immer mit 0 ?
     * Wenn notwendig, noch Datenstrom bis zu tempref aus File lesen und
     * Zeiger anschliessend zuruecksetzen !!! */ 
    for (i=0;i<layernum;i++)
    {
	curl = layerind[i];
	ld[curl]->stream = (char*) malloc(7*sizeof(char));
	temp = ftell(ld[curl]->infilePtr);
	fseek(ld[curl]->infilePtr, 0, SEEK_SET);
	fread(ld[curl]->stream, 1, 6, ld[curl]->infilePtr);

	if(ld[curl]->datatype == H263_ID)
        {
	    ld[curl]->tempref = ShowH263TempRef((Byte*)ld[curl]->stream);
            these[curl].h263 = NewH263DecoderNoBuffer();
	}
        else
        {
	    ld[curl]->tempref = ShowPyraTempRef((Byte*)ld[curl]->stream);
            these[curl].pyra = NewPyraDecoderNoBuffer();
	}
        starttime = (ld[curl]->tempref < starttime) ? ld[curl]->tempref : starttime;
	fseek(ld[curl]->infilePtr, temp, SEEK_SET);
	free(ld[curl]->stream);
    }
    for (i=0;i<layernum;i++)
    {
        curl = layerind[i];
	ld[curl]->prevtempref = starttime;
    }


    /******************************************************************/
    /******************** Hauptschleife *******************************/
    /******************************************************************/
    /* Files auslesen und einzelne Frames den Zeitpunkten nach versenden,
     * beginnend mit dem jeweils hoechsten Layer hin zum niedrigsten */
    for (time=starttime; ;time++)
    {
        /* Alle Files bereits komplett ausgelesen */
        if(continueFlag <= 0) 
	{
	    printf("\n\nICH HABE FERTIG!!!\n\n");
	    break;
	}
	printf("***************** Time %3d *****************\n",time);
	fprintf(protocol,"***************** Time %3d *****************\n",time);

        /*******************************************************************/
	/* Fuer jeden Layer ggfalls einen Frame auslesen und einige Parameter bestimmen */
	/* ChopByteSync includes the next sync word in d, when returning 0 */
	for (i=0;i<layernum;i++)
	{
	    curl = layerind[i];
	    if(getframe[curl] == 1)
	    {
		type = ld[curl]->datatype - 1;
		if (!ChopByteSync( &ds[curl], ld[curl]->infilePtr, 0,
				   picsync[type], syncbits[type] ))
		{
		    ld[curl]->framecount++;
		    ds[curl]->length -= syncbytes[curl];       /* ignore the last sync word now */
		    printf("Layer %d, filepos. %8ld, frame %6d: %5d bytes\n", curl, ftell(ld[curl]->infilePtr), ld[curl]->framecount, ds[curl]->length);
		}
		else
		{
		    /* EOF reached: no more picture sync words, but possibly body of last picture */
		    if(ds[curl]->length == syncbytes[curl])  /*!! noch ueberpruefen */
		        noframe[curl] =1;
		    else
		    {
		        ld[curl]->framecount++;
			printf("Layer %d, filepos. %8ld, frame %6d: %5d bytes\n", curl, ftell(ld[curl]->infilePtr), ld[curl]->framecount, ds[curl]->length);
		    }
		    eof[curl] = 1;
		}
		getframe[curl] = 0;
		
		ld[curl]->stream = ds[curl]->buf;
		ld[curl]->bytelen = ds[curl]->length;
		ld[curl]->bitlen = ld[curl]->bytelen << 3;
		read_bytes[curl] += ds[curl]->length;

		if(ld[curl]->datatype == H263_ID)
		{
		    ld[curl]->picformat = ShowH263PicSize((Byte*)ld[curl]->stream);
		    ld[curl]->tempref = ShowH263TempRef((Byte*)ld[curl]->stream);
		}		
		else
		{
		    ld[curl]->picformat = ShowPyraPicSize((Byte*)ld[curl]->stream);
		    ld[curl]->tempref = ShowPyraTempRef((Byte*)ld[curl]->stream);
		}
		ld[curl]->gobs_per_frame = gobs_per_frame[ld[curl]->picformat - 1];
		ld[curl]->mbs_per_gob    =    mbs_per_gob[ld[curl]->picformat - 1];	        
            }
	}

	/* Erstellen der Layermask */
	layermask = 0;
	for (i=0;i<layernum;i++)
	{
	    curl = layerind[i];
	    if(ld[curl]->tempref == time)
		layermask |= (1<<curl);
	    /* else if((ld[curl]->tempref - time) > maximalwert)
		Fehlermeldung */
        }


	/* Fuer jeden Layer ueberpruefen, ob zum aktuellen Zeitpunkt ein Frame codiert ist.
	 * Wenn ja, verschicken beginnend mit dem hoechsten */
        isbaselayer = 1;
        for (i=layernum-1;i>=0;i--)
	{
	    curl = layerind[i];
	    if((!noframe[curl]) && (ld[curl]->tempref == time))
	    {
		/* layer frequency aus temporal reference bestimmen */
	      /*!!layerfreq[curl] = abs(ld[curl]->tempref - ld[curl]->prevtempref);!!*/
		layerfreq[curl] = (ld[curl]->tempref + 256 - ld[curl]->prevtempref) % 256; /*!!NEU2905!!!*/

		rd[curl]->timestamp += layerfreq[curl];
		/* rd[curl]->sequencenr++; */ /*!!MOD*/

		/* GOB-Indizes ermitteln */
		/* printf("\nGet GOB-indices of layer %d, frame %d:\n", curl, ld[curl]->framecount); */
		if (findGOBindices(ds[curl], ld[curl]))
		    fprintf(stderr, "in file %s, frame %d.\n", filesIn[curl], ld[curl]->framecount);

		/********** Frame als RTP-Paket versenden/speichern ************/
		fprintf(protocol,"Layer %d, frame %d: %5d bytes\n", curl, ld[curl]->framecount,ld[curl]->bytelen);
		fprintf(stderr,"Layer %d, frame %d: %5d bytes\n", curl, ld[curl]->framecount,ld[curl]->bytelen);
		if(ld[curl]->datatype == H263_ID)
		{
		    sent_bytes[curl] += split_and_pack_h263frame(these[curl].h263, 0, rd[curl],
                                                                 ld[curl], protocol);
		}
		else
		{
                    these[curl].pyra->baseLayerFlag = isbaselayer;
                    if (!isbaselayer)
                        InitLayerReferences(method, these, curl, lastAvailLayer);
                    
		    sent_bytes[curl] += split_and_pack_pyraframe(these[curl].pyra, curl, layernum,
                                                                 layermask, layerfreq[curl], 
								 rd[curl], ld[curl], protocol);
		}		
		    
		if(eof[curl])
		{
		    noframe[curl] = 1;
		    fclose(ld[curl]->infilePtr);
		    fclose(ld[curl]->outfilePtr);
		    continueFlag--;
		}
		else
		{
		    /* wenn ein Frame eines Layers verschickt wurde: */
		    /* move the remaining sync word to the beginning of the buffer */
		    xbcopy(ds[curl]->buf + ds[curl]->length, ds[curl]->buf, syncbytes[curl]);
		    ds[curl]->length = syncbytes[curl];
		    getframe[curl] = 1;
		    ld[curl]->prevtempref = ld[curl]->tempref;
		}

                isbaselayer = 0;
                lastAvailLayer = curl;
	    }
        }
    }

    /* Ergebnisse */
    printf("\n\nResult:\n");
    fprintf(protocol, "\n\nResult:\n");
    for (i=layernum-1;i>=0;i--)
    {
        curl = layerind[i];
        if(ld[curl]->datatype == H263_ID)
        {
            DisinitH263Decoder(these[curl].h263);
            FreeH263Decoder(these[curl].h263);
        }
        else
        {
            DisinitPyraDecoder(these[curl].pyra);
            FreePyraDecoder(these[curl].pyra);
        }
	printf("Layer %d: %8lu bytes sent in %4d packets.\n", curl, sent_bytes[curl], rd[curl]->sequencenr);
	fprintf(protocol, "Layer %d: %8lu bytes sent in %4d packets.\n", curl, sent_bytes[curl], rd[curl]->sequencenr);
    }
    fclose(protocol);
    return 0;
}

