/* #include <stdio.h>*/

#include "rtp_defs.h"
#include "sendpacket.h"

/***************** Funktionen ************************************************
  writepacket
  
*****************************************************************************/


/***************** Anmerkung ************************************************/





/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- writepacket -- Schreibt ein RTP-Paket in ein File    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          Schreibt ein RTP-Paket in ein File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     FILE*      fileptr         Ausgabefile
 *                   u_char*    packetptr       Zeiger auf Bitstream
 *                   int        packetlen       Laenge des Bitstreams in Byte
 *                   
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int writepacket(FILE* fileptr, unsigned char* packetptr, int packetlen)
/***********************************************************CommentEnd********/
{
    int ii, byte, anz;
    unsigned long int plen;

    plen = (unsigned long int) packetlen;

    for (ii=BYTES_FOR_PACKLEN-1;ii>=0;ii--)
    {
        byte = (plen >> ii*8) & 0xff;
	fputc(byte, fileptr);
    }
    
    /* fprintf(fileptr, "%d",packetlen); */
    anz = fwrite(packetptr, 1, packetlen, fileptr);

    if (anz != packetlen)
    {
        printf("Fehler beim Schreiben in File. Nur %d von %d Bytes geschrieben.",anz,packetlen );
	return 1;
    }
    return 0;
};


