#include <string.h>
#include <assert.h>
#include "Codebooks.p"

#include "rtp_defs.h"
#include "conceal.h"
#include "filter.p"


/*
 * Print numbers of missing gobs.
 */
void showMissingH263Gobs(H263Global *h263Data)
{
    int ii;
    
    printf("\nMissing GOBs: ");              
    for (ii=0;ii<h263Data->gobs_in_pict;ii++)
        if (!h263Data->decGOBs[ii])
            printf("%d-", ii);
    printf("\n");
}
/*
 * Print numbers of missing gobs.
 */
void showMissingPyraGobs(PyraGlobal *pyraData)
{
    int ii;
    
    printf("\nMissing GOBs: ");
    for (ii=0;ii<pyraData->GOBs_in_pict;ii++)
        if (!pyraData->decGOBs[ii])
            printf("%d-", ii);
    printf("\n");
}

/*
 * Copies data (yuv) of a gob from the previous frame of the same layer.
 */
void H263GOBConceal(H263Global *h263Data)
{
    int gobsize = h263Data->mbs_in_gob * 16 * 16 * sizeof(unsigned char);


    memcpy(h263Data->newframe[0] + h263Data->gob * gobsize,
	   h263Data->oldrefframe[0] + h263Data->gob * gobsize, gobsize);
    gobsize /= 4;
    memcpy(h263Data->newframe[1] + h263Data->gob * gobsize,
	   h263Data->oldrefframe[1] + h263Data->gob * gobsize, gobsize);
    memcpy(h263Data->newframe[2] + h263Data->gob * gobsize,
	   h263Data->oldrefframe[2] + h263Data->gob * gobsize, gobsize);
}


/*
 * Conceals gob (packet) loss by copying data (yuv)
 *     - from the previous frame of the same layer OR
 *     - from the current frame of a lower layer
 */
void PyraGOBConceal(PyraGlobal *pyraData, int method)
{
    int gobsize = pyraData->MBs_in_GOB * MACROBLOCK_SIZE * MACROBLOCK_SIZE *
      sizeof(unsigned char);
    int mx, my, sx, sy;


    /*!!#if 0 */
    if (pyraData->baseLayerFlag || method == TEMP_CONCEALMENT) 
    {
        /* temporal concealment */
        memcpy(pyraData->DecPic->y + pyraData->GOBNumber * gobsize,
	       pyraData->TempRefPic->y + pyraData->GOBNumber * gobsize, gobsize);
	gobsize /= 4;
	memcpy(pyraData->DecPic->u + pyraData->GOBNumber * gobsize,
	       pyraData->TempRefPic->u + pyraData->GOBNumber * gobsize, gobsize);
	memcpy(pyraData->DecPic->v + pyraData->GOBNumber * gobsize,
	       pyraData->TempRefPic->v + pyraData->GOBNumber * gobsize, gobsize);
    } 
    else
    {
        /*!!#endif */
        /* spatial concealment */
        if (pyraData->width == pyraData->SpatRefPic->w) 
	{
  	    memcpy(pyraData->DecPic->y + pyraData->GOBNumber * gobsize,
  		   pyraData->SpatRefPic->y + pyraData->GOBNumber * gobsize, gobsize);
	    gobsize /= 4;
	    memcpy(pyraData->DecPic->u + pyraData->GOBNumber * gobsize,
		   pyraData->SpatRefPic->u + pyraData->GOBNumber * gobsize, gobsize);
	    memcpy(pyraData->DecPic->v + pyraData->GOBNumber * gobsize,
		   pyraData->SpatRefPic->v + pyraData->GOBNumber * gobsize, gobsize);
        } 
        else if (pyraData->width == pyraData->SpatRefPic->w << 1) 
        {
	    my = pyraData->GOBNumber * (MACROBLOCK_SIZE / 2);
	    sy = my >> 1;
	    for (mx = 0; mx < pyraData->MBs_in_GOB * (MACROBLOCK_SIZE / 2);
	         mx += (MACROBLOCK_SIZE / 2))
	    {
	        InterpolateBlock(pyraData->SpatRefPic->y, pyraData->DecPic->y,
		  	         mx, my, 8, 8,
			         pyraData->SpatRefPic->w, pyraData->SpatRefPic->h);
	        sx = mx >> 1;
	        InterpolateBlock(pyraData->SpatRefPic->u, pyraData->DecPic->u,
			         sx, sy, 4, 4, pyraData->SpatRefPic->w / 2,
			         pyraData->SpatRefPic->h / 2);
	        InterpolateBlock(pyraData->SpatRefPic->v, pyraData->DecPic->v,
			         sx, sy, 4, 4, pyraData->SpatRefPic->w / 2,
			         pyraData->SpatRefPic->h / 2);
	    }	   
        }
	/*!! #if 0 */
    }
    /*!! #endif */
}


/*
 * Checks every gob of the current frame.
 * If one is not decoded it is copied from the previous frame.
 * Finally, the number of decoded gobs is reset to 0.
 */
void H263PictureFinish(H263Global *h263Data)
{
    int gn;
    int n = 0;


    if (!h263Data->first)
    {
        for (gn = 0; gn < h263Data->gobs_in_pict; gn++)
	    if (!h263Data->decGOBs[gn]) 
	    {
	        h263Data->gob = gn;
		H263GOBConceal(h263Data);
		n++;
	    }

#if 0
	if (n == 1 && h263Data->decGOBs[0]) 
	{
	  /* We have only decoded the first GOB;
	     Thus we have to set GFID to an unreachable number.
	     In that way decoding can only continue with a new picture header. */
	    h263Data->gfid = 4;
	}
#endif

	memset(h263Data->decGOBs, 0, MAX_GOBS * sizeof(unsigned char));
	h263Data->decGOBsCounter = 0;
    }    
}

/*
 * If not a single gob is decoded 
 * Else every gob of the current frame is checked.
 * If one is not decoded it is copied from the previous frame.
 * Finally, the number of decoded gobs is reset to 0.
 */
void PyraPictureFinish(PyraGlobal *pyraData, int method)
{
    int gn;
    
    if (!pyraData->first) 
    {
        if (pyraData->decGOBsCounter == 0)
            MultInterpolateFastPictureSub(pyraData->dSize, pyraData->DecPic,
                                          pyraData->SpatRefPic);
   
	    /* ForwardSpatRef2DecPic(pyraData); */
	else 
	{
	    for (gn = 0; gn < pyraData->GOBs_in_pict; gn++)
            {
	        if (!pyraData->decGOBs[gn])
		{
		    pyraData->GOBNumber = gn;
		    PyraGOBConceal(pyraData, method);
		}
            }
	    memset(pyraData->decGOBs, 0, MAX_GOBS * sizeof(unsigned char));
	    pyraData->decGOBsCounter = 0;
	}
    }
}

/*--------------------------------------------------------------------------------
 * Strategies for concealment of gob loss
 * ('sc': spatial concealment
 *  'tc': temporal concealment)
 *--------------------------------------------------------------------------------
 */
void showConcealmentStrategies()
{
    printf("\nStrategies for concealment of gob loss:\n");

    printf("    baselayer:\n");
    printf("\t 1: - copy yuv and mv from last frame of that layer\n");
    printf("\t 2: ->1\n");
    printf("\t 3: ->1 \n");
    
    printf("    non-baselayer:\n");    
    printf("\t 1: - copy (interpolate) yuv and mv from lower layer\n");
    printf("\t 2: - copy (interpolate) yuv and mv from previous frame\n");
    printf("\t 3: - copy (interpolate) yuv and mv from lower layer\n");
}

void H263Concealment(H263Global *h263Data, char showConcealMessages, int strategy, int nl)
{

    if ( showConcealMessages )
        showMissingH263Gobs(h263Data);

    switch (strategy)
    {
      case 1:
      case 2:
          H263PictureFinish(h263Data);
          break;
      default:
          printf("\nWrong method of error concealment (%d)!\n", strategy);
          exit(1);
    }
}



void PyraConcealment(PyraGlobal *pyraData, char showConcealMessages, int strategy, int nl)
{
    if ( showConcealMessages )
        showMissingPyraGobs(pyraData);
    
    /*!! evtl. noch unterscheiden zw. non-/baselayer */

    switch (strategy)
    {
      case 1:
          PyraPictureFinish(pyraData, SPAT_CONCEALMENT);
          break;
      case 2:
          PyraPictureFinish(pyraData, TEMP_CONCEALMENT);
          break;
      default:
          printf("\nWrong method of error concealment (%d)!\n", strategy);
          exit(1);
    }
}

