/*
 * main.c - 
 *
 * 15.10.97, jw.
 */
/* #include <stdio.h> */
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>

#define DEFINE_GLOBALS
/*#define WITHOUT_NET */

/* #include "pyra/decoder/main.h" */

#include "options.h"
#include "config.h"	/* Options initializers */
#include "dispconf.h"	/* Options initializers */

#ifndef WITHOUT_NET
#include "openurl.h"	/* OpenUrl(), struct url_info */
#include <jittr/schedule.h>
#endif

/* Prototype files */
#include "h263decoder.h"
#include "pyradecoder.h"
#include "common.h"
#include "display.h"
#include "filter.p"

/*!! #include "HuffDecode.p" */
/*!!
#include "chacodec.h"
#include "chacodec.p"
*/
/*!! my includes */
#include <assert.h>
#include <bitOut.h>
#include "rtp_defs.h"
#include "structs.h"
#include "rtp.h"
/* #include "pyra.h" */
#include "readpack.h"
#include "reassemble.h"
#include "rtpsupport.h"
#include "conceal.h"
#include "statistics.h"
#include "decisions.h"
#include "measure_qual.h"
#include "rtpdec.h"
#include "main.h"

/*#define VERIFY_DEC_PICTURE*/

#ifndef ultra
/*extern void gettimeofday(struct timeval *, struct timezone *);*/
#endif
/*#ifdef sgi  ??
  extern int sched_timerdiff __P((struct timeval *, struct timeval *, struct timeval *));
#endif*/

typedef union Global_union {
  PyraGlobal *pyra;
  H263Global *h263;
} Global;

FILE *debugfp = stderr;
#ifdef DEBUG
/* FILE *debugfp = stderr;  herausgezogen aus ifdef wg. Problemen auf SGI */
char *debugfilename = NULL;
#endif

/* Define mbuiltins for jittr library */
struct mbuiltin *mbuiltins = NULL;

static OptionsStruct Init_Options =
{
  NULL,
  USE_VIS,
  USE_DGA,
  USE_SHM,
  DISPLAY,
  0,		/* Default for cover_window: use own toplevel */
  THREAD_YUV,
  GRAY,
  PSEUDOCOLOR,
  EXPAND,
  SIZE_QCIF,
  0,		/* Default for fps */
  LOOP,
  AUDIO
};

OptionsStruct Options;

#if defined(__sun) && defined(FILE)
# define memmove(d, s, n) bcopy(s, d, n)
#endif

static void ExitWithUsage(char *msg, int ret)
{
#define O(txt, def, opt) fprintf(stderr, "  -%s. Default: -%s%s.\n", txt, \
def ? "" : "no", opt);
  fprintf(stderr, "Usage: %s [-[no]option ...] file.pyra\n", Options.argv0);
#ifndef WITHOUT_DGA
  O("dga        Use Direct Graphics Access", USE_DGA, "dga");
#endif
  O("windowid   Use given window as parent", 1, " own toplevel");
  O("nodisplay  Don't show the decoded frames", DISPLAY, "display");
  O("expand     Double the size of the image", EXPAND, "expand");
  O("gray       Show video in grayscale", GRAY, "gray");
  O("noaudio    Disable audio", AUDIO, "audio");
/*  O("loop       Repeat the input stream infinitly", LOOP, "loop"); */
  O("pseudo     Show video in PseudoColor (8Bit)", PSEUDOCOLOR,
    "pseudo (TrueColor)");
  O("qcif       Show image in QCIF size", 1, SIZE_QCIF ? "qcif" : "cif");
#ifndef WITHOUT_SHM
  O("noshm      Don't use shared memory", USE_SHM, "shm");
#endif
#ifndef WITHOUT_THREADS
  O("threads    Spawn a thread for color conversion", THREAD_YUV, "threads");
#endif
#ifndef WITHOUT_VIS
  O("vis        Use UltraSparc Visual Instruction Set", USE_VIS, "vis");
#endif
  O("fps        If set, use given framerate", 1, "nofps (unlimited)");
  O("quiet      run in silence", 0, "not quiet");
  if (msg)
    fprintf(stderr, "\nHmmm: %s\n", msg);
  exit(ret);
}

#if 0 /* now defined in src/jlib/schedule.c */
/*
 * sched_timerdiff() returns the difference timeval in result, between future
 * and past.  If the diffeence is negative, result remains untouched and -1 is
 * returned.  Returns 0 on success.
 */
int
sched_timerdiff(result, future, past)
struct timeval *result, *future, *past;
{ 
  long s, u;
 
  s = future->tv_sec - past->tv_sec;
  if ((u = future->tv_usec - past->tv_usec) < 0)
    { 
      u += 1000000;
      s--;
    }
 
  if (s < 0)
    { 
      /* debug("sched_timerdiff: negative difference"); */
      return -1;
    }
  result->tv_sec = s;
  result->tv_usec = u;
  return 0;
}
#endif

/*
 * This WaitFrame() is not good for network transmissions.
 * Consider Buffers here!!!
 *
 * Returns negative, if too late.
 */
int
WaitFrame(int temp_ref, int fps)
{
  struct timeval tv, fut, now;

  static int prev_temp_ref = -100;
  static struct timeval prev_tv;

  if (!fps)
    return 0;

  if (!prev_tv.tv_sec)
    {
      prev_temp_ref = temp_ref;
      gettimeofday(&prev_tv, NULL);
      return 0;
    }
  
  if (fps < 0)
    {
      int i;

#if 1
      tv.tv_usec = 1001000/30;
#else
      tv.tv_usec = this->timebasenom / this->timebasedenom; /* FIXME */
#endif
      i = temp_ref - prev_temp_ref;
      prev_temp_ref = temp_ref;
      /* ASSERT(i == this->trd); */

      if (i < 0) i += 256;

      tv.tv_usec *= i;
      tv.tv_sec = tv.tv_usec / 1000000;
      tv.tv_usec -= 1000000 * tv.tv_sec;
    }
  else
    {
      tv.tv_usec = 1000000/fps;
      tv.tv_sec = 0;
    }
/*  debug1("frametime %d usec, ", (int)tv.tv_usec); */

  
  fut.tv_sec = tv.tv_sec + prev_tv.tv_sec;
  fut.tv_usec = tv.tv_usec + prev_tv.tv_usec;
  if (fut.tv_usec > 1000000)
    {
      fut.tv_sec++;
      fut.tv_usec -= 1000000;
    }

  prev_tv.tv_sec = fut.tv_sec;
  prev_tv.tv_usec = fut.tv_usec;

  gettimeofday(&now, NULL);
  if (sched_timerdiff(&tv, &fut, &now))
    {
      /* already too late */
      return -1;
    }
  select(0, NULL, NULL, NULL, &tv); 
/*  debug1("waiting %d usec\n", (int)tv.tv_usec); */
  return 1;
}


/* *************************************************************************/
/* *************************************************************************/
int VerifyDecPic(int *method, Global *these, int nl, int t)
{
  char    decPictName[100];
  int     trel;
  int     errorPos;
  Picture *decPic, *inPic;


  decPic = (Picture *)malloc(sizeof(Picture));

  switch (method[nl]) {
  case H263:
    trel = (t == 0) ? 0: (t / these[nl].h263->trd);
    decPic->w = these[nl].h263->coded_picture_width;
    decPic->h = these[nl].h263->coded_picture_height;
    decPic->y = these[nl].h263->newframe[0];
    decPic->u = these[nl].h263->newframe[1];
    decPic->v = these[nl].h263->newframe[2];
    break;
  case PYRA:
    trel = (t == 0) ? 0 : (t / these[nl].pyra->trd);
    decPic->w = these[nl].pyra->DecPic->w;
    decPic->h = these[nl].pyra->DecPic->h;
    decPic->y = these[nl].pyra->DecPic->y;
    decPic->u = these[nl].pyra->DecPic->u;
    decPic->v = these[nl].pyra->DecPic->v;
    break;
  }

  inPic = AllocPicture(decPic->w, decPic->h);

  sprintf(decPictName, "decPict%d", nl);
  ReadPicture(decPictName, CAT_SEQ_TYPE, trel, inPic);
  if ((errorPos = FindFirstDifferenceBetweenPictures(inPic, decPic)) >= 0) {
    printf("Fehler bei Layer >%d<, t = %d;  Position %d\n", nl, t, errorPos);
  }

  /* Free memory */
  free(decPic);
  FreePicture(inPic);

  return(errorPos);
}


/* *************************************************************************/
/* *************************************************************************/
int InitLayerReferences(int *method, Global *these, int nl, int lastDecLayer)
{
  /* assert(lastDecLayer<maxlayers_); */
  if (!these[nl].pyra)
    return 0;
  if ((lastDecLayer >= 0) && (!these[lastDecLayer].h263))
    return 0;

  /*  */
  if (lastDecLayer >= 0 && !these[nl].pyra->first) {
    switch (method[lastDecLayer]) {
    case H263:
      if (these[lastDecLayer].h263->first)
	return 0;
      MV2MVField(these[lastDecLayer].h263->MV,
		 these[lastDecLayer].h263->modemap,
		 these[lastDecLayer].h263->coded_picture_width / 16,
		 these[lastDecLayer].h263->trd, 
		 these[nl].pyra->mvf,
		 these[nl].pyra->trd);
      break;
    case PYRA:
      if (these[lastDecLayer].pyra->first)
	return 0;
      SampleUpMVField(these[lastDecLayer].pyra->mvf,
		      these[lastDecLayer].pyra->trd, 
		      these[nl].pyra->mvf,
		      these[nl].pyra->trd);
      break;
    default: assert(0);
    }
  }

  if (lastDecLayer < 0)
    lastDecLayer = nl + 1;
  if (!these[lastDecLayer].h263)
    return 0;


  switch (method[lastDecLayer]) {
  case H263:
    if (!these[lastDecLayer].h263->newframe[0])
      return 0;
    these[nl].pyra->SpatRefPic->w = these[lastDecLayer].h263->coded_picture_width;
    these[nl].pyra->SpatRefPic->h = these[lastDecLayer].h263->coded_picture_height;
    these[nl].pyra->SpatRefPic->ws = these[lastDecLayer].h263->coded_picture_width;
    these[nl].pyra->SpatRefPic->hs = these[lastDecLayer].h263->coded_picture_height;
    these[nl].pyra->SpatRefPic->y = these[lastDecLayer].h263->newframe[0];
    these[nl].pyra->SpatRefPic->u = these[lastDecLayer].h263->newframe[1];
    these[nl].pyra->SpatRefPic->v = these[lastDecLayer].h263->newframe[2];
    break;
  case PYRA:
    if (!these[lastDecLayer].pyra->DecPic)
      return 0;
    LinkPicture(these[lastDecLayer].pyra->DecPic, these[nl].pyra->SpatRefPic);
    break;
  default:
    /* happens, when we are right into the middle of a decoding
       run. */
    return 0;
  }
  return 1;
}



/* *************************************************************************/
/* *************************************************************************/
void PrintRtpDecInfo(RtpDecInfo *dInfo) {
    /*int i; */


  printf("\nOPTIONS:\n");
#if 0
  /* Layer frame frequencies */
  printf("\t-f <num0> <num1> ... <num%d>  frequencies used for the layers\n",
	 NUM_LAYERS);
  printf("\t   ");
  for (i = 0; i < NUM_LAYERS; i++)
    printf("[%d]   ", dInfo->freq[i]);
  printf("\n\t   The numbers give the factors by which the\n"
	 "\t     original frequency is divided\n");
  printf("\t     These numbers are only used in case of packet loss\n");
  /* Layer start offset */
  printf("\t-sO <num0> <num1> ... <num%d>  start offsets used for the "
	 "layers\n", NUM_LAYERS);
  printf("\t   ");
  for (i = 0; i < NUM_LAYERS; i++)
    printf("[%d]   ", dInfo->startOffset[i]);
  printf("\n\t   The numbers give the original frame number in which the "
	 "layer starts.\n");
  printf("\t     These numbers are only used in case of packet loss\n");

  /* Packet size */
  printf("\t-pS  <num> packet size [%d]\n", dInfo->packetSize);
  /* Packet loss */
  printf("\t-pL  <num0 <num1> ... <num%d>  packet loss percentage\n",
	 NUM_LAYERS);
  printf("\t   ");
  for (i = 0; i < NUM_LAYERS; i++)
    printf("[%d]   ", dInfo->percentLoss[i]);
#endif
  
  /* Display */
  printf("\t-dF turn off the display\n");
  printf("\t-dS <num> display size [%d]\n", dInfo->displaySize);
  printf("\t    SQCIF: 1\n");
  printf("\t    QCIF : 2\n");
  printf("\t    CIF  : 3\n");
  printf("\t    CIF4 : 4\n");
  printf("\t    CIF16: 5\n");
  printf("\t-windowid <num> window ID (0: use top level window) [%ld].\n",
	 dInfo->windowid);
  /* General */
  printf("\t-fps <num> frames per second [%d] (0: as fast as possible)\n",
	 dInfo->fps);
  printf("\t-quiet run quietly (default: verbose)\n");
  printf("\t-w <filename> write complete decoded sequence to file\n"); /* NEU */
#if 0
  printf("\t-packrs decode reed solomon packed bitstream (default: off)\n");
  printf("\t-irs <rscodeddatafilename>  reed solomon input file (default: codeddata)\n");
#endif
  
  /* Concealment (NEU) */
  printf("\t-cS <num> concealment strategy [%d]\n", DEFAULT_STRATEGY);
  printf("\t-nrl <num> number of relevant previous losses for concealment [%d]\n", DEFAULT_MAX_LOSS_QUOTAS);
  printf("\t-mcl <num> maximum current gob loss (%%) for concealment [%d]\n", DEFAULT_MAX_PERCENT_LOSS);
  printf("\t-mal <num> maximum accumulated gob loss (%%) for concealment [%d]\n", DEFAULT_MAX_PERCENT_LOSS_SUM);
  printf("\t-plf <num> fading of the influence of previous losses on display decision [%f]\n", DEFAULT_PREV_LOSS_FADING);
  printf("\t-clw <num> weighting of current loss for display decision [%f]\n", DEFAULT_CUR_LOSS_WEIGHT);
  printf("\t-psnr <num0> <num1> ... <num%d> average PSNR values of different layers\n", NUM_LAYERS);

  printf("\t-cM print/avoid messages concerning concealment [%d] (0: no messages) \n", DEFAULT_CONCEAL_MESSAGES);
  printf("\t-dC <num> criterium if layer should (not) be displayed [%d] \n", DEFAULT_DISPLAY_CRITERIUM);
  printf("\t-dW <num> wait (at least) num timesteps until layer is switched on again [%d] \n", DEFAULT_DISPLAY_WAIT);
  printf("\t-w <filename> write decoded pictures in yuv-format to specified file \n");
  printf("\t-ref <filename> reference file to compute objective quality measure \n");
  printf("\t-q <num> method to compute objective quality measure [%d]\n", DEFAULT_QUAL_MEAS_METHOD);
  printf("\t    PSNR : 1\n");
  showConcealmentStrategies();
  showDisplayCriteria();
}


void Usage(char *argv[]) {
  printf("\nScalVico decoder (version 1.0)\n");
  printf("Copyright (c) 1998 LNT, Uni Erlangen, Germany\n");
  printf("Type <%s -H> for advanced help\n", argv[0]);
  printf("Usage: %s\n", argv[0]);
}


void VerboseUsage(int argc, char *argv[], RtpDecInfo *dInfo) {
  int i;

  for(i=0; *(argv+i) != NULL; ++i) {
    /* Help utilities */
    if((!strcmp(argv[i],"-help")) || (!strcmp(argv[i],"-H")) 
       || (!strcmp(argv[i],"-U"))) {
      Usage(argv);
      printf("Options:\n");
      PrintRtpDecInfo(dInfo);
      printf("\n\tDefault options in square brackets are specified in "
	     "main.h\n");
      printf("\n\tFor the Options that need a number for each layer you "
	     "have to specify\n\t*exactly* >%d< numbers!\n", NUM_LAYERS);
      exit(0);
    }
    if((!strcmp(argv[i],"-h")) || (!strcmp(argv[i],"-u"))) {
      Usage(argv);
      exit(0);
    }
  }
}


RtpDecInfo *NewRtpDecInfo()
{
  int         i;
  RtpDecInfo     *dInfo = (RtpDecInfo *)malloc(sizeof(RtpDecInfo));


  if(!dInfo)
    exit(-1);

  /* Layer configuration */
  for (i = 0; i < NUM_LAYERS; i++) {
    dInfo->freq[i]         = DEFAULT_FREQ_0 << i;
    dInfo->startOffset[i]  = DEFAULT_START_OFFSET_0;
  }

  /* Transmission configuration */
  dInfo->packetSize = DEFAULT_PACKET_SIZE;
  for (i = 0; i < NUM_LAYERS; i++) {
    dInfo->percentLoss[i] = DEFAULT_PERCENT_LOSS;
  }

  /* General configurations */
  dInfo->displayFormat   = DEFAULT_DISPLAY_FORMAT;
  dInfo->displaySize     = DEFAULT_DISPLAY_SIZE;
  dInfo->windowid        = DEFAULT_WINDOWID;
  dInfo->fps = DEFAULT_FRAMES_PER_SECOND;
  dInfo->quiet = DEFAULT_QUIET_FLAG;
  /*!!dInfo->packrs= DEFAULT_PACKRS;
  dInfo->fp_pack = fopen(DEFAULT_CODEDDATAFILE, "r");
  dInfo->fp_pack = NULL;*/
  dInfo->yuvWrite = DEFAULT_YUV_WRITE_FLAG;
  dInfo->yuvOutFile = DEFAULT_YUV_OUT_FILE;
  dInfo->compQualMeas = DEFAULT_COMP_QUAL_MEAS;
  dInfo->yuvRefFile = DEFAULT_YUV_REF_FILE;
  dInfo->qualMeasMethod = DEFAULT_QUAL_MEAS_METHOD;


  return(dInfo);
}

void initConcealDispVal(concealDispVal *cd)
{
    int ii;
    
    cd->strategy = DEFAULT_STRATEGY;
    cd->considered = DEFAULT_MAX_LOSS_QUOTAS;
    cd->maxP100Loss = DEFAULT_MAX_PERCENT_LOSS;
    cd->maxP100LossSum = DEFAULT_MAX_PERCENT_LOSS_SUM;
    cd->ConcealMessages = DEFAULT_CONCEAL_MESSAGES;
    cd->displayCriterium = DEFAULT_DISPLAY_CRITERIUM;
    cd->displayWait = DEFAULT_DISPLAY_WAIT;
    cd->prevLossFading = DEFAULT_PREV_LOSS_FADING;
    cd->curLossWeight = DEFAULT_CUR_LOSS_WEIGHT;
    for (ii=0;ii<NUM_LAYERS;ii++)
        cd->psnr[ii] = DEFAULT_PSNR - 2 * ii;
}

layerDecData *NewLayerDecData()
{
    int i;
    layerDecData *cldd;
    
    /* allocate memory */
    /*!! IMPORTANT: array slot_f in layerDecData must be initialised to zero -> calloc */
    cldd = (layerDecData*) calloc(1, sizeof(layerDecData));
    for(i=0;i<B_SLOTS;i++)
        cldd->slot[i].bp = (unsigned char*) malloc(MAX_PACKETSIZE * sizeof(char));
    
    cldd->recpackets = 0;
    cldd->lostpackets = 0;
    cldd->handledpackets = 0;
    cldd->thrownawaypackets = 0;
    cldd->recframenr = 0;
    cldd->pcktsinbuf = 0;
    cldd->state = LOOK_FOR_PIC_SYNC;
    cldd->prevDecTime = 0xffffffff; /*!!evtl. weglassen oder sinnvollen Wert*/
    cldd->lastseqno = -42;          /* (lastseqno+1) must be invalid seqno */
    cldd->picCodType = PICTURE_CODING_TYPE_UNKNOWN;
    cldd->accuPercentLoss = 0;

    return cldd;
}

/*
 * Write command line to file.
 * Purpose: documentation of parameters used for generating the output sequence file.
 */
void WriteDecodeInfo(int argc, char *argv[], RtpDecInfo *dInfo, concealDispVal *cd)
{
    int ii, len, havepath=0;
    char docuname[MAX_PATHNAME_LEN + MAX_FILENAME_LEN];
    FILE *docu;
    
    /* generate name of documentation file */
    strcpy(docuname, dInfo->yuvOutFile);
    len = strlen(docuname);
    for (ii=len-1;ii>=0;ii--)
    {
        if (docuname[ii] == '/')
        {
            docuname[ii+1] = '\0';
            havepath = 1;
            break;
        }
    }
    if (havepath)
        strcat(docuname, DOCU_FILENAME);
    else
        strcpy(docuname, DOCU_FILENAME);
    printf("Write documentation to file '%s'.\n", docuname);
    
    /* open docu file */
    if (!(docu = fopen(docuname, "a+")))
        printf("Can't open docu file '%s'. Exiting.\n", docuname), exit(1);

    /* write command line and some parameters to file */
    fprintf(docu, "%s:\n", dInfo->yuvOutFile);
    for (ii=0; ii<argc;ii++)
        fprintf(docu, "%s ", argv[ii]);
    fprintf(docu, "\ndisplay size:\t%d\n", dInfo->displaySize);
    fprintf(docu, "concealment strategy:\t%d\n", cd->considered);
    fprintf(docu, "max. current loss:\t%d\n", cd->maxP100Loss);
    fprintf(docu, "max. accu. loss:\t%d\n", cd->maxP100LossSum);
    fprintf(docu, "display criterium:\t%d\n", cd->displayCriterium);
    fprintf(docu, "min. wait period:\t%d\n\n\n", cd->displayWait);
    fclose(docu);
}


char **EvaluateArgumentsRtpDecInfo(int argc, char *argv[], RtpDecInfo *dInfo, concealDispVal *cd)
{
  int j;
  /*!!char codeddataname[80];  */

  argv++;
  argc--;
  while(*argv && **argv == '-' && argv[0][1]) {
    /* Layer frame frequencies */
    if(!strcmp(*argv,"-f")) {
      argv++;
      for (j = 0; j < NUM_LAYERS; j++) {
	if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
	dInfo->freq[j] = atoi(*argv++);
      }
      continue;
    }
    /* Layer start offset */
    if(!strcmp(*argv,"-sO")) {
      argv++;
      for (j = 0; j < NUM_LAYERS; j++) {
	if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
	dInfo->startOffset[j] = atoi(*argv++);
      }
      continue;
    }

    /* Transmission configuration */
    /* Packet size */
    if(!strcmp(*argv,"-pS")) {
      if(--argc < 0) {Usage(argv); printf("%d\n",argc); exit(0);}
      argv++;
      dInfo->packetSize = atoi(*argv++);
      continue;
    }
    /* Percentage packet loss */
    if(!strcmp(*argv,"-pL")) {
      argv++;
      for (j = 0; j < NUM_LAYERS; j++) {
	if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
	dInfo->percentLoss[j] = atoi(*argv++);
      }
      continue;
    }

    /* Switch display */
    if(!strcmp(*argv,"-dF")) {
      argv++;
      dInfo->displayFormat = !(dInfo->displayFormat);
      continue;
    }
    /* Display size */
    if(!strcmp(*argv,"-dS")) {
      if(--argc < 0) {Usage(argv); printf("%d\n",argc); exit(0);}
      argv++;
      dInfo->displaySize = atoi(*argv++);
      continue;
    }
    if(!strcmp(*argv,"-qcif")) {
      argv++;
      dInfo->displaySize = QCIF;
      continue;
    }
    if(!strcmp(*argv,"-cif")) {
      argv++;
      dInfo->displaySize = CIF;
      continue;
    }
    /* Window ID */
    if(!strcmp(*argv,"-windowid") || !strcmp(*argv,"-id") ||
       !strcmp(*argv,"-window")) {
      if(--argc < 0) {Usage(argv); printf("%d\n",argc); exit(0);}
      argv++;
      dInfo->windowid = strtol(*argv++, NULL, 0);
      continue;
    }
    /* Frames per second */
    if(!strcmp(*argv,"-fps")) {
      if(--argc < 0) {Usage(argv); printf("%d\n",argc); exit(0);}
      argv++;
      dInfo->fps = atoi(*argv++);
      continue;
    }
    /* Switch quiet flag */
    if(!strcmp(*argv,"-quiet")) {
      argv++;
      dInfo->quiet = 1;
      continue;
    }

#if 0
    /* Packet Stream */
    if(!strcmp(*argv,"-packrs")) {
      argv++;
      dInfo->packrs = 1;
      continue;
    }
    /* rs inputfile */
    if(!strcmp(*argv,"-irs")) {
      sprintf(codeddataname, "%s", *(++argv));
      if ( (dInfo->fp_pack = fopen(codeddataname, "r")) == NULL ) {
	fprintf(stderr,"Error in %s: can't open %s for reading.\n", argv[0], codeddataname);
	exit(1);
	break;
      }else{
	argv++;
	continue;
      }
    }
#endif

    /*!! NEW SWITCHES */
    /* concealment strategy */
    if(!strcmp(*argv,"-cS")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->strategy = atoi(*argv++);
      continue;
    }
    /* number of relevant previous losses  */
    if(!strcmp(*argv,"-nrl")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->considered = atoi(*argv++);
      continue;
    }
    /* maximum current gob loss in percent for concealment  */
    if(!strcmp(*argv,"-mcl")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->maxP100Loss = atoi(*argv++);
      continue;
    }
    /* maximum accumulated gob loss (in percent) for concealment  */
    if(!strcmp(*argv,"-mal")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->maxP100LossSum = atoi(*argv++);
      continue;
    }
    /* fading of the influence of previous MB/GOB-losses on display decision */
    if(!strcmp(*argv,"-plf")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->prevLossFading = atof(*argv++);
      continue;
    }
    /* weighting factor for current MB-loss */
    if(!strcmp(*argv,"-clw")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->curLossWeight = atof(*argv++);
      continue;
    }
    /* PSNR-values for different layers */
    if(!strcmp(*argv,"-psnr")) {
      argv++;
      for (j = 0; j < NUM_LAYERS; j++)
      {
          if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
          cd->psnr[j] = atof(*argv++);
      }
      continue;
    }
    /* print/avoid messages concerning concealment (default) */
    if(!strcmp(*argv,"-cM")) {
      argv++;
      cd->ConcealMessages = 1 - DEFAULT_CONCEAL_MESSAGES;
      continue;
    }
    /* display criterium */
    if(!strcmp(*argv,"-dC")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->displayCriterium = atoi(*argv++);
      continue;
    }
    /* display criterium */
    if(!strcmp(*argv,"-dW")) {
      argv++;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      cd->displayWait = atoi(*argv++);
      continue;
    }
    /* write decoded pictures to specified file */
    if(!strcmp(*argv,"-w")) {
      argv++;
      dInfo->yuvWrite = 1;
      if(--argc < 0) {Usage(argv-1); printf("%d\n",argc); exit(0);}
      dInfo->yuvOutFile = *argv++;
      continue;
    }
    /* reference file to compute objective quality measure */
    if(!strcmp(*argv,"-ref")) {
      argv++;
      dInfo->compQualMeas = 1;
      dInfo->yuvRefFile = *argv++;
      continue;
    }
    /* objective quality measure */
    if(!strcmp(*argv,"-q")) {
      if(--argc < 0) {Usage(argv); printf("%d\n",argc); exit(0);}
      argv++;
      dInfo->qualMeasMethod = atoi(*argv++);
      continue;
    }

    printf("Unknown option '%s'\n", *argv);
    PrintRtpDecInfo(dInfo);
    exit(1);
    break;
  }
  return(argv);
}


/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- PDecoder -- Scalable pyramid decoder (ScalVico)
 *
 * Author:      K.S.
 *	        
 * Created:     3-Feb-98
 *	        
 * Purpose:     -
 * 	        
 * Options:     -f  <num> <num> <num> <num> Layer frame frequencies
 *                  [1] [2] [4] [8]
 *              -sO <num> <num> <num> <num> start offset
 *                  [0] [0] [0] [0]
 *              -pS <num> packet size *                  [1024]
 *              -pL <num> <num> <num> <num> percentage packet loss
 *                  [0] [0] [0] [0]
 *              -dF turn off the display
 *              -dS <num> display size
 *                  SQCIF: 1
 *                  QCIF : 2
 *                  CIF  : 3
 *                  CIF4 : 4
 *                  CIF16: 5
 *              -fps <num> frames per second (0: as fast as possible).
 *	        -quiet run quietly
 *              -packrs decode rs-Bitstream
 *
 *	        Default options in square brackets are specified in main.h
 *
 *
 * Description: Call:
 *                      PDecoder <options> bitstream0 bitstream1 ...
 *              If 'pecentage packet loss == 0', the frame frequencies and
 *              the start offset are read from the bitstreams.
 *              But in a error prone environment this arguments have to be
 *              properly set.
 *
 * See also:    -
 *
 * Modified:    -
 *
 *****************************************************************************/
void main(int argc, char *argv[])
/***********************************************************CommentEnd********/
{
    RtpDecInfo        *dInfo = NewRtpDecInfo();
    int lastDecLayer;
    int nLayers, nl;
    int method[NUM_LAYERS];
    Global these[NUM_LAYERS];
    FILE *stream[NUM_LAYERS],     /* packet stream files */
        *yuvRefFile, *measFile;      /* reference and output file for quality measurement */
    char *streamnamePtr[NUM_LAYERS];
    int cont = 0;                 /* Bit x set to 0, if no more data available/expected for layer x */
    Picture picture, *pic,
        *dispPict,                /* only used if up/downsampling necessary */
        *realDispPict,            /* always points to displayed picture */
        *refPict;                 /* reference picture for quality measurement purposes */
    layerDecData *ldd[NUM_LAYERS];
    concealDispVal *cd = (concealDispVal *) malloc(sizeof(concealDispVal));
    RtpHeader *rh;
    PyraLayerRtpHeader xprh, *prh;
    int eof_flag, seqno, curpacklen;
    unsigned long time, starttime, presentmask, firstlong, fileind=0;
    unsigned char curpacket[MAX_PACKETSIZE];
    int targetcc;                 /* character count (length) of targetbp */
    unsigned char *targetbp;      /* bitstream pointer for complete gob(s) */
    int completegoblen=0;         /* length of completegobs (modified due to needs) */
    unsigned char *completegobs;  /* memory to combine split gobs */
    int havebase;
    int getpackets=0;             /* Bit x set to 1, if packets should be read for layer x */
    int fileend=0;                /* Bit x set to 1, if end of file reached for layer x */
    int gotdata=0;		  /* Bit x set to 1, if current data available for layer x */
    char **argvBck = argv;
    int dSize;
    
    /****************** end of declarations ******************/
    
    SetupPyraTables();
    /* InitFilters(MAX(CIF_WIDTH,dispPict->w), MAX(CIF_HEIGHT,dispPict->h)); */
    /* InitInterpolator(); */
    
    Options = Init_Options; 	/* struct copy */
    Options.argv0 = argv[0];
    
    /* initialize concealDispVal with default values */
    initConcealDispVal(cd);
    
    /* Evalute command line arguments and/or print usage */
    argv = EvaluateArgumentsRtpDecInfo(argc, argv, dInfo, cd);
    VerboseUsage(argc, argv, dInfo);

    /* Write command line and used parameters for decoding to docu file */
    if (dInfo->yuvWrite)
        WriteDecodeInfo(argc, argvBck, dInfo, cd);
    
    /* Set options struct */
    Options.cover_window = dInfo->windowid;
    Options.fps = dInfo->fps;
    
    /* Print a short hello message */
    if (!dInfo->quiet) {
        printf("\n\n                  ScalVico\n\n");
        printf("    Uwe Horn, Jrgen Weigert, Klaus Stuhlmller\n\n\n");
    }

    if (!Options.fps && !dInfo->quiet)
    {
        if (Options.audio)
            fprintf(stderr, "Audio disabled, -fps missing.\n");
        Options.audio = 0;
    }
    

    /* Open input files */
    if (!*argv)
        ExitWithUsage("Name of input file is missing.", 0);
    for (nLayers = 0; nLayers < NUM_LAYERS && *argv; nLayers++, argv++) 
    {
#ifdef WITHOUT_NET
        streamnamePtr[nLayers] = *argv;

        if (!(stream[nLayers] = fopen(streamnamePtr[nLayers], "r")))
            fprintf(stderr, "%s: ", *argv),perror("fopen"),exit(0);
#else
	struct url_info u;
        int filedes;       /* file descriptor */
        streamnamePtr[nLayers] = *argv;

        filedes = OpenUrl(*argv, &u, 0);
        if (filedes < 0 || !(stream[nLayers] = fdopen(filedes, "r")))  /*!! O_RDONLY aus <fcntl.h> statt 0 verwenden */
            fprintf(stderr, "%s: ", *argv),perror("fopen"),exit(0);
	if (!dInfo->quiet)
            fprintf(stderr, "mime/type: %s, length=%d, mtime='%s'\n",
                    u.mime->buf, u.len, u.modified ? u.modified->buf : "<>");
	FreeUrlInfo(&u);
#endif
    }

    if (dInfo->compQualMeas)
    {
        refPict = AllocPicture(REF_PICTURESIZE_W, REF_PICTURESIZE_H);
        if ((yuvRefFile = fopen(dInfo->yuvRefFile, "r")) == NULL)
            printf("\nCan't open file '%s' for reading.\n", dInfo->yuvRefFile), exit(1);
        /* generate file name for measure file */
        if ((measFile = fopen(DEFAULT_MEAS_FILENAME, "w+")) == NULL)
            printf("\nCan't open file '%s' for writing.\n", DEFAULT_MEAS_FILENAME), exit(1);
    }
    
    /**************************************/
    /********** Initializations ***********/
    /**************************************/
    completegoblen = 10;  /* chosen some value; value 10 has no meaning */
    completegobs = (unsigned char*) malloc(completegoblen * sizeof(char));
    for (nl = nLayers-1; nl >= 0; nl--)
    {
        SETBIT(cont, nl);
        SETBIT(getpackets, nl);
        
        /* generate structure */
        ldd[nl] = NewLayerDecData();
        ldd[nl]->stream = stream[nl];
        ldd[nl]->psnr = cd->psnr[nl];
        printf("\nLayer %d: psnr = %f.\n", nl, cd->psnr[nl]);
        
        /* read first packet for every layer */
        eof_flag = readpacket(ldd[nl]->stream, curpacket, &curpacklen);
        if (eof_flag)
            SETBIT(fileend, nl);
        ldd[nl]->pcktsinbuf++;
        ldd[nl]->recpackets++;
        
        /* Decide on method (by looking at the first sync) */
        method[nl] = guess_layertype(curpacket+sizeof(RtpHeader));
        ldd[nl]->layertype = method[nl];
        
        switch( method[nl] ) 
        {
          case H263_ID:
              if (!dInfo->quiet)
                  printf("Type of bitstream in stream %s is H.263.\n", streamnamePtr[nl]);
              these[nl].h263 = NewH263DecoderNoBuffer();
              these[nl].h263->quiet = dInfo->quiet;
              /* these[nl].h263->trd = dInfo->freq[nl]; */
              these[nl].h263->trd = H263_LAYERFREQ_INI;
              ldd[nl]->layernr = nLayers -1;
              break;
          case PYRA_ID:
              if (!dInfo->quiet)
                  printf("Type of bitstream in stream %s is Pyra.\n", streamnamePtr[nl]);
              these[nl].pyra = NewPyraDecoderNoBuffer();
              prh = (PyraLayerRtpHeader*) (curpacket+sizeof(RtpHeader));
              /* these[nl].pyra->trd = dInfo->freq[nl]; */
              these[nl].pyra->trd = prh->tempdist;
              ldd[nl]->layernr = prh->layernr;   
              break;
          default:
              fprintf(stderr, "Stream %s contains undecodable data\n", streamnamePtr[nl]);
              assert(0);
        }
        
        rh = (RtpHeader*) curpacket;
        seqno = rh->rh_seqno;
        if (nl == nLayers-1)
        {
            starttime = rh->rh_ts;
            ldd[nl]->wait = 0;
        }
        else 
        {
            if (rh->rh_ts >= starttime)
            {
                ldd[nl]->wait = rh->rh_ts - starttime;
            }
            else
            {
                printf("Warning: In layer %d: offset < 0 (%d)\n.", nl, ldd[nl]->wait);
                assert(0);
            }
        }
        checkInPacket(&ldd[nl]->slot[seqno & B_SLOTMASK], curpacket, curpacklen, ldd[nl]->layertype, seqno);
        ldd[nl]->slot_f[seqno & B_SLOTMASK] = 1;        
    }

    /* init temporal reference distance for H.263 */
    if (nLayers > 1)
        these[nLayers-1].h263->trd = 2 * these[nLayers-2].pyra->trd;

    if (!dInfo->quiet)
        printf("\nnLayers is %d, starttime is %3lu (%lu).\n", nLayers, starttime&0xff, starttime);
    
    /* init_display */
    switch (dInfo->displaySize) {
      case QCIF:
          Options.qcif = 1;
          init_display(176, 144);
          dispPict = AllocPicture(176, 144);
          break;
      case CIF:
          init_display(352, 288);
          dispPict = AllocPicture(352, 288);
          break;
      case CIF4:
          init_display(704, 576);
          dispPict = AllocPicture(704, 576);
          break;
      default:
          fprintf(stderr, "PDecoder: display size >%d< not supported\n",
                  dInfo->displaySize);
          exit(1);
    }
    InitFilters(MAX(CIF_WIDTH,dispPict->w), MAX(CIF_HEIGHT,dispPict->h)); /* NEU */

    printf("\nprevLossFading: %f, curLossWeight: %f.\n", cd->prevLossFading, cd->curLossWeight);
        
    /***************************************/
    /************** Film loop **************/
    /***************************************/
    for (time = starttime; cont; time++)
    {
#if 0
        if (!dInfo->quiet)
            printf("***************** Time %4lu *****************\n",time/*&0xff*/);
        else
            printf("\rt: %4lu", time/*&0xff*/);
#endif
        /* loop initializations */
        havebase=0; presentmask = 0; gotdata = 0;
        
        /* read packets for current time */
        getFrame(these[nLayers-1].h263, ldd, dInfo, time, nLayers, &getpackets, &fileend, &gotdata);
        
        /******************************************/
        /*************** Layer loop ***************/
        /******************************************/
        lastDecLayer = -1;
        for (nl = nLayers - 1; nl >= 0; nl--) 
        {
            ldd[nl]->picCodType = PICTURE_CODING_TYPE_UNKNOWN;          

            /*decision: decode layer or throw packets away */
            if (READBIT(gotdata, nl)) 
            {
                if (ldd[nl]->layertype == LAYERTYPE_H263)
                    H263DecodeDecision(these[nl].h263, ldd, cd, time, &gotdata, nl);
                else
                    PyraDecodeDecision(these[nl].pyra, ldd, cd, time, &gotdata, nl);
            }
            
            /* if we got data decode it
               else check if still data is to be expected for this layer */
            if (READBIT(gotdata, nl)) 
            {
                int	layerpresent = 0;
	    
                ldd[nl]->recframenr++;
                if (!dInfo->quiet)
                    printf("Layer %d, frame %5lu:\n",ldd[nl]->layernr, ldd[nl]->recframenr);
                
                /*!! Beginn des neuen, zu modifizierenden Teils */
                if (!these[nl].pyra) 
                {
                    printf("c");
                    continue;
                }
                /* ldd[nl]->layeruncoded++; */

                /* don't call this for H.263 in any case */
                if (nl<nLayers-1)
                    if (!InitLayerReferences(method, these, nl, lastDecLayer))
                        continue;
                
                /********** handle H263/Pyra-layer **********/
                switch( ldd[nl]->layertype )
                {
                  case LAYERTYPE_H263:
                      assert(nl==nLayers-1);
	      
                      /* reset counter and flags of decoded gobs */
                      these[nl].h263->decGOBsCounter = 0;
                      memset(these[nl].h263->decGOBs, 0, MAX_GOBS * sizeof(unsigned char));
                      
                      /* handle all current packets */
                      while(reassemble_h263_gobs(&targetbp,&targetcc,time,		      
                                                 ldd[nl], &completegobs, &completegoblen)) 
                      {
                          layerpresent = 1;
                          SETBIT(presentmask, nl);
                          
                          firstlong = (targetbp[0]<<24)+(targetbp[1]<<16)+(targetbp[2]<<8)+targetbp[3];
                          assert((firstlong & 0xffff8000) == 0x00008000);
                          HandleH263CompleteGOBs(these[nl].h263,targetbp,targetbp+targetcc);
                      }
                      

                      picture.w = these[nl].h263->coded_picture_width;
                      picture.h = these[nl].h263->coded_picture_height;
                      picture.ws = these[nl].h263->coded_picture_width;
                      picture.hs = these[nl].h263->coded_picture_height;
                      if (these[nl].h263->pb_frame) 
                      {
                          picture.y = these[nl].h263->bframe[0];
                          picture.u = these[nl].h263->bframe[1];
                          picture.v = these[nl].h263->bframe[2];
                      }
                      picture.y = these[nl].h263->newframe[0];
                      picture.u = these[nl].h263->newframe[1];
                      picture.v = these[nl].h263->newframe[2];
                      
                      /*!!if (layerpresent) */
                      /* error concealment */
                      if (these[nl].h263->decGOBsCounter < these[nl].h263->gobs_in_pict)
                      {
                          printf("\n->->Layer %d: incomplete (%d/%d).\n", nl, 
                                 these[nl].h263->decGOBsCounter, these[nl].h263->gobs_in_pict);
                          H263Concealment(these[nl].h263, cd->ConcealMessages, cd->strategy, nl);
                      }
                      
                      if (1)
                      {
                          pic = &picture;
                      }
                      break;
                  case LAYERTYPE_PYRA:
                      assert(nl!=nLayers-1);
                      
                      /* reset counter and flags of decoded gobs */
                      these[nl].pyra->decGOBsCounter = 0;
                      memset(these[nl].pyra->decGOBs, 0, MAX_GOBS * sizeof(unsigned char));
                      
                      /* handle all current packets */
                      while (reassemble_pyra_gobs(&targetbp,&targetcc,time,&xprh,
                                                  ldd[nl], &completegobs, &completegoblen)) 
                      {
                          layerpresent = 1;
                          SETBIT(presentmask, nl);
                          
                          assert (!targetbp[0] && !targetbp[1]);
                          if (these[nl].pyra->first) 
                          {
                              firstlong = (targetbp[0]<<24)+(targetbp[1]<<16)+(targetbp[2]<<8)+targetbp[3];
                              if ((firstlong & 0xfffffff8) != 0x00000100) 
                              {
                                  continue;
                              }
                          }
		  
                          these[nl].pyra->awaitIntra = 0;
                          these[nl].pyra->skip_until_next_tr = 0;
                          these[nl].pyra->baseLayerFlag = xprh.isbaselayer;
                          /*!! these[nl].pyra->trd = xprh.tempdist;   ?????????????NEU*/
                          if (!xprh.isbaselayer && !havebase) 
                          {
                              layerpresent = 0;
                              break;
                          }
                          HandlePyraCompleteGOBs(these[nl].pyra,targetbp,targetbp+targetcc);
                      }
                      
                      /* handle possible loss */
                      if (these[nl].pyra->decGOBsCounter < these[nl].pyra->GOBs_in_pict)
                      {
                          /* gobs missing -> error concealment */
                          printf("\n->->Layer %d: incomplete (%d/%d).\n", nl, 
                                 these[nl].pyra->decGOBsCounter, these[nl].pyra->GOBs_in_pict);
                          updateLossStatistics(these[nl].pyra, ldd[nl], cd, COMPUTE_LOSS, 1);
                          PyraConcealment(these[nl].pyra, cd->ConcealMessages, cd->strategy, nl);
                      }
                      else
                      {
                          /* all gobs decoded */
                          if (ldd[nl]->picCodType == PICTURE_CODING_TYPE_INTRA)
                              updateLossStatistics(these[nl].pyra, ldd[nl], cd, NO_LOSS_AT_INTRA, 0);
                          else
                              updateLossStatistics(these[nl].pyra, ldd[nl], cd, NO_LOSS, 0);
                      }

                      /* decision: do/not display layer */                     
                      if (considerPyraPacketLoss(/*these[nl].pyra,*/ ldd, cd, nl, time) == SHOW_LAYER)
                      {
                          pic = these[nl].pyra->DecPic;
                      }
                      break;
                  default:
                      printf("\n#### Wrong layertype (%d). Ending.\n", ldd[nl]->layertype);
                      assert(0);
                }
                if (layerpresent) 
                {
                    lastDecLayer	= nl;
                    havebase	= 1;
                    ldd[nl]->prevDecTime = time;
                }
            }
            else if (READBIT(fileend, nl) && !ldd[nl]->pcktsinbuf)
            {
                UNSETBIT(cont, nl);
            }
#if 0
            else
            {
                /* if packets were expected but none was decoded */
                if ((ldd[nl]->expectFrame == EXPECT_FRAME) && (ldd[nl]->state != THROW_AWAY_ALL))
                {
                    printf("\n#### Nothing decoded for layer %d!!!\n", nl);
                    if (ldd[nl]->layertype == LAYERTYPE_PYRA)
                    {
                        updateLossStatistics(these[nl].pyra, ldd[nl], cd, COMPLETE_LOSS, 1);
                    }
                }
            }
#endif
        }
#if 0
        for (nl=nLayers-1;nl>=0;nl--)
            if (presentmask & (1<<nl))
                ldd[nl]->layeruncoded = 0;
#endif
        /*!!lasttr_ = currenttr;*/
        

        /*********************/
        /* End of Layer loop */
        /*********************/
        /* Display */
        WaitFrame(time, dInfo->fps);
        if (lastDecLayer >= 0)
        {
            if (pic->ws == dispPict->ws)
            {
                yuv2rgb(pic);
                realDispPict = pic;
            }
            else
            {
                if (pic->ws < dispPict->ws)
                    dSize = dispPict->ws / pic->ws;
                else
                    dSize = pic->ws / dispPict->ws;
                switch(dSize)
                {
                  case 1:  dSize = 0; break;
                  case 2:  dSize = 1; break;
                  case 4:  dSize = 2; break;
                  case 8:  dSize = 3; break;
                  case 16: dSize = 4; break;
                  case 32: dSize = 5; break;
                  case 64: dSize = 6; break;
                  default:
                      fprintf(stderr, "Can't handle size difference for display!\n");
                      exit(1);
                }
                if (pic->ws < dispPict->ws)
                    MultInterpolateFastPictureSub(dSize, pic, dispPict);
                else
                    MultDownsamplePictureSub(dSize, pic, dispPict);
                yuv2rgb(dispPict);
                realDispPict = dispPict;
            }
        }
        if (dInfo->yuvWrite)
            WritePicture(dInfo->yuvOutFile, CAT_SEQ_TYPE, fileind++, realDispPict);
        if (dInfo->compQualMeas)
            computeQualityMeasure(yuvRefFile, measFile, refPict, realDispPict, dInfo->qualMeasMethod, time);
    }    
    /********************/
    /* End of Film loop */
    /********************/
    

    /* Clean up */
    DisinitFilters();
    FreePicture(dispPict);
    for (nl = 0; nl < nLayers; nl++)
    {
        fclose(stream[nl]);
        switch (method[nl])
        {
          case H263:
              DisinitH263Decoder(these[nl].h263);
              FreeH263Decoder(these[nl].h263);
              break;
          case PYRA:
              DisinitPyraDecoder(these[nl].pyra);
              FreePyraDecoder(these[nl].pyra);
              break;
        }
    }

    /* for protocol data evaluation purposes */
    for (nl = 0; nl < nLayers-1; nl++)
    {
        if (ldd[nl]->state != THROW_AWAY_ALL)
            printf("\nWASN'T SWITCHING OFF COMPLETELY LAYER %d AT ALL.\n", nl);        
    }
    
    sleep(1);
    exit_display();
    if (!dInfo->quiet)
    {
        printf("\n\n                *************************\n");
        printf("                *        The End        *\n");
        printf("                *************************\n\n\n");
        showStatistics(ldd, nLayers);
    }
    else
        printf("\n\n");
    return;
}

