#ifndef _MY_PYRAPACKDEC_MAIN_H
#define _MY_PYRAPACKDEC_MAIN_H

#include "defs.h"
#include "rtp_defs.h"

/*************************************************************************/
/*                        Defaults for info struct                       */
/*************************************************************************/

/* Layer specifications */
#define DEFAULT_FREQ_0                                                    1
#define DEFAULT_START_OFFSET_0                                            0

/* Transmission specifications */
#define DEFAULT_PACKET_SIZE                                            1024
#define DEFAULT_PERCENT_LOSS                                              0

/* General configurations */
#define DEFAULT_DISPLAY_FORMAT                                           ON
#define DEFAULT_DISPLAY_SIZE                                            CIF
#define DEFAULT_WINDOWID                                                  0
#define DEFAULT_FRAMES_PER_SECOND                                         0
#define DEFAULT_QUIET_FLAG                                                0

#define DEFAULT_YUV_WRITE_FLAG                                            0
#define DEFAULT_YUV_OUT_FILE                                           NULL
#define DEFAULT_COMP_QUAL_MEAS                                            0
#define DEFAULT_QUAL_MEAS_METHOD                                       PSNR
#define DEFAULT_YUV_REF_FILE                                           NULL


/*************************************************************************/
/*                            Info struct                                */
/*************************************************************************/

typedef struct {

    /* Layer configuration */
    int freq[NUM_LAYERS];
    int startOffset[NUM_LAYERS];
    
    /* Transmission configuration */
    int packetSize;
    int percentLoss[NUM_LAYERS];
    
    /* General configurations */
    int displayFormat;
    int displaySize;
    long windowid;
    int fps;
    int quiet;
    char yuvWrite;      /* =1: write yuv signal to file */
    char *yuvOutFile;
    char compQualMeas;  /* =1: compute objective measure of video quality to reference */
    int qualMeasMethod; /* objective quality measure */
    char *yuvRefFile;

} RtpDecInfo;


#endif
