#include <stdlib.h>
#include "common.h"
#include "display.h"
#include "rtp_defs.h"

/*
 * compute objective picture quality measure according to specified method
 * and writes current time and result to file.
 */
float computeQualityMeasure(FILE *refFile, FILE *measFile,
                            Picture *refPict, Picture *pict,
                            int method, unsigned long int time)
{
    float meas;
    int framesize = REF_PICTURESIZE_W * REF_PICTURESIZE_H;

    if (feof(refFile))
    {
        printf("\nWARNING: reference file is too short!!!\n");
        return 0;
    }
    
    /* get reference frame */
    if (fread(refPict->y, sizeof(Byte), framesize, refFile) != framesize)    /* Y */
        return 0;
    framesize = framesize >> 2;
    if (fread(refPict->u, sizeof(Byte), framesize, refFile) != framesize)    /* U */
        return 0;
    if (fread(refPict->v, sizeof(Byte), framesize, refFile) != framesize)    /* V */
        return 0;
    
    /* compute objective picture quality measure */
    switch (method)
    {
      case PSNR:
          meas = PSNRPictures(pict, refPict);
          break;
      default:
          printf("Wrong method for quality measurement (%d).\n", method);
          exit (1);
    }
    fprintf(measFile, "%5lu: %.2f\n", time, meas);
    return meas;
}

