#include <stdio.h>
#include <assert.h>

#include "rtp_defs.h"
/*#include "readpack.h"*/

/***************** Funktionen ************************************************
  readpacket
*****************************************************************************/


/***************** Anmerkung ************************************************/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- readpacket -- Liest ein RTP-Paket aus einem File    
 *
 * Author:           Markus Sebeck
 *
 * Created:          7-May-98
 *
 * Purpose:          Liest ein RTP-Paket aus einem File und stellt jeweils
 *                   die Gesamtlaenge in Bytes als Int voran.
 *
 * Arguments in:     FILE*      fileptr         Ausgabefile
 *                   
 * Arguments in/out: int*       packetlen       Laenge des Pakets in Byte
 *                   u_char*    packetptr       Zeiger auf Bitstream
 *
 * Arguments out:    
 *
 * Return values:    int        EOF: Fileende erreicht, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int readpacket(FILE* fileptr, unsigned char* packetptr, int *packetlen)
/***********************************************************CommentEnd********/
{
    int ii, byte, readbytes=0;
    unsigned long int len=0;

    /*!!
    if (feof(fileptr+1))
    {
        *packetlen = 0;
	return EOF;
    }
    */

    /* read integer packetlen */
    for (ii=1;ii<=BYTES_FOR_PACKLEN;ii++)
    {
        byte = fgetc(fileptr);
	if(byte == EOF)
	{

	  /*!!	    fprintf(stderr,"Error in reading packetlength: %d instead of %d bytes read(fptr = %lu, byte = %d, EOF = %d.", ii-1, BYTES_FOR_PACKLEN, ftell(fileptr), byte, EOF);
	    printf("\nfeof = %d", feof(fileptr));
	    assert(0); */
	    *packetlen = 0;
	    return EOF;
	}
	len |= (byte << (BYTES_FOR_PACKLEN-ii)*8);
	/* *packetlen |= (byte << (ii-1)*8); */
    }
    *packetlen = len;

    if( (0 >= *packetlen) || (*packetlen > MAX_PACKETSIZE) )
    {
        fprintf(stderr,"Size of packet (%d) exceeds maximum packetsize.", *packetlen);
	assert(0);
    }
    /* read packetlen bytes */
    readbytes = fread(packetptr, sizeof(char), *packetlen, fileptr);

    if (readbytes != *packetlen)
    {
        fprintf(stderr,"Error in reading packet from file. Only %d bytes read instead of %d.",
		readbytes,*packetlen );
	/*return 1;*/
	exit(1);
    }
    /*!! printf("L:%4d ",*packetlen); */
    return 0;
    /* return feof(fileptr); */
}

