/* #include ".h"
#include ".h" */
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "rtp_defs.h"
#include "rtp.h"
#include "h263.h"
#include "reassemble.h"


/*
 * If current packet was handled or can't be used release its content
 * and adapt counters in layerDecData.
 */
void 
releasePacket(layerDecData *ldd, unsigned int index, int mode)
{
    /* update counters */
    ldd->curpackets--; 
    ldd->pcktsinbuf--; 
    /* update statistics */
    ldd->handledpackets++;
    if (mode == PACKET_THROWN_AWAY)
        ldd->thrownawaypackets++;
    /* free slot */
    ldd->slot[index].cc = 0;
    ldd->slot_f[index] = 0;  
}


/*
 * We need to reassemble mode B blocks to either a complete image, or
 * a number of gobs. yuck.
 * 
 * start found when:	This block is mode B, but starts with GOB/PSC header
 * end found when:	last B block has RTP_M set
 *			next block in sync is mode A.
 */
int
reassemble_h263_gobs(unsigned char **newbp, int *newcc, unsigned long int tr,
		     layerDecData *ldd, unsigned char **gobstreamptr, int *gobstreamsize)
{
	unsigned int	startblock,/*lowestseq,seqstart,*/ j,i,xi,x,l,last,size,/*sbit,*/seqno,firstlong;
	int	endblock, seqstart;
	unsigned char	*p, *gobstream;


	seqstart = ldd->curstart;  /*!!NEU*/

	/*
	 * find out if we have some full GOBs in the queue
	 */
	/* for (i=0;i<B_SLOTS;i++) { */
	for (i=0;ldd->curpackets;i++) {
	  /*!! ldd->curpackets noch runterzaehlen und ldd->curstart raufzaehlen */
		xi = (i+seqstart) & B_SLOTMASK;
		seqno = ldd->slot[xi].seqno;
		ldd->curstart = (++ldd->curstart) & B_SLOTMASK;  /*!!NEU*/
		/* in the first bytes should be the 22 bits PSC */
		/* 0000 0000 0000 0000 100000 */
		p = ldd->slot[xi].bp;
		firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
		if (!ldd->slot_f[xi]) 		/* if no current data, continue. */
			continue;
		if (!ldd->slot[xi].cc) 		/* if handled, continue. */
			continue;
		if (ldd->slot[xi].tr!=tr)
			continue;

		/* ---------------------- MODE A ---------------------- */
		/* return packet as is (the contained GOB(s) */
		if (!ldd->slot[xi].header.h263b.ftype)  {
			assert((firstlong & 0xffff8000)==0x00008000); /*!!MOD0306*/
			*newbp = ldd->slot[xi].bp;
			*newcc = ldd->slot[xi].cc;
#ifdef PRINT_MY_DEBUG_MESSAGES	
			printf(" %4d dbyte, %2d hbyte in packet %4lu (A).\n",
			       ldd->slot[xi].cc, sizeof(RtpHeader)+sizeof(h263rtpheader_A), 
			       ldd->handledpackets+1);
#endif
			releasePacket(ldd, xi, PACKET_USED);
			return 1;
		}

		/* ---------------------- MODE B ---------------------- */
		/* try to reconstruct GOB out of MBs */

		/* detect GOB start. we _NEED_ it. */
		if ((firstlong & 0xffff8000) != 0x00008000)
		{
		        /* throw away current packet */
#ifdef PRINT_MY_DEBUG_MESSAGES	
		        printf(" %4d dbyte, %2d hbyte in packet %4lu (A).\n",
			       ldd->slot[xi].cc, sizeof(RtpHeader)+sizeof(h263rtpheader_B), 
			       ldd->handledpackets+1);
#endif
		        releasePacket(ldd, xi, PACKET_THROWN_AWAY);
			continue;
		}

		startblock = xi;

		/* find break (due to packet loss) or regular end of mode B sequence */
		endblock = -1;
		for (j=0;j<B_SLOTS;j++) {
			x=(startblock+j)&B_SLOTMASK;
			/* follow slotmasks. */
			if ((ldd->slot[x].seqno&0xffff)!= (seqno+j)&0xffff) {
				break;
			}
			if (!ldd->slot_f[x]) {/* slot empty -> continue */
				if (j)
					endblock = j-1;
				break;
			}
			if (!ldd->slot[x].cc) {/* done already -> continue */
				if (j)
					endblock = j-1;
				break;
			}
			p = ldd->slot[x].bp;
			firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
			if ((firstlong & 0xffff8000) == 0x00008000)
				if (j) {
					endblock=j-1;
					break;
				}

			if (!ldd->slot[x].header.h263b.ftype) {
				if (j)
					endblock = j-1;
				break;
			} else {
				if (ldd->slot[x].rtflags&RTP_M) {/* got endmarker. */
					endblock = j;
					break;
				}
			}
		}
		if (endblock<=0) {
		        /* throw away current packet */
#ifdef PRINT_MY_DEBUG_MESSAGES	
		        printf(" %4d dbyte, %2d hbyte in packet %4lu (A).\n",
			       ldd->slot[xi].cc, sizeof(RtpHeader)+sizeof(h263rtpheader_B), 
			       ldd->handledpackets+1);
#endif
		        releasePacket(ldd, xi, PACKET_THROWN_AWAY);
			continue;
		}

		/* determin size of whole GOB (in bytes) */
		size = 0;
		for (l=0;l<=endblock;l++) {
			x = (startblock+l)&B_SLOTMASK;
			size += ldd->slot[x].cc;
			if (ldd->slot[x].header.h263b.ebit)
				size--;
			ldd->handledpackets++;        /*!!NEU*/
#ifdef PRINT_MY_DEBUG_MESSAGES	
			printf(" %4d databytes, %2d headerbytes in packet %4lu (B).\n",
			       ldd->slot[x].cc, sizeof(RtpHeader)+sizeof(h263rtpheader_B), 
			       ldd->handledpackets);
#endif
		}
		ldd->curstart = (ldd->curstart + endblock) & B_SLOTMASK;  /*!!NEU*/
		ldd->curpackets -= endblock + 1;     /*!!NEU*/
		ldd->pcktsinbuf -= endblock + 1;     /*!!NEU*/
		size += 16;

		/* reallocate memory for whole GOB if necessary and initialize to 0 */
		if (size > *gobstreamsize) {
			free(*gobstreamptr);
			*gobstreamptr = (unsigned char*) malloc(size*sizeof(char));
			*gobstreamsize = size;
		}
		gobstream = *gobstreamptr;
		memset(gobstream,0,*gobstreamsize);

		/* concatenate macroblocks of several packets 
		   to get one or more complete gobs */
		last=0;
		for (l=0;l<=endblock;l++) {
			x = (startblock+l)&B_SLOTMASK;
			if (ldd->slot[x].header.h263b.sbit) {
				gobstream[last] |= ldd->slot[x].bp[0];
				last++;
				memcpy(gobstream+last,ldd->slot[x].bp+1,ldd->slot[x].cc-1);
				last += ldd->slot[x].cc-1;
			} else {
				memcpy(gobstream+last,ldd->slot[x].bp,ldd->slot[x].cc);
				last += ldd->slot[x].cc;
			}
			if ((l<endblock) && ldd->slot[x].header.h263b.ebit)
				last--;
			ldd->slot[x].cc = 0;
			ldd->slot_f[x] = 0;  /*!!NEU*/
		}

		/*!!!!! check if GOB complete */

		/* check for picture sync at beginning of reassembled gob bitstream 
		   and hand over bitstream */
		firstlong = (gobstream[0]<<24)+(gobstream[1]<<16)+(gobstream[2]<<8)+gobstream[3]; /*!!MOD0306*/
		assert ((firstlong & 0xffff8000) == 0x00008000); /*!!MOD0306*/
		*newbp = gobstream;
		*newcc = last;
		return 1;
	}
	return 0;
}

int
reassemble_pyra_gobs(unsigned char **newbp, int *newcc, unsigned long int tr, 
		     PyraLayerRtpHeader *xprh,
		     layerDecData *ldd, unsigned char **gobstreamptr, int *gobstreamsize)
{
	unsigned int	startblock/*,seqstart*/,j,i,xi,x,l,last,size,/*sbit,*/seqno,firstlong;
	unsigned char	*p, *gobstream;
	int	endblock, seqstart /*,lowestseq*/;


	seqstart = ldd->curstart;  /*!!NEU*/

	/*
	 * find out if we have some full GOBs in the queue
	 */
	/* for (i=0;i<B_SLOTS;i++) { */
	for (i=0;ldd->curpackets;i++) {
		xi = (i+seqstart) & B_SLOTMASK;
		seqno = ldd->slot[xi].seqno;
		ldd->curstart = (++ldd->curstart) & B_SLOTMASK;  /*!!NEU*/
		/* in the first bytes should be the 22 bits PSC */
		/* 0000 0000 0000 0000 0000 0001 0000  */
		p = ldd->slot[xi].bp;
		firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
		if (!ldd->slot_f[xi]) 		/* if no current data, continue. */
			continue;
		if (!ldd->slot[xi].cc) 		/* if handled, continue. */
			continue;
		if (ldd->slot[xi].tr!=tr)
			continue;

		/*!! #if 0 */
		/* ---------------------- MODE A ---------------------- */
		/* return packet as is (the contained GOB(s) */
		if (!ldd->slot[xi].header.prh.modeb)  {
		        assert((firstlong & 0xffffff00) == 0x00000100);
			*newbp = ldd->slot[xi].bp;
			*newcc = ldd->slot[xi].cc;
			*xprh = ldd->slot[xi].header.prh;
#ifdef PRINT_MY_DEBUG_MESSAGES	
			printf(" %4d dbyte, %2d hbyte, blflag=%d,sbit=%d, ebit=%d, format=%d in packet %4lu (A).\n",
                               ldd->slot[xi].cc, sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader), 
			       (*xprh).isbaselayer, (*xprh).sbit, (*xprh).ebit, (*xprh).srcformat, ldd->handledpackets+1);
#endif
			releasePacket(ldd, xi, PACKET_USED);
			return 1;
		}
		/*!! #endif */

		/* ---------------------- MODE B ---------------------- */
		/* try to reconstruct GOB out of MBs */

		/* detect GOB start. we _NEED_ it. */
		if ((firstlong & 0xffffff00) != 0x00000100)
		{
		        /* throw away current packet */
#ifdef PRINT_MY_DEBUG_MESSAGES	
			printf(" %4d databytes, %2d headerbytes in packet %4lu (B) (thrown away).\n",
			       ldd->slot[xi].cc, sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader), 
			       ldd->handledpackets+1);
#endif
		        releasePacket(ldd, xi, PACKET_THROWN_AWAY);
			continue;
		}

		startblock = xi;
		
		/* find break (due to packet loss) or regular end of mode B sequence */
		endblock = -1;
		for (j=0;j<B_SLOTS;j++) {
			x = (startblock+j)&B_SLOTMASK;
			/* follow slotmasks. */
			if ((ldd->slot[x].seqno&0xffff)!= (seqno+j)&0xffff)
				break;
			if (!ldd->slot_f[x]) {/* slot empty -> continue */
				if (j)
					endblock = j-1;
				break;
			}
			if (!ldd->slot[x].cc) {/* done already -> continue */
				if (j)
					endblock = j-1;
				break;
			}
			p = ldd->slot[x].bp;

			/*!!!!!!!! ab hier war auskommentiert */
			/* */
			firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
			if ((firstlong & 0xffffff00) == 0x00000100)
				if (j) {
					endblock=j-1;
					break;
				}

			/* FIXME: add check for mode A block. */
			/* */
			if (!ldd->slot[x].header.prh.modeb) {
				endblock = j-1;
				break;
			} else {
			
			/*!!!!!!!! bis hier war auskommentiert */
				if (ldd->slot[x].rtflags&RTP_M) {/* got endmarker. */
					endblock = j;
					break;
				}
			}

		}
		/*!! if (endblock==-1) */
		if (endblock <= 0)
		{
		        /* throw away current packet */
#ifdef PRINT_MY_DEBUG_MESSAGES	
			printf(" %4d databytes, %2d headerbytes in packet %4lu (B) (thrown away).\n",
			       ldd->slot[xi].cc, sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader), 
			       ldd->handledpackets+1);
#endif
		        releasePacket(ldd, xi, PACKET_THROWN_AWAY);
			continue;
		}

		/* determin size of whole GOB */
		size = 0;
		for (l=0;l<=endblock;l++) {
			x = (startblock+l)&B_SLOTMASK;
			size += ldd->slot[x].cc;
			if (ldd->slot[x].header.prh.ebit)
				size--;
			ldd->handledpackets++;        /*!!NEU*/
#ifdef PRINT_MY_DEBUG_MESSAGES	
			printf(" %4d databytes, %2d headerbytes in packet %4lu (B).\n",
			       ldd->slot[x].cc, sizeof(RtpHeader)+sizeof(PyraLayerRtpHeader), 
			       ldd->handledpackets);
#endif
		}
		ldd->curstart = (ldd->curstart + endblock) & B_SLOTMASK;  /*!!NEU*/
		ldd->curpackets -= endblock + 1;     /*!!NEU*/
		ldd->pcktsinbuf -= endblock + 1;     /*!!NEU*/
		size += 16;

		/* reallocate memory for whole GOB if necessary and initialize to 0 */
		if (size > *gobstreamsize) {
			free(*gobstreamptr);
			*gobstreamptr = (unsigned char*) malloc(size*sizeof(char));
			*gobstreamsize = size;
		}
		gobstream = *gobstreamptr;
		memset(gobstream,0,*gobstreamsize);

		/* concatenate macroblocks of several packets 
		   to get one or more complete gobs */
		last=0;
		for (l=0;l<=endblock;l++) {
			x = (startblock+l)&B_SLOTMASK;
			if (ldd->slot[x].header.prh.sbit) {
				if (last)
					assert(gobstream[last]==ldd->slot[x].bp[0]);
				gobstream[last] |= ldd->slot[x].bp[0];
				last++;
				memcpy(gobstream+last,ldd->slot[x].bp+1,ldd->slot[x].cc-1);
				last += ldd->slot[x].cc-1;
			} else {
				memcpy(gobstream+last,ldd->slot[x].bp,ldd->slot[x].cc);
				last += ldd->slot[x].cc;
			}
			if ((l<endblock) && ldd->slot[x].header.prh.ebit)
				last--;
			ldd->slot[x].cc = 0;
			ldd->slot_f[x] = 0;  /*!!NEU*/
		}
		/*
		fprintf(stderr,"pyra: reassembled, %d bytes\n",last);
		for (l=0;l<=3;l++)
			fprintf(stderr,"%02x ",gobstream[l]);
		fprintf(stderr,"...");
		for (l=0;l<=3;l++)
			fprintf(stderr," %02x",gobstream[last-1-l]);
		fprintf(stderr,"\n");
		*/

		/*!!!!! check if GOB complete */

		/* check for picture sync at beginning of reassembled gob bitstream 
		   and hand over bitstream */
		firstlong = (gobstream[0]<<24)+(gobstream[1]<<16)+(gobstream[2]<<8)+gobstream[3];
		assert((firstlong & 0xffffff00) == 0x00000100);
		/* hand over bitstream */
		*newbp = gobstream;
		*newcc = last;
		*xprh = ldd->slot[startblock].header.prh;
		return 1;
	}
	return 0;
}


/* Guess the layertype of the frame we got. 
 * Uses: 
 *	Some trivial rejects based on pyra header vs h263 header.
 *	Looks for synchwords.
 * (Fails probably for h263 mode B blocks)
 */
int 
guess_layertype(unsigned char *bp /*,unsigned short seqno*/)
{
    int	i;
    long firstlong;
    PyraLayerRtpHeader	*prh	= (PyraLayerRtpHeader*)bp;
    /* h263rtpheader_A	*h263rh = (h263rtpheader_A*)bp; */


    /* two impossible events for pyra rtpheaders */
    if (prh->layernr > prh->maxlayers) 
    {
        return H263_ID;
    }
    if (!prh->maxlayers) 
    {
        return H263_ID;
    }
    /*!!
    if (!prh->tempdist) 
    {
        return H263_ID;
    }
    */

    /* 4 is the minimum headersize. avoids false positives */
    for (i=4;i<16;i++) 
    {
        if (bp[i])
	    continue;
	firstlong = (bp[i]<<24)|(bp[i+1]<<16)|(bp[i+2]<<8)|bp[i+3];
	if ((firstlong & 0xffff8000) == 0x00008000) 
	{
	    return H263_ID;
	}
	if ((firstlong & 0xffffff00) == 0x00000100) 
	{
	    return PYRA_ID;
	}
    }

#if 0
    if (((slot_[(seqno+B_SLOTS-1)&B_SLOTMASK].seqno+1)&0xffff)==seqno) 
    {
        /* scheint zu funktionieren ...
	   fprintf(stderr,"previous type %d\n",
	   slot_[(seqno+B_SLOTS-1)&B_SLOTMASK].layertype
	   );
	   */
        return slot_[(seqno+B_SLOTS-1)&B_SLOTMASK].layertype;
    }
#endif

    fprintf(stderr,"couldn't guess type of packet!\n");
    return -1;
}

