/* typedef unsigned char     Byte;  /!! MS 28.05.98 */

/*!! my includes */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <bitIn.h>
#include <bitOut.h>

#include "rtp_defs.h"
#include "rtp.h"
#include "pyra.h"
#include "readpack.h"

#include "rtpsupport.h"


/*
 * Throw away a packet containing no current data.
 * Reasons: timestamp is too old 
 *	    or differs too much from current one
 */
void throwawayPacket(layerDecData *ldd, int index)
{
    ldd->slot[index].cc = 0;
    ldd->pcktsinbuf--;	
    ldd->thrownawaypackets++;
    assert(ldd->pcktsinbuf >= 0);
}

/*
 * Throw away all packets of a layer for current timestamp
 * (means all slots whose slot_f is set).
 */
void throwawayFrame(layerDecData *ldd)
{
    int ii;

    for (ii=0;ii<B_SLOTS;ii++)
    {
        if ( ldd->slot_f[ii] )
	{
	    ldd->slot_f[ii] = 0;
	    throwawayPacket(ldd, ii);
	}
    }
}



/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- checkInPacket --  
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          Write curpacket of length curpacklen and type layertype
 *                   into specified slot.
 *
 * Arguments in:     Layerdata* ld              Zeiger auf Daten des Frames
 *
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int checkInPacket(Slot *slot, unsigned char *curpacket, const int curpacklen, const int layertype, int seqno)
/***********************************************************CommentEnd********/
{
    int layerheadersize, datalen;
    unsigned char *datastart;
    RtpHeader *rh;
    h263rtpheader_A *h263rh;

    /* find data start in packet */
    rh = (RtpHeader*) curpacket;
    /* layertype muss bereits fuer jeden layer feststehen (oder hier bestimmen) */
    if (layertype == LAYERTYPE_H263)
    {
	h263rh = (h263rtpheader_A*)(curpacket + sizeof(RtpHeader));
	if (h263rh->ftype) 
	    layerheadersize = HDRSIZE_B;
	else 
	    layerheadersize = HDRSIZE_A; 
	/* assert(rh->rh_ts % 256 == ShowH263TempRef(curpacket + sizeof(RtpHeader) + layerheadersize)); */
    }
    else
    {
        layerheadersize = sizeof(PyraLayerRtpHeader);
	/* assert(rh->rh_ts % 256 == ShowPyraTempRef(curpacket + sizeof(RtpHeader) + layerheadersize)); */
    }
    datastart = (unsigned char*)(curpacket + sizeof(RtpHeader) + layerheadersize);
    datalen = curpacklen - sizeof(RtpHeader) - layerheadersize;
    
    /* hand over data for structure slot */
    if (slot->cc)
        fprintf(stderr,"\n\n\n#####################################################\n\n\n"); /* slot wasn't empty!!!*/
    slot->seqno = seqno;
    slot->cc = datalen;
    /*slot->rtflags = (curpacket[0] << 8) | curpacket[1]; /!!!!!!!!!!!  noch modifizieren */
    slot->rtflags = rh->rh_flags; /*!!!!!!!!!!!  noch modifizieren */
    slot->tr = rh->rh_ts;    
    memcpy(&(slot->header),(char*)(curpacket+sizeof(RtpHeader)), layerheadersize);
    /*!! fuer bp noch Speicher allokieren !!!!!!!!*/
    memcpy(slot->bp,datastart,datalen);

    return 0;

}


/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- findSlotsequence --  finds start and end slot of sequence  
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          checks all slots, (un)sets slot_f if slot is (not) current one
 *                   sets gotdata bit if there is current data
 *                   throws away packet if necessary
 *                   finds start and end slot of sequence
 *
 * Arguments in:     layerDecData* ldd          Zeiger auf Daten des Frames
 *                   u_long     curtime         current time
 *                   int        nl              current layer
 * Arguments in/out: -
 *
 * Arguments out:    int*       gotdata         
 *
 * Return values:    -
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
void findSlotsequence(layerDecData *ldd, const unsigned long curtime, const int nl, int *gotdata)
/***********************************************************CommentEnd********/
{
    int ii;
    int checkcurpackets; /*!!TEST*/
    int lowestseq, highestseq;

    /* initializations */ 
    lowestseq=0xfffff;highestseq=0;
    ldd->curstart=-1; ldd->curend=0;

    checkcurpackets = ldd->curpackets; /*!!TEST*/
    ldd->curpackets = 0;               /*!!TEST*/

    /* check every slot */
    for (ii=0;ii<B_SLOTS;ii++) 
    {
        if (!ldd->slot_f[ii])
	{
	    continue;
	}
	    
	assert(ldd->slot[ii].cc > 0);
	/* assert(ldd->slot[ii].tr == curtime); */
	if (ldd->slot[ii].tr != curtime)
	{
	    printf("Warning: marked slot doesn't contain current data!\n");
	    printf("Time of packet (%lu) != current time (%lu).", ldd->slot[ii].tr, curtime);
	    exit(1);
	}
	/*!!
	ldd->slot_f[ii] = 1;
	SETBIT(*gotdata, nl);
	*/

	ldd->curpackets++; /*!!TEST*/
	    
	if (ldd->slot[ii].seqno <= lowestseq)
	{
	    lowestseq = ldd->slot[ii].seqno;
	    ldd->curstart = ii;
	}
	if (ldd->slot[ii].seqno >= highestseq)
	{
	    highestseq = ldd->slot[ii].seqno;
	    ldd->curend = ii;
	}
    }
    assert(ldd->curpackets == checkcurpackets); /*!!TEST*/

    /* change curstart and curend if necessary */
    if (highestseq - lowestseq > B_SLOTS)
    {
        ii = ldd->curstart;
	ldd->curstart = ldd->curend;
	ldd->curend = ii;
    }
}

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- prepareFrameReading --    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          checks all slots, (un)sets slot_f if slot is (not) current one
 *                   sets gotdata bit if there is current data
 *                   throws away packet if necessary
 *                   finds start and end slot of sequence
 *
 * Arguments in:     layerDecData* ldd          Zeiger auf Daten des Frames
 *                   u_long     curtime         current time
 *                   int        nl              current layer
 * Arguments in/out: -
 *
 * Arguments out:    int*       gotdata         
 *
 * Return values:    -
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
void prepareFrameReading(layerDecData *ldd, const unsigned long curtime, const int nl, int *gotdata)
/***********************************************************CommentEnd********/
{
    int ii, xx, newTs;
    unsigned long int deltaT;

    /* reset counters */
    ldd->curpackets = 0;
    ldd->numOfDiffTs = 0;
    ldd->diffTsPackets = 0;

    /* check every slot */
    for (ii=0;ii<B_SLOTS;ii++) 
    {
        /* slot is empty */
        if (!ldd->slot[ii].cc)
	{
	    ldd->slot_f[ii] = 0;
	    continue;
	}
	    
        /* slot contains data */
	if (ldd->slot[ii].tr == curtime)
	{
	    ldd->slot_f[ii] = 1;
	    ldd->curpackets++;
	    SETBIT(*gotdata, nl);		    
	}
	else
	{
	    ldd->slot_f[ii] = 0;
	    /* throw away packet if timestamp is too old 
	       or differs too much from current one */
	    if (curtime > ldd->slot[ii].tr)
	    {
	        deltaT = curtime - ldd->slot[ii].tr;
		if (deltaT <= 0xffffffff - MAX_TIMEDISTANCE)
		{
		    throwawayPacket(ldd, ii);
		    continue;
		}
	    }
	    else
	    {
	        deltaT = ldd->slot[ii].tr - curtime;
		if (deltaT > MAX_TIMEDISTANCE) 
		{
		    throwawayPacket(ldd, ii);
		    continue;
		}
	    }

	    /* keep this packet and handle it */
	    ldd->diffTsPackets++;
	    newTs = 1;
	    for (xx=0;xx<ldd->numOfDiffTs;xx++)
	        if (ldd->slot[ii].tr == ldd->diffTs[xx])
		    newTs = 0;
	    if (newTs || !ldd->numOfDiffTs)
	    {
	        ldd->diffTs[ldd->numOfDiffTs] = ldd->slot[ii].tr;
		ldd->numOfDiffTs++;
	    }
	}
    }

    assert(ldd->numOfDiffTs <= MAX_DIFF_TS);
    assert(ldd->diffTsPackets <= NUM_OF_NEXT_PACKETS);

    /*!!
    if (ldd->numOfDiffTs > MAX_DIFF_TS)
    {
        printf("\nWarning: Layer %d:numOfDiffTs(%d) > MAX_DIFF_TS(%d).\n", nl, ldd->numOfDiffTs, MAX_DIFF_TS);
	printf("filepos = %lu.", ftell(ldd->stream));
    }
    if (ldd->diffTsPackets > NUM_OF_NEXT_PACKETS)
    {
        printf("\nWarning: Layer %d:diffTsPackets(%d) > NUM_OF_NEXT_PACKETS(%d).\n", nl, ldd->numOfDiffTs, MAX_DIFF_TS);
	printf("filepos = %lu.", ftell(ldd->stream));
    }
    */
}

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- getFrame --    
 *
 * Author:           Markus Sebeck
 *
 * Created:          16-Apr-98
 *
 * Purpose:          
 *
 * Arguments in:     Layerdata* ld              Zeiger auf Daten des Frames
 *
 * Arguments in/out: -
 *
 * Arguments out:    
 *
 * Return values:    int        1: Fehler aufgetreten, 0: sonst
 *
 * Example:          -
 *
 * Side effects:     -
 *
 * Description:      -
 *
 * See also:         -
 *
 * Modified:         -
 *
 *****************************************************************************/
int getFrame(H263Global *h263Data, layerDecData **ldd, RtpDecInfo *dInfo,
	     const unsigned long curtime, const int nLayers, 
	     int *getpackets, int *fileend, int *gotdata)
/***********************************************************CommentEnd********/
{
    int nl, xx;
    int /*action=0,*/ newTs, seqno, shortseqno, contLayerRead;
    int curpacklen;
    /*!!unsigned long int curTr;*/
    static unsigned char curpacket[MAX_PACKETSIZE];
    RtpHeader *rh;

    *getpackets = 0;
	    
    /* read packets for every layer if necessary */    
    for (nl=nLayers - 1; nl >= 0; nl--) 
    {
        ldd[nl]->expectFrame = EXPECT_NO_FRAME;
        
#if 0
        /* do anything at all for this layer ??? */
        if (ldd[nl]->wait <= 0)
	{
	    /* SETBIT(action, nl); */
	    ldd[nl]->expectFrame = EXPECT_FRAME;
	    ldd[nl]->wait = dInfo->freq[nl] - 1;
	    if (!READBIT(*fileend, nl))
		SETBIT(*getpackets, nl);		
	}
	else
	{
	    ldd[nl]->wait--;
	    continue;
	}
#endif
        if (!READBIT(*fileend, nl))
            SETBIT(*getpackets, nl);		

	/* get number of future packets */
        if (ldd[nl]->pcktsinbuf > 0)
	    prepareFrameReading(ldd[nl], curtime, nl, gotdata);

	/* if any of the following conditions is true don't read packets from file */
        if ( !READBIT(*getpackets, nl) )
	    continue;
        if ( ldd[nl]->numOfDiffTs >= MAX_DIFF_TS )
	    continue;
        if ( ldd[nl]->diffTsPackets >= NUM_OF_NEXT_PACKETS )
	    continue; 

	/* get number of future packets */
	/* prepareFrameReading(ldd[nl], curtime, nl, gotdata); */

	/* read and handle packets until frame complete or break condition */
	contLayerRead = 1;
	while( contLayerRead )
	{
	    if (readpacket(ldd[nl]->stream, curpacket, &curpacklen) == EOF)
	    {
	        SETBIT(*fileend, nl);
		contLayerRead = 0;
	    }
	    if (curpacklen == 0)
	        break;

	    ldd[nl]->recpackets++;
	    ldd[nl]->pcktsinbuf++;
	    if (!dInfo->quiet)
	        printf("L %d, filepos. %6ld, packetno. %6lu: %5d bytes\n", ldd[nl]->layernr, ftell(ldd[nl]->stream), ldd[nl]->recpackets, curpacklen);

	    /* check in packet into adequate slot */
	    rh = (RtpHeader*) curpacket;
	    seqno = rh->rh_seqno;
	    shortseqno = seqno & B_SLOTMASK;
	    checkInPacket(&ldd[nl]->slot[shortseqno], curpacket, curpacklen, ldd[nl]->layertype, seqno);

	    /* consider timestamp and take consequences */
	    /*!! curTr = ldd[nl]->slot[shortseqno].tr; */
	    if (ldd[nl]->slot[shortseqno].tr == curtime)
	    {
	        ldd[nl]->slot_f[shortseqno] = 1;
	        ldd[nl]->curpackets++;
		SETBIT(*gotdata, nl);
	    }
	    else
	    {
	        ldd[nl]->slot_f[shortseqno] = 0;
	        ldd[nl]->diffTsPackets++;
		newTs = 1;
		for (xx=0;xx<ldd[nl]->numOfDiffTs;xx++)
		    if (ldd[nl]->slot[shortseqno].tr == ldd[nl]->diffTs[xx])
		        newTs = 0;
		if (newTs || !ldd[nl]->numOfDiffTs)
		{
		    ldd[nl]->diffTs[ldd[nl]->numOfDiffTs] = ldd[nl]->slot[shortseqno].tr;
		    ldd[nl]->numOfDiffTs++;
		}
		if ((ldd[nl]->numOfDiffTs >= MAX_DIFF_TS) || (ldd[nl]->diffTsPackets >= NUM_OF_NEXT_PACKETS))
		    contLayerRead = 0;
	    }

	    /* if any of the following conditions is true 
	       stop reading packets for this layer */
	    if(ldd[nl]->pcktsinbuf > B_SLOTS)
	        contLayerRead = 0;
	    /*!! evtl noch abbrechen, wenn M-Bit gesetzt und kein Paket gefehlt hat. */
	    /*
	    if (prevSeqno >= 0)
	    {
	        if(rh->rh_m ) ;
	    }
	    */

	}
    }

    /* find start and end slots for current time */ 
    for (nl=nLayers - 1; nl >= 0; nl--) 
    {
      /* ldd[nl]->curpackets = 0; */
	if(READBIT(*gotdata, nl))
	{
	  /*!! ldd[nl]->wait = dInfo->freq[nl] - 1; */
	    findSlotsequence(ldd[nl], curtime, nl, gotdata);

            /* determin tempdist for H263 layer */
            if (nl == nLayers - 1)
            {
                /*  */
                if ((ldd[nl]->lastseqno + 1) & 0xffff == ldd[nl]->slot[ldd[nl]->curstart].seqno)
                    h263Data->trd = curtime - ldd[nl]->prevRecTime;
            }
            /* determin number of lost packets */
            if (ldd[nl]->lastseqno >= 0)
                findLostPackets(ldd[nl]); /* NEU */

            ldd[nl]->lastseqno = ldd[nl]->slot[ldd[nl]->curend].seqno; /* NEU */
            ldd[nl]->prevRecTime = curtime; /* NEU */
        }
    }

    return 0; /*!! noch aendern */

}

/*
 * Find all lost packets since last packet of previous frame.
 */
int findLostPackets(layerDecData *ldd)
{
    int xx, curlost=0;

    for (xx=ldd->lastseqno+1; ;xx++)
    {
        xx &= B_SLOTMASK;
        if (xx == ldd->curend)
            break;
        if (!ldd->slot_f[xx])
            curlost++;
    }
    ldd->lostpackets += curlost;
    return curlost;
}
   


#if 0
int guessH263TempDist();
{
    if ((ldd->lastseqno + 1) % 0xffff == ldd->slot[ldd->curstart].seqno)
        h263Data->trd = curtime - ldd->prevRecTime;
}
#endif

#if 0
/*
 * Not yet used.
 */
char getPictureCodingType(layerDecData *ldd)
{
    if (ldd->layertype == LAYERTYPE_H263)
    {
        if (ShowH263GOBnumber(ldd->slot[ldd->curstart].bp) == 0)
            ldd->picCodType = ShowH263CodingType(ldd->slot[ldd->curstart].bp);
        else
            ldd->picCodType = PICTURE_CODING_TYPE_UNKNOWN;
    }
    else
    {
        if (ShowPyraGOBnumber(ldd->slot[ldd->curstart].bp) == 0)
            ldd->picCodType = ShowPyraCodingType(ldd->slot[ldd->curstart].bp);
        else
            ldd->picCodType = PICTURE_CODING_TYPE_UNKNOWN;
    }
    return ldd->picCodType;
}
#endif
