#include <string.h>
#include "rtp_defs.h"
#include "statistics.h"


void showStatistics(layerDecData **ldd, const int nLayers)
{
    int nl;

    printf("********* Statistics *********\n");
    for (nl = nLayers - 1; nl >= 0; nl--) 
    {
        printf("\nLayer %d:\n", nl);
        printf("\tHighest sequence nr received:\t%8d.\n", ldd[nl]->lastseqno);
        printf("\t# of received packets:\t\t%8lu.\n", ldd[nl]->recpackets);
        printf("\t# of lost packets:\t\t%8lu.\n", ldd[nl]->lostpackets);
        printf("\t# of handledpackets:\t\t%8lu.\n", ldd[nl]->handledpackets);
        printf("\t# of thrownawaypackets:\t\t%8lu.\n", ldd[nl]->thrownawaypackets);
        printf("\t# of frames received:\t\t%8lu.\n", ldd[nl]->recframenr);
    }

}

void updateLossStatistics(PyraGlobal *pyraData, layerDecData *ldd, concealDispVal *cd,
                          int loss, int newFramesMissing)
{
    int ii, nn, mb;
    unsigned long cur_mv_loss=0;
    int startMBind;

    ldd->curIndex = (++ldd->curIndex) % cd->considered;
    switch ( loss )
    {
      case COMPUTE_LOSS:
          for (ii=0;ii<pyraData->GOBs_in_pict;ii++)
          {
              if (!pyraData->decGOBs[ii])
              {
		  ldd->unperfectGobs[ii]++;
		  startMBind = ii * pyraData->MBs_in_GOB;
                  for (mb=0;mb<pyraData->MBs_in_GOB;mb++)
                  {
                      if (pyraData->mvf.mode[startMBind + mb] == MODE_INTER)
                      {
                          cur_mv_loss += abs(pyraData->mvf.mx[startMBind + mb]);
                          cur_mv_loss += abs(pyraData->mvf.my[startMBind + mb]);
                      }
                      else if (pyraData->mvf.mode[startMBind + mb] == MODE_INTRA)
                          cur_mv_loss += INTRA_MB_LOSS_WEIGTH;
                  }
                  ldd->mv_loss = ldd->mv_loss * cd->prevLossFading + cd->curLossWeight * cur_mv_loss;
	      }
              else if (ldd->picCodType == PICTURE_CODING_TYPE_INTRA)
              {
                  ldd->unperfectGobs[ii] = 0;   /* reset at intra */
              }
          }
          ldd->percentloss[ldd->curIndex] = (100 - ((100 * pyraData->decGOBsCounter) / pyraData->GOBs_in_pict));
          ldd->accuPercentLoss *= cd->prevLossFading;
          ldd->accuPercentLoss += ldd->percentloss[ldd->curIndex];
          break;
      case COMPLETE_LOSS:
          for (ii=0;ii<pyraData->GOBs_in_pict;ii++)
              ldd->unperfectGobs[ii] += newFramesMissing;
          ldd->percentloss[ldd->curIndex] = loss;
          for (nn=0;nn<newFramesMissing;nn++)
          {
              ldd->accuPercentLoss = ldd->accuPercentLoss * cd->prevLossFading + loss;
              for (mb=0;mb<pyraData->GOBs_in_pict * pyraData->MBs_in_GOB;mb++)
              {
                  if (pyraData->mvf.mode[mb] == MODE_INTER)
                  {
                      cur_mv_loss += abs(pyraData->mvf.mx[mb]);
                      cur_mv_loss += abs(pyraData->mvf.my[mb]);
                  }
                  else if (pyraData->mvf.mode[mb] == MODE_INTRA)
                      cur_mv_loss += INTRA_MB_LOSS_WEIGTH;
              }
          }
          ldd->mv_loss = cd->curLossWeight * cur_mv_loss + cd->prevLossFading * ldd->mv_loss;
	  break;
      case NO_LOSS:
	  ldd->percentloss[ldd->curIndex] = loss;
          ldd->accuPercentLoss *= cd->prevLossFading;
	  ldd->mv_loss *= cd->prevLossFading;
          break;
      case NO_LOSS_AT_INTRA:
          ldd->prevFramesMissing = 0;
          ldd->missFramesSinceI = 0;
          memset(ldd->unperfectGobs, 0, MAX_GOBS);
          memset(ldd->percentloss, 0, DEFAULT_MAX_LOSS_QUOTAS);
          break;
      default:
          printf("\nWrong loss (%d)!\n", loss);
          exit(1);
    }          
}

#if 0
void computePacketLoss(PyraGlobal *pyraData, layerDecData *ldd, concealDispVal *cd, int loss)
{
    ldd->curIndex = (++ldd->curIndex) % cd->considered;
    switch ( loss )
    {
      case COMPUTE_LOSS:
          ldd->percentloss[ldd->curIndex] = (100 - ((100 * pyraData->decGOBsCounter) / pyraData->GOBs_in_pict));
          ldd->accuPercentLoss += ldd->percentloss[ldd->curIndex];
          break;
      default:
          ldd->percentloss[ldd->curIndex] = loss;
          ldd->accuPercentLoss += loss;
    }          
}
#endif

