/*
 * black.c -- a small program that draws a black window.
 * 
 * compile with
 *	cc -o black black.c -I /usr/openwin/include -L/usr/openwin/lib -lX
 *
 * 17.7.98, jw
 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#define WIN_W	60
#define WIN_H	600

main(argc, argv)
int argc;
char **argv;
{
  Display *dis;
  Window win;
  GC gc1;
  XEvent	event;
  KeySym	key;
  XSizeHints	hint;
  XWMHints wmhints;
  int screen, i, j, done, iswide = 0, conf = 0, cw, ch,
	  w, h, zoom = 100, grid = 10;
  unsigned long fg, bg;
  char text[10];

  if ((dis = XOpenDisplay(NULL)) == NULL)
    {
      fprintf(stderr, "cannot open DISPLAY\n");
      exit(1);
    }

  screen = DefaultScreen(dis);
  fg = WhitePixel(dis, screen);
  bg = BlackPixel(dis, screen);

  w = hint.width = ScreenOfDisplay(dis, screen)->width + 64;
  h = hint.height = ScreenOfDisplay(dis, screen)->height + 64; 
  
  hint.flags = PSize | USPosition;

  win = XCreateSimpleWindow (dis, DefaultRootWindow(dis),
				  -32, -32, hint.width, hint.height, 5, fg, bg);
  XSetStandardProperties (dis, win, "black", "black",
		  None, argv, argc, &hint);

  gc1 = XCreateGC(dis, win, 0, 0);
  XSetBackground(dis, gc1, bg);
  XSetForeground(dis, gc1, fg);
  XSelectInput (dis, win, KeyPressMask | ExposureMask | StructureNotifyMask);
  wmhints.input = True;
  XSetWMHints(dis, win, &wmhints);
  XMapRaised (dis, win);
  done = 0;
  while ( !done )
    {
      XNextEvent( dis, &event );
      switch(event.type) 
	{
	case Expose:
	  break;
	case ConfigureNotify:
	  if (event.xconfigure.width == w && 
	      event.xconfigure.height == h)
	    break;
	  w = event.xconfigure.width;
	  h = event.xconfigure.height;
	  XResizeWindow(dis, win,  w, h);
	  while(XCheckTypedEvent(dis, ConfigureNotify, &event))
	    ;
	  break;
	case KeyPress:
	  i = XLookupString (&event, text, 10, &key, 0);
	  if (i == 1 && (text[0] == 'q' || text[0] == 27))
	    done = 1;
	  break;
        }
    }

  XFreeGC(dis, gc1);
  XDestroyWindow(dis, win);
  XCloseDisplay(dis);
}
