/* 
 * This is decoder-cosmo.cc with a lot of changes,
 * split into a .h and a .cc file...
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /src/multimedia/LOCAL/vic/vic-Marcus/RCS/dcosmo.cc,v 1.1 1997/09/09 15:34:16 msmeissn Exp msmeissn $ (LBL)";
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <dmedia/cl.h>
#include <dmedia/cl_cosmo.h>
#include <dmedia/dm_image.h>
#include <vl/dev_ev1.h>
#include <vl/vl.h>
#include <bstring.h>   /* bcopy() */

#include "Tcl.h"
#include "inet.h"
#include "rtp.h"
#include "decoder.h"
#include "renderer.h"
#include "vw.h"
#include "iohandler.h"
#include "dcosmo.h"

#include  <gl/glws.h>


#include "renderer-window.h"

#define ALL_HARDWARE

#define Sr_DEBUG_not

#ifdef Sr_DEBUG
#define DTEXT(x) fprintf(stderr, "CosmoWindowDecoder: %s\n", x);
#else
#define DTEXT(x)
#endif

#define IS_INTERLACED 0

void
CosmoWindowDecoder::render_frame(const u_char* frm)
{
	//DTEXT(":render_frame()");
	/*
		memset(rvts_, now_, nblk_);
		YuvFrame f(now_, (u_int8_t*)frm, rvts_, inw_, inh_);
		VideoFrame g(now_, (u_int8_t*)frm, inw_, inh_);
		for (Renderer* p = engines_; p != 0; p = p->next_) {
			//if ((p->ft() & FT_HW) == 0)
				//p->consume(&f);
			WindowRenderer* wr = (WindowRenderer*)p;
			if(!wr)
				return;
			// XXX
			VideoWindow* vw = wr->get_window();
			vw->render(vbx_);
		}
	*/
	window_->render(vbx_);
}

int 
CosmoDecoder::command(int argc, const char*const* argv){

#ifdef Sr_DEBUG
	if(argc==2)
		fprintf(stdout, "CosmoDecoder::command(%d, %s %s\n", argc, argv[0], argv[1]);
	else if(argc==3)
		fprintf(stdout, "CosmoDecoder::command(%d, %s %s %s\n", argc, argv[0], argv[1], argv[2]);
#endif /* Sr_DEBUG */
	return Decoder::command(argc,argv);
}   

void
CosmoWindowDecoder::set_VWindow(VideoWindow* vw) {
	if(window_)  {
		if(vw != window_) {
			DTEXT("Changing windows.");
			window_ = 0;
			// Remove paths, and then reset them.
			remove_paths();
			set_VWindow(vw);
		}
		return;
	}
	DTEXT("set_VWindow");
	window_=vw;

#ifndef ALL_HARDWARE
	return;
#endif /* ALL_HARDWARE */
	install_paths();
}
void
CosmoWindowDecoder::remove_paths() {
	DTEXT("::remove_paths()");
	has_started = 0;
#ifndef ALL_HARDWARE
	return;
#endif /* ! ALL_HARDWARE */
	vlEndTransfer(server_, path_);
	vlDestroyPath(server_, path_);
	vlEndTransfer(server_, timing_path_);
	vlDestroyPath(server_, timing_path_);
}
void
CosmoWindowDecoder::install_paths() {
	DTEXT("::install_paths()");
	// XXX
	if(!window_) return;
#ifndef ALL_HARDWARE
	return;
#endif /* ALL_HARDWARE */
	VLControlValue val;

	path_ = vlCreatePath(server_, device_->dev, dev_, dev_);
	if (path_ <= 0) {
		vlPerror ("Unable to create VLPath");
		// hm
		exit(-1);
	}
	if(vlSetupPaths(server_, (VLPathList)&path_, 1 /* #paths*/, VL_SHARE /* ctrlusage*/,
	  VL_READ_ONLY /* usagetype */) <0 ){
		vlPerror ("Unable to setup data path");
		exit(-1);
	}

	vlGetControl(server_, path_, dev_, VL_SYNC, &val);
    if (val.intVal == VL_EV1_SYNC_SLAVE) {
		DTEXT("VL_SYNC_INTERNAL");
		val.intVal = VL_SYNC_INTERNAL;
		if (vlSetControl(server_, path_, dev_, VL_SYNC, &val))
			vlPerror("Warning: unable to set video sync -- ");
	}


	vlGetControl(server_, path_, dev_, VL_TIMING, &val);
	//val.intVal = VL_TIMING_625_SQ_PIX; // PAL
	//val.intVal = VL_TIMING_525_SQ_PIX; // NTSC

	// shit. I can only get the correct-timing, if I know, what I receive: PAL || NTSC
	// And I only know this when I receive a field....
	// XXX Remove this here later
	//currentTiming = VL_TIMING_625_SQ_PIX;
// I ask myself, why this is defined everywhere and not in ONE .h-file...sigh
// S.B.

#define NTSC_WIDTH 640

	// XXX Quickhack
	int zx = window_->width();
	int zy = window_->height();

	// ok, quickhack. very quick.
	// but works for NTSC/PAL :)
	if(  NTSC_WIDTH%zx ==0) {
		currentTiming = VL_TIMING_525_SQ_PIX; 
	} else {
		currentTiming = VL_TIMING_625_SQ_PIX; 
	}

	if(val.intVal != currentTiming) {
		val.intVal = currentTiming;
		if (vlSetControl(server_, path_, dev_, VL_TIMING, &val))
			vlPerror("Warning: unable to set video timing -- ");
	}
	
	vlDestroyPath(server_, path_); 

	// (IndyVideo/Galileo -> Cosmo)
	timing_src_ = vlGetNode(server_, VL_SRC, VL_SCREEN, VL_ANY);
	timing_drn_ = vlGetNode(server_, VL_DRN, VL_VIDEO, 2);
	timing_path_ =
		vlCreatePath(server_, device_->dev, timing_src_, timing_drn_);
	if (timing_path_ == -1) {
		vlPerror("vlCreatePath failed for timing path");
		exit(1);
	}

	if (vlSetupPaths(server_, (VLPathList)&timing_path_, 1,
		VL_SHARE, VL_SHARE) < 0) {
		vlPerror ("Unable to start video timing -- ");
		exit (1);
	}

	if (vlBeginTransfer(server_, timing_path_, 0, NULL)) {
		vlPerror ("Unable to vlBeginTransfer video timing -- ");
		exit (1);
	}


	// data transfer: Cosmo via Galileo to screen
	src_ = vlGetNode(server_, VL_SRC, VL_VIDEO, 1);
	drn_ = vlGetNode(server_, VL_DRN, VL_SCREEN, VL_ANY);
	vdrn_ = vlGetNode(server_, VL_DRN, VL_VIDEO, 0);
	tmng_ = vlGetNode(server_, VL_DRN, VL_VIDEO, 2);

	path_ = vlCreatePath(server_, device_->dev, src_, drn_);
	if (path_ <= 0) {
		fprintf(stdout, "Failed to create VLPath: %d\n", path_);
		vlDestroyPath(server_, timing_path_);

		// hm
		exit(-1);
		//return;
	}

	if (vlAddNode(server_, path_, vdrn_)) {
		vlPerror("vdrain Node Error");
	}
	if (vlAddNode(server_, path_, tmng_)) {
		vlPerror("timing Node Error");
	}

	if(vlSetupPaths(server_, (VLPathList)&path_, 1 /* #paths*/, VL_SHARE /* ctrlusage*/,
	  VL_SHARE /* usagetype */) <0 ){
		vlPerror ("Unable to setup data path");
		vlDestroyPath(server_, timing_path_);

		// FIXME
		exit(-1);
	}


	zoomNum=1;
	zoomDen=1;
	// zx: 640/2 == NTSC, 768/2 == PAL
	// zy: 243 == NTSC, 288 == PAL
	// zx, zy are perhaps needed later for offset/size ?
	// else we can throw them away
	if( currentTiming == VL_TIMING_625_SQ_PIX) {
		if (zx>384 || zy>288) {
			zx = (zx>>1) & ~7;
			zy = (zy>>1) & ~7;
			zoomNum=2;
		}
	} else {
		if (zx>320 || zy>248) {
			zx = (zx>>1) & ~7;
			zy = (zy>>1) & ~7;
			zoomNum=2;
		}
	}
	if(zoomNum!=1) {
		//  num/den or ?? sigh ?
		val.fractVal.numerator = zoomNum;
		val.fractVal.denominator = zoomDen;
		vlSetControl(server_, path_, drn_, VL_ZOOM, &val);
	}

	vlGetControl(server_, path_, drn_, VL_SIZE, &val);
	val.xyVal.x = window_->width();
	val.xyVal.y = window_->height();
	vlSetControl(server_, path_, drn_, VL_SIZE, &val);


	/* XXX
	vlGetControl(server_, path_, drn_, VL_OFFSET, &val);
		val.xyVal.y -= 3;
	vlSetControl(server_, path_, drn_, VL_OFFSET, &val);
	*/


	Window dummywin;
	int x,y;
	vlGetControl(server_, path_, drn_, VL_ORIGIN, &val);
		/* 
		ROOTWINDOW with Tcl/Tk ??
		Tk_Parent() bis id || !NULL lt jw
		*/
	// Let's see if THIS avoids the bug...
	// the answer seems to be a clear 'No'
	//Tk_MakeWindowExist(window_->tkwin());
	//window_->map();
		// ==Tk_MapWindow(window_->tkwin());
	//XSync(Tk_Display(window_->tkwin()), false);
	//XFlush(Tk_Display(window_->tkwin()));
	if(!Tk_IsMapped(window_->tkwin())) {
		DTEXT("Not mapped!!!");
	}
	XTranslateCoordinates(Tk_Display(window_->tkwin()),
		Tk_WindowId(window_->tkwin()), 
		RootWindow(Tk_Display(window_->tkwin()),
			DefaultScreen(Tk_Display(window_->tkwin()))),
		0, 0,
		&val.xyVal.x, &val.xyVal.y,
		&dummywin);
	vlSetControl(server_, path_, drn_, VL_ORIGIN, &val);

	vlGetControl(server_, path_, drn_, VL_WINDOW, &val);
	val.intVal = Tk_WindowId(window_->tkwin());
	vlSetControl(server_, path_, drn_, VL_WINDOW, &val);

	/* started later
	if (vlBeginTransfer(server_, path_, 0, NULL) < 0) {
		vlPerror("vic: begin transfer decoder");
		exit(1);
	}
		has_started=1;
	*/
	DTEXT("install_paths() ready");
}

/*XXX*/
// CL_H is old style 
CLhandle CosmoDecoder::ch_;   /* cosmo handle */

CosmoDecoder::CosmoDecoder(int hdrlen) :
	PlaneDecoder(hdrlen), inq_(0)
{
	DTEXT("::SrDecoder() called");
	inw_=0;
	inh_=0;
	test=0;

	rw_ = -1;
	ch_ = NULL;
}

void CosmoDecoder::shutdown()
{
	DTEXT("::shutdown()");
	if (ch_ != 0) {
		clCloseDecompressor(ch_);
		ch_ = 0;
	}
}

void CosmoDecoder::startup()
{
	int s = clOpenDecompressor(CL_JPEG_COSMO, &ch_);
	if (s != 0) {
			printf("clOpenDecompressor failed: %d\n", s);
			exit(1);
	}
}

CosmoDecoder::~CosmoDecoder()
{
	shutdown();
}

void CosmoDecoder::release()
{
	/*XXX*/
	delete this;
}

#define JFIF_OFF_LUMA_QUANT 25
#define JFIF_OFF_CHROMA_QUANT (25+67)
#define M_SOI 0xd8
#define M_APP0 0xe0
#define M_DQT 0xdb
#define M_SOF0 0xc0
#define M_DHT 0xc4
#define M_SOS 0xda

u_char jfifhdr[] = {
	0xff, M_SOI,
	/* APP0 */
	0xff, M_APP0, /* len */ 0, 16,
	'J', 'F', 'I', 'F',
	0, /* v1.01 */ 1, 1,
	0, 0, 1, 0, 1, 0, 0,
	/* luma quantizer */
#define JFIF_OFF_LUMA_QUANT 25
#define JFIF_OFF_CHROMA_QUANT (25+67)
	0xff, M_DQT, 0, 67, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	/* chroma quantizer */
	0xff, M_DQT, 0, 67, 1,
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 

	0xff, M_SOF0,

	/* DC luma huffman code */
	0xff, M_DHT,
	0, 19 + 12,
	0, /* DC/luma */
	/* code lengths */
	0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
	/* values */
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,

	0xff, M_DHT,
	0, 19 + 162,
	0x10, /* AC/luma */
	/* code lengths */
	0, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 0x7d,
	/* values */
	0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12,
	0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
	0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08,
	0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
	0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
	0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
	0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
	0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
	0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
	0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
	0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
	0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
	0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
	0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
	0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4,
	0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
	0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
	0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
	0xf9, 0xfa,


	0xff, M_DHT,
	0, 19 + 12,
	0x01, /* DC/chroma */
	/* code lengths */
	0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	/* values */
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	

	0xff, M_DHT,
	0, 19 + 162,
	0x11, /* AC/chroma */
	/* code lengths */
	0, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 0x77,
	/* values */
	0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21,
	0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71,
	0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91,
	0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
	0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34,
	0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26,
	0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37, 0x38,
	0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
	0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
	0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
	0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
	0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96,
	0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
	0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4,
	0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3,
	0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2,
	0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda,
	0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
	0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
	0xf9, 0xfa,

	/* start-of-scan */
	0xff, M_SOS,
	0, 14,
	3,
	1, 0,
	2, 0x11,
	3, 0x11,
	0, 63, 0,
};

/*XXX*/
extern void jpeg_luma_qt(int q, int* qt);
extern void jpeg_chroma_qt(int q, int* qt);

//extern int quality_to_qfactor(int);

void
setq(int q)
{
	int qt[64];
#ifdef Sr_DEBUG
	fprintf(stderr, "dcosmo.cc::setq(%d)\n", q);
#endif /* Sr_DEBUG */

	jpeg_luma_qt(q, qt);
	for (int i = 0; i < 64; ++i)
		jfifhdr[i + JFIF_OFF_LUMA_QUANT] = qt[i];
	jpeg_chroma_qt(q, qt);
	for (i = 0; i < 64; ++i)
		jfifhdr[i + JFIF_OFF_CHROMA_QUANT] = qt[i];
}

void
CosmoWindowDecoder::recv(const rtphdr* rh, const u_char* bp, int len)
{   
	//const mms_ctl_parallax_jpeg* mh = (mms_ctl_parallax_jpeg*)(rh+1);
	const jpeghdr* mh = (jpeghdr*)(rh+1);
	int height = ntohs(mh->height)<<3;
	int width = ntohs(mh->width)<<3;
	unsigned int off = ntohl(mh->off);

	bp = reasm_.reassemble(rh, bp, len);
	if (bp==0) {
		return;
	}
		ndblk_ += len/16;
		test++;
	if(!window_) {
		Renderer* p = engines_;
		WindowRenderer* wr = (WindowRenderer*)p;
		if(!wr)
			return;
		// XXX
		VideoWindow* vw = wr->get_window();
		if(vw ==0 || vw->width()<100)
				return;
		set_VWindow(vw);
	}
	// XXX we should only do the decode, and not call renderframe from decode.
	decode(rh, bp, len);
	resetndblk();
}

void
CosmoWindowDecoder::redraw() {
	if(!vbx_ || !window_)
		return;
	window_->render(vbx_);
}

/* 
 * De-interlace: two fields -> one frame
*/
void
CosmoWindowDecoder::deinterlaceImage( u_char* vfrom, u_char* vto, int w, int h)
{
	//DTEXT("deinterlaceImage()");
	// XXX Signess
	char* from = vfrom;
	char* to   = vto;

	static int odd=0;
	int height, width;
	int i;

	/*
	 * de-interlace
	 */
	/* CosmoNet
		odd       = (image.interlacing == DM_IMAGE_INTERLACED_EVEN ? 0 : 1);
		height    = image.height;
		width     = image.width * 4;
	*/
	width = w * 4 ;
	// XXX
	// well, a kind to work...FIX ME
	if(!is_interlaced) {
		height = h;
		for ( i = 0; i < height/2; i++) {
				//bcopy(from+width*i, to+width*i, width);
				bcopy(from+width*i, to+width*2*i, width);
				bcopy(from+width*i, to+width*(2*i+1), width);
		}
		return;
	}


	height = 2*h;

		/* First field */
	for ( i = 0; i < height/2; i++)
			bcopy(from+width*i, to+width*(2*i+odd), width);
	odd = !odd;

	//DTEXT("Second Field");
		/* Second field */
	for ( i = 0; i < height/2; i++)
			bcopy(from+width*(i+(height/2)), to+width*(2*i+odd), width);
	odd = !odd;
	//DTEXT("Second Field - done");
}

void CosmoWindowDecoder::decode(const rtphdr* vh, const u_char* frame, int cc)
{

#ifdef notdef
static int n = 0;
char wrk[8];
sprintf(wrk, "f%d", n++);
int fd = open(wrk, O_WRONLY|O_CREAT|O_TRUNC, 0644);
if (fd < 0) {
	perror(wrk);
	exit(1);
}
write(fd, frame, cc);
close(fd);
#endif

	const jpeghdr* p = (const jpeghdr*)(vh+1);
	/*XXX need to handle p->type changes too!*/
	// FIXME
	// And what with changed width/heigth ???
	// -SB
	// HEIGHT ???
	// w& h -> set_window ? XXX
	//if (p->qfactor != inq_ || ch_ == 0 || (8*(p->width)!= rw_ ) || (inw_ != window_->width()) )
	if (p->q!= inq_ || ch_ == 0 || (8*ntohs(p->height)!= rh_ ) ) {
		reset(p->q, 8*(ntohs(p->width)), 8*(ntohs(p->height)));
	}

static unsigned char wrk[64*1024];
// If this is active, I don't see any frame/field...!(with ALL_HARDWARE)
/*
memcpy(wrk, jfifhdr, sizeof(jfifhdr));
memcpy(wrk + sizeof(jfifhdr), frame, cc);
cc += sizeof(jfifhdr);
frame = wrk;
*/


if (vbx_ == 0)
	abort();

	// XXX
	int fb[1024 * 1024 *2];

	/*Single frame decompression*/
	// int s = clDecompress(ch_, 1, cc, (void*)frame, (void*)vbx_->buffer());

	void *freeData;
	int wrap;

    int preWrap = clQueryFree( dataHdl, cc, &freeData, &wrap );

	if(cc < preWrap) {
		bcopy(frame, freeData, cc);
		if ( clUpdateHead( dataHdl, cc ) < 0 ) {
			vlPerror("clUpdateHead #0 failed" );
			exit(-1);
		}
	} else {
		bcopy(frame, freeData, preWrap);
		if ( clUpdateHead( dataHdl, preWrap ) < 0 ) {
			vlPerror("clUpdateHead #1 failed" );
			exit(-1);
		}

    	int new_preWrap = clQueryFree( dataHdl, 0, &freeData, &wrap );
		if( new_preWrap < 0) {
			vlPerror("clQueryFree failed for new_preWrap" );
			exit(-1);
		}
		bcopy(frame+preWrap, freeData, cc - preWrap);
		if ( clUpdateHead( dataHdl, cc - preWrap ) < 0 ) {
			vlPerror("clUpdateHead #2 failed" );
			exit(-1);
		}

	}



	//DTEXT("Decompressing");

	if( !has_started) {
		has_started=1;
		int s;
#ifdef ALL_HARDWARE
		s = clDecompress(ch_, CL_CONTINUOUS_NONBLOCK, 0, NULL, CL_EXTERNAL_DEVICE);
		// XXX
		if(window_) {
			if (vlBeginTransfer(server_, path_, 0, NULL) < 0) {
				vlPerror("vic: vlBeginTransfer decode");
				exit(1);
			}
		}
#else
		s = clDecompress(ch_, CL_CONTINUOUS_NONBLOCK, 0, NULL, NULL);
#endif /* ALL_HARDWARE */
		if (s < 0) {
			fprintf(stdout, "clDecompress failed (%d), trying to reset decoder\n", s);
			reset(inq_, rw_, rh_);
			return;
		}
	}

#ifndef ALL_HARDWARE

	CLimageInfo imageinfo;
	int status = clGetNextImageInfo( ch_, &imageinfo, sizeof(imageinfo) );
	if(status == SUCCESS) {
#ifdef Sr_DEBUG
		/*
		fprintf( stdout, "Got image info: field = %d  time = %llu, playout: %d\n",
				imageinfo.imagecount, imageinfo.ustime,
				imageinfo.imagecount-lastDecompressedField );
		*/
#endif /* Sr_DEBUG */
	}
	// XXXX
	if(imageinfo.imagecount< lastDecompressedField+1){
		//DTEXT("Continueing");
		return;
	}
	// XXX What about a while? Or a second testing? so that we could change 2
	// fields and reduce the playout?
	status = imageinfo.imagecount- lastDecompressedField;
	while(status) {
		lastDecompressedField++;
		status--;
		int actualField;
		 void *frameAddr;
		 // Blocks....so we should find a method to do this in an other thread then
		 // the feed of the decompressor...
		 // XXX wrap....!!
		 actualField = clQueryValid( fieldHdl, 1, &frameAddr, &wrap );
			if ( actualField < 0 ) {
					 DTEXT( "Error in clQueryValid" );
					 exit(-1);
			}
			// 1== #fields we used
			if ( clUpdateTail( fieldHdl, 1 ) < SUCCESS ) {
					DTEXT( "clUpdateTail failed." );
			}


		deinterlaceImage((unsigned char *)frameAddr, (unsigned char *)vbx_->buffer(), inw_, inh_);
		render_frame((const u_char*)(vbx_->buffer()));

		/*
		// XXX
		fprintf(stdout, "lrectwrite");
		GLXwinset(Tk_Display(window_->tkwin()), Tk_WindowId(window_->tkwin()));
		lrectwrite(0, 0, inw_-1, inh_-1, (const u_long*)vbx_->buffer());
		fprintf(stdout, "-done\n");
		*/
	}
#endif /* ! ALL_HARDWARE */
}

void
CosmoWindowDecoder::install_device() {
#ifndef ALL_HARDWARE
	return;
#endif
	DTEXT("install_device");
	server_ = vlOpenVideo("");
	if (server_ == 0) {
		fprintf(stdout, "Failed to open VLServer\n");
		// hm. should use Software if this fails, perhaps
		exit(-1);
	}
	device_=NULL;
	VLDevList list;
	vlGetDeviceList(server_, &list);
	VLDevice* p = list.devices;
	for (int n = list.numDevices; --n >= 0; ++p) {
		if (strcmp(p->name, "ev1") == 0) {
	    	device_ = p;
			break;
		}
	}

	// Hm. < || <= ??
	if (device_ == NULL ) {
		fprintf(stdout, " Didn't find Galileo\n");
		// hm
		exit(1);
	}

	/* VL_DEVICE == 3, the device node */
	dev_ = vlGetNode(server_, VL_DEVICE, 0, VL_ANY);

}

CosmoWindowDecoder::CosmoWindowDecoder(int hdrlen)
	: CosmoDecoder(hdrlen), window_(NULL), imagesize_(0), vbx_(0)
{
	DTEXT("CosmoWindowDecoder::CosmoWindowDecoder(int hdrlen)");
	is_interlaced=IS_INTERLACED;
	currentTiming = -1;
	has_started=0;
	dataHdl = NULL;
#ifndef ALL_HARDWARE
	fieldHdl = NULL;
#endif /* !ALL_HARDWEARE */
	install_device();
	test=0;
	lastDecompressedField=0;
}
CosmoWindowDecoder::CosmoWindowDecoder(int hdrlen, VideoWindow* vw)
	: CosmoDecoder(hdrlen), window_(0), imagesize_(0), vbx_(0)
{
	is_interlaced=IS_INTERLACED;
	currentTiming = -1;
	has_started=0;
	dataHdl = NULL;
#ifndef ALL_HARDWARE
	fieldHdl = NULL;
#endif /* !ALL_HARDWEARE */
	install_device();
	set_VWindow(vw); // to set the path_
	test=0;
	lastDecompressedField=0;
}

CosmoWindowDecoder::~CosmoWindowDecoder()
{
	DTEXT("~CosmoWindowDecoder()");
	remove_paths();
	if(dataHdl)
#ifdef ZZ
		clDestroyBuf( dataHdl );
		dataHdl= NULL;
#endif /* ZZ */
#ifndef ALL_HARDWARE
	if(fieldHdl)
#ifdef ZZ
		clDestroyBuf( fieldHdl );
		fieldHdl= NULL;
#endif /* ZZ */
#endif /* !ALL_HARDWEARE */
	vlCloseVideo(server_);
	/*
	 * Clear out the image so that the Video class does
	 * not try to use it before another window gets attached
	 * and replaces the image.
	 */
	window_->setimage(0);
}

void CosmoWindowDecoder::reset(int inq, int w, int h)
{
	/*
	 * Make sure all outstanding putimage's finish.
	 * Syncing with the first window, syncs the server,
	 * and hence all of them.
	 */
	// QQ
	//window_->sync();
#ifdef Sr_DEBUG
	fprintf(stdout, "CosmoWindowDecoder::reset(): inq = %d  w = %d, h = %d\n", inq, w, h);
#endif
	
/*XXX*/
if (inq == 0)
	return;

	DTEXT("reset");
	rw_ = w;
	rh_ = h;

	inq_ = inq;

	setq(inq);

	/* same, and inits
	inw_ = w;
	inh_ = h;
	*/
	resize(w, h);

	// XXX !!!
	// XXX !!!
	/*
	if(h == 144) {
		DTEXT("IS_INTER == 1 ");
		is_interlaced = 1;
	} else {
		DTEXT("IS_INTER == 0 ");
		is_interlaced = 0;
	}
	*/
		is_interlaced = 0;

	// XXX
	// since we _have_ to call this here because we shutdown the 
	// decompressor, it might be removeable elsewhere...
	// in this order, to give the board enough time to free the
	// scheme for the next open in startup()
	/* Test it..
	** And we should overthink the concept here.
	*/
	if(dataHdl) {
		if(has_started) {
#ifdef ALL_HARDWARE
			vlEndTransfer(server_, path_);
#endif /* ALL_HARDWARE */
		}
		/* I suppose, clCloseDecompresser removes this one, too
		*/
#ifdef ZZ
		clDestroyBuf(dataHdl);
		dataHdl=NULL;
#endif /* ZZ */
	}
	has_started = 0;
	shutdown();
	remove_paths();
	startup();
	install_paths();

	// shrink pics
	VLControlValue val;
#ifdef ALL_HARDWARE
	zoomDen = 1;
	if(w<(rw_>>1) || h< (rw_>>1)) {
		zoomDen =2;
		DTEXT("ZOOM HALF");
	}
	if(zoomDen!=1) {
		//  num/den or ?? sigh ?
		val.fractVal.numerator = zoomNum;
		val.fractVal.denominator = zoomDen;
		vlSetControl(server_, path_, drn_, VL_ZOOM, &val);
	}
#else
	zoomNum = zoomDen = 1;
#endif /* ALL_HARDWARE */

	// XXX
	//int compressedBufferSize = window_->width() * window_->height();
	int compressedBufferSize = inw_ * inh_ * 8;
	dataHdl = clCreateBuf( ch_, CL_DATA, compressedBufferSize, 1, NULL );

	int numberOfOptions=12;
#ifndef ALL_HARDWARE
	numberOfOptions +=2;
#endif /* !ALL_HARDWARE */
	int options[numberOfOptions];
	int* p = options;

	/*
	** Effect: clError: code=-14 clSetParams: Attempt to set param <Original format> to 6,
	**		only legal value is 1. Setting to 1.
	** 		clSetParams failed -14

	*p++ = CL_ORIGINAL_FORMAT;
	*p++ = CL_YUV422;
	*/

#ifdef Sr_DEBUG
	fprintf(stdout, "#### inw_/inh_: %d/%d    w/h:  %d/%d ###\n", inw_, inh_, w, h);
	fprintf(stdout, "#### inq_:  %d  zoom:  %d / %d\n", inq_, zoomNum, zoomDen);
#endif /* Sr_DEBUG */
// XXX
// internal values missing checks !!!
	*p++ = CL_IMAGE_WIDTH;
#ifndef ALL_HARDWARE
	*p++ = inw_;
#else
	*p++ = inw_/zoomNum;
#endif /* !ALL_HARDWARE */
	*p++ = CL_INTERNAL_IMAGE_WIDTH;
	*p++ = rw_;
	*p++ = CL_IMAGE_HEIGHT;
#ifndef ALL_HARDWARE
	//*p++ = inh_>>1;
	if(is_interlaced)
		*p++ = inh_>>0;
	else
		*p++ = inh_>>1;
#else
	*p++ = (inh_/zoomNum)>>1;
#endif /* !ALL_HARDWARE */
	*p++ = CL_INTERNAL_IMAGE_HEIGHT;
	*p++ = rh_;
	*p++ = CL_JPEG_QUALITY_FACTOR;
	*p++ = inq_;

	/*
	*p++ = CL_COSMO_VIDEO_TRANSFER_MODE;
	*p++ = CL_COSMO_VIDEO_TRANSFER_AUTO_1_FIELD;
	*/

	/*XXX*/
	*p++ = CL_STREAM_HEADERS;
	*p++ = 0;
#ifdef notdef
	*p++ = CL_ORIGINAL_FORMAT;
	*p++ = ?;
#endif
#ifndef ALL_HARDWARE
	*p++ = CL_ENABLE_IMAGEINFO;
	*p++ = 1;
#endif /* !ALL_HARDWARE */

	int s = clSetParams(ch_, options, numberOfOptions);
	if (s != 0) {
		// printf("clSetParams failed\n");
		printf("clSetParams failed %d, %s\n", s, vlStrError(vlErrno));
		/* FIXME I don't think we should exit here ALWAYS -SB */
		// -14  : trust on auto-correction of card
		//if(s!=-14) {
			exit(1);
		//}
	}
	// This HAS TO BE after the SetParam!!!
	// 4 == NumberOfFields max in the buffer
#ifndef ALL_HARDWARE
	int frameSize = rw_ * rh_ * sizeof(int)*2;
	/* I suppose, clCloseDecompresser removes this one, too
	if(fieldHdl!=NULL) {
		DTEXT("Removing fieldHdl in reset()");
		CLimageInfo imageinfo;
		int status = clGetNextImageInfo( ch_, &imageinfo, sizeof(imageinfo) );
		if(imageinfo.imagecount> lastDecompressedField+1){
			if ( clUpdateTail( fieldHdl, 1 ) < SUCCESS ) {
				DTEXT( "clUpdateTail failed." );
			}
		}
#ifdef ZZ
		clDestroyBuf(fieldHdl);
		fieldHdl=NULL;
#endif // ZZ
	}
	*/
	fieldHdl = clCreateBuf( ch_, CL_FRAME, 4, frameSize, NULL );
	// :) New Framebuffer, new count..
	lastDecompressedField=0;

	/*
	// useless if lrectwrite many lines above doesn't work...
	int x,y;
	Window dummywin;

	XTranslateCoordinates(Tk_Display(window_->tkwin()), Tk_WindowId(window_->tkwin()), 
		RootWindow(Tk_Display(window_->tkwin()), DefaultScreen(Tk_Display(window_->tkwin()))),
		0, 0,
		&x, &y,
		&dummywin);
	*/
#endif /* !ALL_HARDWARE */
	// QQ Window below!
	if(!window_) {
		return;
	}
	if (vbx_ == 0 || vbx_->width() != inw_ || vbx_->height() != inh_) {
		if(is_interlaced) 
			vbx_ = new SharedVideoImage(window_->tkwin(), w, 2*h);
		else
			vbx_ = new SharedVideoImage(window_->tkwin(), w, h);
	}
}
