/* 
 * This is decoder-cosmo.cc with a lot of changes,
 * split into a .h and a .cc file...
 */


#include <stdlib.h>
#include <sys/types.h>
#include <dmedia/cl.h>
#include <dmedia/cl_cosmo.h>
#include <vl/dev_ev1.h>
#include <vl/vl.h>

#include "Tcl.h"
#include "inet.h"
#include "rtp.h"
#include "decoder.h"
#include "vw.h"
#include "iohandler.h"
#include "device-output.h"
#include "output-vl.h"
#include "reass.h"


class CosmoDecoder : public PlaneDecoder {
protected:
	CosmoDecoder(int);
public:
	~CosmoDecoder();
	void sync() {}
	int colorhist(u_int* histogram) const { return (0); }
	void release();
	void reset(const u_char* vh);
	//void resize(int w, int h) { reset(inq_, w, h); }
protected:
	int command(int ac, const char*const* av);
	virtual void reset(int inq, int inw, int inh) = 0;

	void shutdown();
	void startup();

	int rw_;		/* width of rendered image */
	int rh_;		/* height of rendered image */
	int inq_;		/* input quantization */
	int zoomNum;	/* needed for zoom */
	int zoomDen;	/* needed for zoom */
	int vs_;		/* vl server */
	// CL_H old style, changed to new */
	static CLhandle ch_;	/* cosmo handle */
	int test;
	u_char* frm_; // if we use PlaneDecoder, we would have this...
	Sr_JpegReassembler reasm_;
};

class CosmoWindowDecoder : public CosmoDecoder {
public:
	CosmoWindowDecoder(int);
	CosmoWindowDecoder(int, VideoWindow*);
	~CosmoWindowDecoder();
	void set_VWindow(VideoWindow* vw);
	void recv(const struct rtphdr* rh, const u_char* bp, int len);
protected:
	void reset(int inq, int inw, int inh);
	void redraw();
	void decode(const struct rtphdr* vh, const u_char* data, int len);
	void render_frame(const u_char* frm);
	void deinterlaceImage( u_char* vfrom, u_char* vto, int w, int h);

	void install_device();
	void install_paths(); // SB XXX
	void remove_paths(); // SB
	VideoWindow* window_;
	void allocimage();
	int imagesize_;
	SharedVideoImage* vbx_;
	VLServer server_; // SB
	VLDevice *device_;	// SB
	VLPath path_;	// SB
	VLNode dev_; // SB
	VLNode src_; // SB
	VLNode drn_; // SB
	VLNode vdrn_; // SB
	VLNode tmng_; // SB
	VLPath timing_path_;	// SB
	VLNode timing_src_; // SB
	VLNode timing_drn_; // SB
	CLbufferHdl dataHdl;     /* Buffer for compressed image data. */
	CLbufferHdl fieldHdl;     /* Buffer for decompressed image data still in fields. */
	int currentTiming; // SB
	int test; // SB XXX
	int is_interlaced; // SB
	int has_started; // SB
	int lastDecompressedField; // SB
};

#ifdef SB_not
static class JpegHardwareDecoderMatcher : public HardwareDecoderMatcher {
 protected:
	Decoder* match(int fmt, VideoWindow* vw) {
		if (fmt == RTP_PT_JPEG )
			return (new CosmoWindowDecoder(vw));
		return (0);
	}
} hwd_jpeg_;

#else
#ifdef NEXTGEN
static class SrDecoderMatcher : public Matcher {
public:
	SrDecoderMatcher() : Matcher("decoder") {}
	TclObject* match(const char* fmt) {
		if (strcasecmp(fmt, "sr") == 0) {
			return (new SrDecoder());
		} else {
			return (0);
		}
																														        }
} dm_sr;

#else
static class JpegHardwareDecoderMatcher : public Matcher {
public:
        JpegHardwareDecoderMatcher() : Matcher("decoder") {}
		TclObject* match(const char* fmt) {
		if (strcasecmp(fmt, "jpeg") == 0 ||
			strcasecmp(fmt, "jpeg/hdw") == 0)
				return (new CosmoWindowDecoder(sizeof(jpeghdr)));
		else
				return (0);
		}
} hwd_jpeg_;

#endif /* NEXTGEN */

#endif /* SB */
