/*
 * (c) Marcus Meissner
 */
static const char rcsid[] =
    "@(#) $Header: /src/multimedia/LOCAL/vic/vic-Marcus/RCS/decoder-pyra.cc,v 1.18 1998/08/19 12:46:07 msmeissn Exp msmeissn $ (LBL)";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "inet.h"
#include "rtp.h"
#include "decoder.h"
#include "module.h"
#include "renderer.h"

extern "C" {
#include "NTCODEC/include/Util.h"
#include "NTCODEC/include/h263decoder.h"
#include "NTCODEC/include/pyradecoder.h"
};

#include "h263.h"
#include "pyra.h"

#include "decoder-pyra.h"

#define GOBS_PER_PYRAFRAME(pyra)	pyra->GOBs_in_pict
#define MBS_PER_PYRAGOB(pyra)		pyra->MBs_in_GOB
#define GOBS_PER_H263FRAME(h263)	h263->gobs_in_pict
#define MBS_PER_H263GOB(h263)		h263->mbs_in_gob
#define X16LINES_PER_GOB(pyra)		(pyra->MBs_in_GOB/pyra->MBs_in_row)

u_char *pyraframe_;

PyraDecoder::PyraDecoder() : Decoder(0)
{
	nstat_ = 0;
	lastknowngood_ = 0;
	decimation_ = 411;
	srcformat_ = 0;
	frame_ = new u_char[1];
	h263streamsize_ = 0;
	h263stream_ = new u_char[1];
	memset(slot_,0,sizeof(slot_));
	for (int i = 0; i < B_SLOTS; i++) {
		slot_[i].tr = 0;
		slot_[i].cc = 0;
		slot_[i].layernr = 0;
		slot_[i].bp = new u_char[2000];
		memset(slot_[i].bp,0,2000);
	}

	pyraframe_ = NULL;
	pl_ = new pyralayer[1];
	lasttr_ = 0;
	maxlayers_ = 0;
}

PyraDecoder::~PyraDecoder()
{
	for (int i = 0; i < B_SLOTS; ++i)
		delete[] slot_[i].bp;
}

/* more info */
void PyraDecoder::info(char* wrk) const
{
	sprintf(wrk, "[q=42]");
}

/* no special stats */
void PyraDecoder::stats(char* wrk)
{
	Decoder::stats(wrk);
}

/* must stay */
int PyraDecoder::colorhist(u_int* hist) const
{
	int w = inw_;
	int h = inh_;
	int s = w * h;
	colorhist_411_556(hist,frame_,frame_+s,frame_+s+(s>>2),w,h);
	return (1);
}

int PyraDecoder::InitLayerReferences(int nl, int lastDecLayer)
{
	assert(nl>=0);
	assert(nl<maxlayers_);
	assert(lastDecLayer<maxlayers_);
	if (!pl_[nl].u.pyra)
		return 0;
	if ((lastDecLayer >=0) && (!pl_[lastDecLayer].u.h263))
		return 0;
	if (lastDecLayer >= 0 && !pl_[nl].u.pyra->first) {
		switch (pl_[lastDecLayer].layertype) {
		case LAYERTYPE_H263:
			if (pl_[lastDecLayer].u.h263->first)
				return 0;
			MV2MVField(pl_[lastDecLayer].u.h263->MV,
				 pl_[lastDecLayer].u.h263->modemap,
				 pl_[lastDecLayer].u.h263->coded_picture_width/16,
				 pl_[lastDecLayer].layeruncoded,
				 pl_[nl].u.pyra->mvf,
				 pl_[nl].layeruncoded);
			break;
		case LAYERTYPE_PYRA:
			if (pl_[lastDecLayer].u.pyra->first)
				return 0;
			SampleUpMVField(pl_[lastDecLayer].u.pyra->mvf,
				      pl_[lastDecLayer].layeruncoded,
				      pl_[nl].u.pyra->mvf,
				      pl_[nl].layeruncoded);
			break;
		default: assert(0);
		}
	}
 
	if (lastDecLayer < 0)
		lastDecLayer = nl + 1;
	if (!pl_[lastDecLayer].u.h263) {
		return 0;
	}
	switch (pl_[lastDecLayer].layertype) {
	case LAYERTYPE_H263:
		if (!pl_[lastDecLayer].u.h263->newframe[0])
			return 0;
		pl_[nl].u.pyra->SpatRefPic->w = pl_[nl].u.pyra->SpatRefPic->ws =
			pl_[lastDecLayer].u.h263->coded_picture_width;
		pl_[nl].u.pyra->SpatRefPic->h = pl_[nl].u.pyra->SpatRefPic->hs =
			pl_[lastDecLayer].u.h263->coded_picture_height;
		pl_[nl].u.pyra->SpatRefPic->y =
			pl_[lastDecLayer].u.h263->newframe[0];
		pl_[nl].u.pyra->SpatRefPic->u =
			pl_[lastDecLayer].u.h263->newframe[1];
		pl_[nl].u.pyra->SpatRefPic->v = 
			pl_[lastDecLayer].u.h263->newframe[2];
		break;
	case LAYERTYPE_PYRA:
		if (!pl_[lastDecLayer].u.pyra->DecPic)
			return 0;
		LinkPicture(pl_[lastDecLayer].u.pyra->DecPic, pl_[nl].u.pyra->SpatRefPic);
		break;
	default:
		// happens, when we are right into the middle of a decoding
		// run.
		return 0;
	}
	return 1;
}

/*
 * We need to reassemble mode B blocks to either a complete image, or
 * a number of gobs. yuck.
 * 
 * start found when:	This block is mode B, but starts with GOB/PSC header
 * end found when:	last B block has RTP_M set
 *			next block in sync is mode A.
 */
int
PyraDecoder::reassemble_h263_gobs(const int layernr,u_char **newbp,int *newcc,int tr)
{
	u_int	startblock,lowestseq,seqstart,j,i,xi,x,l,last,size,sbit,seqno,firstlong;
	int	endblock;
	u_char	*p;

	lowestseq=0xfffff;seqstart=0;
	for (i=0;i<B_SLOTS;i++) {
		if (!slot_[i].cc)
			continue;
		if (slot_[i].seqno<lowestseq) {
			lowestseq = slot_[i].seqno;
			seqstart=i;
		}
	}
	/*
	 * find out if we have some full GOBs in the queue
	 */
	for (i=0;i<B_SLOTS;i++) {
		xi = (i+seqstart) & B_SLOTMASK;
		seqno = slot_[xi].seqno;
		/* in the first bytes should be the 22 bits PSC */
		/* 0000 0000 0000 0000 100000 */
		p = slot_[xi].bp;
		firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
		if (!slot_[xi].cc) 		// if handled, continue.
			continue;
		if (slot_[xi].layernr!=layernr)
			continue;
		if (slot_[xi].tr!=tr)
			continue;
		if (!slot_[xi].header.h263b.ftype)  {
			// mode A ... return it
			assert((firstlong & 0xffff8000)==0x00008000);
			*newbp = slot_[xi].bp;
			*newcc = slot_[xi].cc;
			slot_[xi].cc = 0;
			return 1;
		}
		// detect GOB start. we _NEED_ it.
		if ((firstlong & 0xffff8000) != 0x00008000)
			continue;

		/* find longest possible path. (otherwise this gives losses
		 * when wrapping around in the ringbuffer
		 */
		startblock = xi;
		for (j=B_SLOTS;j--;) {
			x=(xi+j)&B_SLOTMASK;
			
			p = slot_[x].bp;
			firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
			if (slot_[x].layernr!=layernr) {
				break;
			}
			if (!slot_[x].cc) {
				break;
			}
			if (!slot_[x].header.h263b.ftype) {
				break;
			}
			if ((slot_[x].seqno&0xffff)!= (seqno+(j-B_SLOTS))&0xffff) {
				break;
			}
			// detect GOB start. we _NEED_ it.
			if ((firstlong & 0xffff8000) != 0x00008000)
				continue;
			startblock = x;
		}
		if (xi!=startblock) {
			seqno=slot_[startblock].seqno;
		}

		endblock = -1;
		for (j=0;j<B_SLOTS;j++) {
			x=(startblock+j)&B_SLOTMASK;
			// follow slotmasks.
			if ((slot_[x].seqno&0xffff)!= (seqno+j)&0xffff) {
				break;
			}
			if (!slot_[x].cc) {// done already -> continue
				if (j)
					endblock = j-1;
				break;
			}
			if (slot_[x].layernr!=layernr) {
				if (j)
					endblock = j-1;
				break;
			}
			p = slot_[x].bp;
			firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
			if ((firstlong & 0xffff8000) == 0x00008000)
				if (j) {
					endblock=j-1;
					break;
				}

			if (!slot_[x].header.h263b.ftype) {
				if (j)
					endblock = j-1;
				break;
			} else {
				if (slot_[x].rtflags&RTP_M) {// got endmarker.
					endblock = j;
					break;
				}
			}
		}
		if (endblock<=0) {
			continue;
		}

		size = 0;
		for (l=0;l<=endblock;l++) {
			x=(startblock+l)&B_SLOTMASK;
			size+=slot_[x].cc;
			if (slot_[x].header.h263b.ebit)
				size--;
		}
		size+=16;
		if (size>h263streamsize_) {
			delete[] h263stream_;
			h263stream_ = new u_char[size];
			memset(h263stream_,0x42,size);
			h263streamsize_ = size;
		}
		memset(h263stream_,0,h263streamsize_);
		last=0;
		for (l=0;l<=endblock;l++) {
			x=(startblock+l)&B_SLOTMASK;
			if (slot_[x].header.h263b.sbit) {
				h263stream_[last]|=slot_[x].bp[0];
				last++;
				memcpy(h263stream_+last,slot_[x].bp+1,slot_[x].cc-1);
				last+=slot_[x].cc-1;
			} else {
				memcpy(h263stream_+last,slot_[x].bp,slot_[x].cc);
				last+=slot_[x].cc;
			}
			if ((l<endblock) && slot_[x].header.h263b.ebit)
				last--;
			slot_[x].cc = 0;
		}
		firstlong = (h263stream_[0]<<24)+(h263stream_[1]<<16)+(h263stream_[2]<<8)+h263stream_[3];
		assert ((firstlong & 0xffff8000) == 0x00008000);
		*newbp = h263stream_;
		*newcc = last;
		return 1;
	}
	return 0;
}

inline int
PyraDecoder::reassemble_pyra_gobs(int layernr,u_char **newbp,int *newcc,int tr,struct pyralayerrtpheader *xprh)
{
	u_int	startblock,seqstart,j,i,xi,x,l,last,size,sbit,seqno,firstlong;
	u_char	*p;
	int	endblock,lowestseq;

	lowestseq=0xfffff;seqstart=0;
	for (i=0;i<B_SLOTS;i++) {
		if (!slot_[i].cc)
			continue;
		if (slot_[i].seqno<lowestseq) {
			lowestseq = slot_[i].seqno;
			seqstart=i;
		}
	}
	/*
	 * find out if we have some full GOBs in the queue
	 */
	for (i=0;i<B_SLOTS;i++) {
		xi = (i+seqstart) & B_SLOTMASK;
		seqno = slot_[xi].seqno;
		/* in the first bytes should be the 22 bits PSC */
		/* 0000 0000 0000 0000 0000 0001 0000  */
		p = slot_[xi].bp;
		firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
		if (!slot_[xi].cc) 		// if handled, continue.
			continue;
		if (slot_[xi].layernr!=layernr)
			continue;
		if (slot_[xi].tr!=tr)
			continue;
#if 0
		if (!slot_[xi].prh.modeb)  {	// mode A ... return it
			*newbp = slot_[xi].bp;
			*newcc = slot_[xi].cc;
			slot_[xi].cc = 0;
			*xprh = slot[xi].prh;
			return 1;
		}
#endif
		// detect GOB start. we _NEED_ it.
		if ((firstlong & 0xffffff00) != 0x00000100)
			continue;

		/* find longest possible path. (otherwise this gives 
		 * when wrapping around in the ringbuffer
		 */
		startblock = xi;
		for (j=B_SLOTS;j--;) {
			x=(xi+j)&B_SLOTMASK;
			
			p = slot_[x].bp;
			firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
			/*
			if (!slot_[x].prh.modeb)  {
				slot_[x].cc = 0;
				break;
			}
			*/
			if (slot_[x].layernr!=layernr)
				break;
			if (!slot_[x].cc)
				break;
			if ((slot_[x].seqno&0xffff)!= (seqno+(j-B_SLOTS))&0xffff)
				break;
			// detect GOB start. we _NEED_ it.
			if ((firstlong & 0xffffff00) != 0x00000100)
				continue;
			startblock = x;
		}
		if (xi!=startblock)
			seqno=slot_[startblock].seqno;

		
		endblock = -1;
		for (j=0;j<B_SLOTS;j++) {
			x=(startblock+j)&B_SLOTMASK;
			// follow slotmasks.
			if ((slot_[x].seqno&0xffff)!= (seqno+j)&0xffff)
				break;
			if (!slot_[x].cc) {// done already -> continue
				if (j)
					endblock = j-1;
				break;
			}
			if (slot_[x].layernr!=layernr) {
				if (j)
					endblock = j-1;
				break;
			}
			p = slot_[x].bp;
			/*
			firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];
			if ((firstlong & 0xffffff00) == 0x00000100)
				if (j) {
					endblock=j-1;
					break;
				}
			 */

			// FIXME: add check for mode A block.
			/*
			if (!slot_[x].prh.modeb) {
				endblock = j-1;
				break;
			} else {
			*/
				if (slot_[x].rtflags&RTP_M) {// got endmarker.
					endblock = j;
					break;
				}
			/*
			}
			*/
		}
		if (endblock==-1)
			continue;
		size = 0;
		for (l=0;l<=endblock;l++) {
			x=(startblock+l)&B_SLOTMASK;
			size+=slot_[x].cc;
			if (slot_[x].header.prh.ebit)
				size--;
		}
		size+=16;
		if (size>h263streamsize_) {
			delete[] h263stream_;
			h263stream_ = new u_char[size];
			h263streamsize_ = size;
		}
		memset(h263stream_,0x42,h263streamsize_);
		last=0;
		for (l=0;l<=endblock;l++) {
			x=(startblock+l)&B_SLOTMASK;
			if (slot_[x].header.prh.sbit) {
				if (last)
					assert(h263stream_[last]==slot_[x].bp[0]);
				h263stream_[last]|=slot_[x].bp[0];
				last++;
				memcpy(h263stream_+last,slot_[x].bp+1,slot_[x].cc-1);
				last+=slot_[x].cc-1;
			} else {
				memcpy(h263stream_+last,slot_[x].bp,slot_[x].cc);
				last+=slot_[x].cc;
			}
			if ((l<endblock) && slot_[x].header.prh.ebit)
				last--;
			slot_[x].cc = 0;
		}
		/*
		fprintf(stderr,"pyra: reassembled, %d bytes\n",last);
		for (l=0;l<=3;l++)
			fprintf(stderr,"%02x ",h263stream_[l]);
		fprintf(stderr,"...");
		for (l=0;l<=3;l++)
			fprintf(stderr," %02x",h263stream_[last-1-l]);
		fprintf(stderr,"\n");
		*/
		*newbp = h263stream_;
		*newcc = last;
		*xprh = slot_[startblock].header.prh;
		return 1;
	}
	return 0;
}

/* Guess the layertype of the frame we got. 
 * Uses: 
 *	Some trivial rejects based on pyra header vs h263 header.
 *	Looks for synchwords.
 * (Fails probably for h263 mode B blocks)
 */
static int PyraDecoder::guess_layertype(u_char *bp,unsigned short seqno) {
	u_char	*start;
	int	i;
	long	firstlong;
	pyralayerrtpheader	*prh	= (pyralayerrtpheader*)bp;
	h263rtpheader_A		*h263rh = (h263rtpheader_A*)bp;


	// two impossible events for pyra rtpheaders
	if (prh->layernr>prh->maxlayers)
		return LAYERTYPE_H263;
	if (!prh->maxlayers)
		return LAYERTYPE_H263;
	if (!prh->tempdist)
		return LAYERTYPE_H263;

	// 4 is the minimum headersize. avoids false positives
	for (i=4;i<16;i++) {
		if (bp[i])
			continue;
		firstlong = (bp[i]<<24)|(bp[i+1]<<16)|(bp[i+2]<<8)|bp[i+3];
		if ((firstlong & 0xffff8000) == 0x00008000)
			return LAYERTYPE_H263;
		if ((firstlong & 0xffffff00) == 0x00000100)
			return LAYERTYPE_PYRA;
	}
	if (((slot_[(seqno+B_SLOTS-1)&B_SLOTMASK].seqno+1)&0xffff)==seqno) {
	/* scheint zu funktionieren ...
		fprintf(stderr,"previous type %d\n",
			slot_[(seqno+B_SLOTS-1)&B_SLOTMASK].layertype
		);
	 */
		return slot_[(seqno+B_SLOTS-1)&B_SLOTMASK].layertype;
	}
	fprintf(stderr,"couldn't guess type of packet!\n");
	return -1;
}

void PyraDecoder::recv(const rtphdr* rh, const u_char* bp, int cc)
{
	int			guessed_layertype,presentmask=0,seqno,w,h,i,lastlayer;
	int			havebase=0,layernr,newmaxlayers;
	pyralayerrtpheader	*prh	= (pyralayerrtpheader*)bp;
	h263rtpheader_A		*h263rh	= (h263rtpheader_A*)bp;
	pyralayer		*pl;
	int			isbaselayer,currenttr,offset=0;

	guessed_layertype = guess_layertype(bp,ntohs(rh->rh_seqno));
	if (guessed_layertype==-1)
		return;
	switch (guessed_layertype) {
	case LAYERTYPE_H263:
		if (h263rh->ftype) {
			offset = sizeof(h263rtpheader_B);
			assert(offset==8);
		} else {
			offset = sizeof(h263rtpheader_A); 
			assert(offset==4);
		}
		break;
	case LAYERTYPE_PYRA:
		offset = sizeof(pyralayerrtpheader);
		break;
	default://cannot happen
		assert(0);
		break;
	}
	layernr = -1;
	if (guessed_layertype == LAYERTYPE_PYRA) {
		layernr		= prh->layernr;
		newmaxlayers	= prh->maxlayers;
	}
	if (guessed_layertype == LAYERTYPE_H263) {
		if (maxlayers_<0) {
			return;
		}
		// we might have only a single h263 layer
		if (!maxlayers_) {
			newmaxlayers = 0;
			layernr = 0;
			return; // hmm.
		} else {
			layernr = maxlayers_-1;
			newmaxlayers = maxlayers_-1;
		}
	}
	seqno = ntohs(rh->rh_seqno);
	slot_[seqno & B_SLOTMASK].seqno	  = seqno;
	if (slot_[seqno & B_SLOTMASK].cc)
		fprintf(stderr,"-");
	slot_[seqno & B_SLOTMASK].cc	  	= cc-offset;
	slot_[seqno & B_SLOTMASK].layertype  	= guessed_layertype;
	slot_[seqno & B_SLOTMASK].rtflags 	= ntohs(rh->rh_flags);
	slot_[seqno & B_SLOTMASK].layernr 	= layernr;
	memcpy(&(slot_[seqno & B_SLOTMASK].header),bp,offset);
	memcpy(slot_[seqno & B_SLOTMASK].bp,bp+offset,cc-offset);

	currenttr = slot_[seqno & B_SLOTMASK].tr= ntohl(rh->rh_ts);

	pl = pl_+layernr;
	if (maxlayers_ < newmaxlayers+1) {
		pyralayer *newpl;
		
		newpl = new pyralayer[newmaxlayers+1];
		if (pl_)
			memcpy(newpl,pl_,sizeof(pyralayer)*maxlayers_);
		delete[] pl_;
		pl_ = newpl;
		for (i=maxlayers_;i<newmaxlayers+1;i++) {
			pl_[i].w = 0;
			pl_[i].h = 0;
			pl_[i].u.h263 = NULL;
			pl_[i].layertype = -1;
			pl_[i].layeruncoded = 0;
		}
		maxlayers_ = newmaxlayers+1;
		pl = pl_+layernr;
	}
	if (maxlayers_ > newmaxlayers+1) {
		pyralayer *newpl;
		
		for (i=maxlayers_;i<newmaxlayers+1;i++) {
			switch (pl_[i].layertype) {
			case LAYERTYPE_H263:
				DisinitH263Decoder(pl_[i].u.h263);
				FreeH263Decoder(pl_[i].u.h263);
				break;
			case LAYERTYPE_PYRA:
				DisinitPyraDecoder(pl_[i].u.pyra);
				FreePyraDecoder(pl_[i].u.pyra);
				break;
			default:
				assert(42==46);
			}
		}
		newpl = new pyralayer[newmaxlayers+1];
		memcpy(newpl,pl_,sizeof(pyralayer)*(newmaxlayers+1));
		delete[] pl_;
		pl_ = newpl;
		maxlayers_ = newmaxlayers+1;
	}
	if (pl->layertype && (pl->layertype!=guessed_layertype)) {
		/* fprintf(stderr,"changing layertype for layer %d from %d to %d\n",
			layernr,
			pl->layertype,
			guessed_layertype
		); */
		pl->w = 0; // reset decoder
		if (pl->u.h263) {
			switch (pl->layertype) {
			case LAYERTYPE_H263:
				if (!pl->u.h263->first)
					DisinitH263Decoder(pl->u.h263);
				FreeH263Decoder(pl->u.h263);
				break;
			case LAYERTYPE_PYRA:
				if (!pl->u.pyra->first)
					DisinitPyraDecoder(pl->u.pyra);
				FreePyraDecoder(pl->u.pyra);
				break;
			default:break;
			}
			pl->u.h263 = NULL;
			pl->u.pyra = NULL;
		}
	}
	pl->layertype = guessed_layertype;

	if (pl->layertype==LAYERTYPE_H263) {
		// mode B and A have the same layout for this one
		switch (h263rh->srcformat) {
                case 1:w = SQCIF_WIDTH;h = SQCIF_HEIGHT; break;
                case 2:w = QCIF_WIDTH;h = QCIF_HEIGHT; break;
                case 3:w = CIF_WIDTH; h = CIF_HEIGHT; break;
                case 4:w = CIF4_WIDTH;h = CIF4_HEIGHT; break;
                case 5:w = 2*CIF4_WIDTH;h = 2*CIF4_HEIGHT;break;
                case 0:
                default:
                        fprintf(stderr,"illegal sourceformat %d!\n",srcformat_);
			assert(0);
                        break;
		}
		// resize 
		if (w!=pl->w) {
			u_char *p = slot_[seqno & B_SLOTMASK].bp;
			long firstlong = (p[0]<<24)+(p[1]<<16)+(p[2]<<8)+p[3];

			if ((firstlong & 0xfffffe00) != 0x00008000) {
				slot_[seqno & B_SLOTMASK].cc = 0;
				return;
			}
			// clear all slots.
			for (i=0;i<B_SLOTS;i++)
				slot_[i].cc = 0;

			if (pl->u.h263)
				DisinitH263Decoder(pl->u.h263);
			else
				pl->u.h263 = NewH263Decoder();
			if (!layernr) resize(w,h);
			pl->w = w;
			pl->h = h;
			pl->u.h263->source_format = h263rh->srcformat;
			InitH263Decoder(pl->u.h263);
		}
	} else { 
		switch (prh->srcformat) {
                case 1:w = SQCIF_WIDTH;h = SQCIF_HEIGHT; break;
                case 2:w = QCIF_WIDTH;h = QCIF_HEIGHT; break;
                case 3:w = CIF_WIDTH; h = CIF_HEIGHT; break;
                case 4:w = CIF4_WIDTH;h = CIF4_HEIGHT; break;
                case 5:w = 2*CIF4_WIDTH;h = 2*CIF4_HEIGHT;break;
                case 0:
                default:
                        fprintf(stderr,"illegal sourceformat %d!\n",srcformat_);
                        assert(0);
		}
		if (w!=pl->w) {
			if (pl->u.pyra)
				DisinitPyraDecoder(pl->u.pyra);
			else
				pl->u.pyra = NewPyraDecoder();
			pl->w = w;
			pl->h = h;
			if (!layernr) resize(w,h);

			//pl->u.pyra->PicSize = prh->srcformat;
			//InitPyraDecoder(pl->u.pyra);
		}
	}

	/* Wenn wir nen neuen timeref haben, fangen wir an, das alte
	 * bild zu dekodieren.
	 */

	if (currenttr == lasttr_) {// still in the same frame
		return;
	}
	slot_[seqno&B_SLOTMASK].cc = 0; //disable for decoding...
	lastlayer	= -1;
	for (i=maxlayers_-1;i>=0;i--) {
		int	layerpresent = 0;
		pl = pl_+i;

		if (!pl->u.pyra) {
			continue;
		}
		pl->layeruncoded++;
		// don't call this for H.263 in any case
		if (i<maxlayers_-1)
			if (!InitLayerReferences(i,lastlayer))
				continue;
		if (pl_[i].layertype==LAYERTYPE_H263) {
			int	cc,targetcc;
			u_char	*targetbp;

			assert(i==maxlayers_-1);
			while (reassemble_h263_gobs(i,&targetbp,&targetcc,lasttr_)) {
				u_char	*next;

				next = targetbp;
				layerpresent = 1;
				presentmask |= (1<<i);
				/* Wenn wir die sync verloren haben, brauchen
				 * wir wieder einen GOB 0 oder der Decoder ist
				 * total irritiert und crashed
				 */
				if (pl->u.h263->first) {
					long firstlong = (next[0]<<24)+(next[1]<<16)+(next[2]<<8)+next[3];
					if ((firstlong&0xfffffc00)!=0x00008000)
						continue;
				}
				HandleH263DataJunk(pl->u.h263,&next,targetbp+targetcc,1);
			}
		} else {  // PYRA
			int	cc,targetcc,j;
			u_char	*targetbp;
			struct pyralayerrtpheader	xprh;

			assert(i!=maxlayers_-1);
			int	decgobs[100];

			while (reassemble_pyra_gobs(i,&targetbp,&targetcc,lasttr_,&xprh)) {
				int	disp,tempref;
				u_char	*next;
				u_int	firstlong;

				layerpresent = 1;
				presentmask |= (1<<i);
				next = targetbp;
				assert (!next[0] && !next[1]);
				if (pl->u.pyra->first) {
					firstlong = (next[0]<<24)+(next[1]<<16)+(next[2]<<8)+next[3];
					if ((firstlong & 0xfffffff8) != 0x00000100) {
						continue;
					}
				}

				if (!i && (GOBS_PER_PYRAFRAME(pl->u.pyra)<19)) {
					for (j=0;j<GOBS_PER_PYRAFRAME(pl->u.pyra);j++)
						decgobs[j] = pl->u.pyra->decGOBs[j];
					tempref = pl->u.pyra->temp_ref;
				}
				pl->u.pyra->awaitIntra = 0;
				pl->u.pyra->skip_until_next_tr = 0;
				pl->u.pyra->baseLayerFlag = xprh.isbaselayer;
				if (!xprh.isbaselayer && !havebase) {
					layerpresent = 0;
					break;
				}
				while (next<targetbp+targetcc)
					disp=HandlePyraDataJunk(pl->u.pyra,&next,targetbp+targetcc,1);
				if (!i && !pl->u.pyra->first && (GOBS_PER_PYRAFRAME(pl->u.pyra)<19)) {
					if (tempref!=pl->u.pyra->temp_ref)
						for (j=0;j<GOBS_PER_PYRAFRAME(pl->u.pyra);j++) decgobs[j]=0;

					for (j=0;j<GOBS_PER_PYRAFRAME(pl->u.pyra);j++) {
						if (decgobs[j]!=pl->u.pyra->decGOBs[j])
							memset(rvts_+(j*X16LINES_PER_GOB(pl->u.pyra)*16*pl->w)/64, now_^0x80, 16*X16LINES_PER_GOB(pl->u.pyra)*pl->w/64);
						decgobs[j] = pl->u.pyra->decGOBs[j];
					}
				}
			}
		}
		if (layerpresent) {
			lastlayer	= i;
			havebase	= 1;
		}
	}
	for (i=maxlayers_;i--;)
		if (presentmask & (1<<i))
			pl_[i].layeruncoded = 0;
	slot_[seqno&B_SLOTMASK].cc = cc-offset; //enable again
	lasttr_ = currenttr;

	memset(rvts_, now_^0x80, pl_[0].h*pl_[0].w/64);
	if (pl_[0].u.pyra && pl_[0].u.pyra->DecPic) {
		pyraframe_ = pl_[0].u.pyra->DecPic->y;
		render_frame(pyraframe_);
	}
	/*
	render_frame(pyraframe_);
	*/
}

void PyraDecoder::redraw() {
	if (pyraframe_)
		Decoder::redraw(pyraframe_);
}
