/*
 * (c) Marcus Meissner
 */

struct pyralayer {
	u_int	w,h;		/* groesse */
	int	layertype;	/* typ */
#define LAYERTYPE_H263  1
#define LAYERTYPE_PYRA  2
	int	layeruncoded;	/*frequency that layer is not available coded*/
	union {
		H263Global	*h263;
		PyraGlobal	*pyra;
	} u;
};

class PyraDecoder : public Decoder {
public:
	PyraDecoder();
	~PyraDecoder();
	int colorhist(u_int* hist) const;
	virtual void recv(const rtphdr* rh, const u_char* bp, int cc);
	virtual void info(char* wrk) const;
	void stats(char* wrk);

protected:
	virtual void redraw();
	int InitLayerReferences(int nl, int lastDecLayer);
	int reassemble_h263_gobs(int layernr,u_char **newbp,int *newcc,int tr);
	int reassemble_pyra_gobs(int layernr,u_char **newbp,int *newcc,int tr,struct pyralayerrtpheader *xprh);
	int guess_layertype(u_char *bp,unsigned short seqno);

	/*
	 * Reassembly buffer 'slots' for resequencing & reassembling
	 * gobs split across packet boundaries.
	 */
#define B_SLOTS	256
#define B_SLOTMASK	(B_SLOTS - 1)
	int	h263streamsize_;	/* max streamsize */
	u_char	*h263stream_;		/* h263stream */

	struct slot {
		u_short 	seqno;
		u_int		rtflags;
		u_int		cc;
		u_char* 	bp;
		u_char		layernr;
		int		layertype;
		u_int		tr;
		union {
			u_char			pad[32];
			pyralayerrtpheader	prh;
			h263rtpheader_A		h263a;
			h263rtpheader_B		h263b;
		} header;
	} slot_[B_SLOTS];

	u_char	*frame_;
	u_int	inw_,inh_;
	u_int	srcformat_;
	u_int	lastknowngood_;

	H263Global *h263decoder;

	struct pyralayer *pl_;
	int	lasttr_,maxlayers_;
};

static class PyraDecoderMatcher : public Matcher {
public:
	PyraDecoderMatcher() : Matcher("decoder") {}
	TclObject* match(const char* id) {
		if (strcasecmp(id, "pyra") == 0)
			return (new PyraDecoder());
		else
			return (0);
	}
} dm_h263;
