/* Pyramid Encoder
 * Copyright 1998 Marcus Meissner
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /src/multimedia/LOCAL/vic/vic-Marcus/RCS/encoder-pyra.cc,v 1.19 1998/08/19 12:46:07 msmeissn Exp msmeissn $ (LBL)";
#endif

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <sys/time.h>

#include "bsd-endian.h"
#include "transmitter.h"
#include "module.h"
#include "crdef.h"
#include "p64/p64-huff.h"
 
extern "C" {
#include "NTCODEC/include/pyra/encoder/main.h"
#include "NTCODEC/include/h263decoder.h"
#include "NTCODEC/include/bitOut.h"
};

#include "h263.h"
#include "pyra.h"

#include "encoder-pyra.h"


PyraEncoder::PyraEncoder() : TransmitterModule(FT_YUV_CIF)
{
	int	i;

	lastw_ = 0;lasth_ = 0;
	/* ausreichend platz hierfuer allozieren ..*/
	mbind_ = (int*)malloc(4*397*4*sizeof(int));
	mbquant_ = (int*)malloc(4*397*4*sizeof(int));

	/* Wir muessen leider einen riesigen Buffer preallozieren, da
	 * beide Encoder keine Obergrenzenchecks fuer den Bitbuffer haben
	 */
	maxrate_ = 1000000;
	bitstr_.b = new Byte[maxrate_*10/8];
	bitstr_.size = maxrate_*10;
	bitstr_.ind = 0;
	bitstr_.actualSize = 0;
	bitstr_.fp = NULL;

	maycheck_ = 0;

	maxlayers_ = 3;		// FIXME: -> Tcl

	pl_ = new pyralayer[maxlayers_];
	for (i=0;i<maxlayers_;i++) {
		pl_[i].temppredpict.y	= new Byte[1];
		pl_[i].spatpredpict.y	= new Byte[1];
		pl_[i].decpict.y	= new Byte[1];
		pl_[i].origpict.y	= new Byte[1];
		pl_[i].oldorigpict.y	= new Byte[1];
		pl_[i].interpol		= (Byte**)malloc(sizeof(Byte*)*3);
		pl_[i].q		= 10;
		pl_[i].enctype		= PICTURE_CODING_TYPE_INTRA;
		pl_[i].scaltype		= 0;/*hmm;*/
		pl_[i].codingtime	= 3;
		pl_[i].prevenctype	= -1;
		pl_[i].gfid		= -1;
		pl_[i].freq		= 1;
		pl_[i].curcnt		= 0;

		pl_[i].mvfieldin.mx	= new short[1];
		pl_[i].mvfieldin.my	= new short[1];
		pl_[i].mvfieldin.mode	= new short[1];

		pl_[i].mvfieldout.mx	= new short[1];
		pl_[i].mvfieldout.my	= new short[1];
		pl_[i].mvfieldout.mode	= new short[1];
	}
	// FIXME: -> Tcl
	pl_[0].size = 1;
	pl_[1].size = 1;
	pl_[2].size = 2;

	// FIXME: -> Tcl
	pl_[0].q = 3;
	pl_[1].q = 5;
	pl_[2].q = 10;

	// FIXME: -> Tcl
	pl_[0].freq = 1;
	//pl_[1].freq = 2;
	//pl_[2].freq = 4;

	InitFilters(1024,1024);
	InitBlockPyra();
	InitExtVectTables();
	InitHuffTables();
	InitLatticeQuantizer();
}

PyraEncoder::~PyraEncoder()
{
	if (tx_ != 0)
		tx_->flush();
	/* FIXME: free all the stuff allocated in pl_ */
	delete[] bitstr_.b;
	delete[] pl_;
}

/* Die Schnittstelle, ueber die der Tcl Code bei uns parameter usw.
 * setzen kann
 */
int
PyraEncoder::command(int argc,const char* const *argv)
{
	if (argc==3) {
		if (!strcasecmp(argv[1],"q")) {
			// FIXME: not yet
			return 0;
		}
	}
	return TransmitterModule::command(argc,argv);
}

/* kleine Hilfsfunktion zum vertauschen zweier Pictures */
static void inline _swap_pictures(Picture*a,Picture*b) {
	unsigned char *tmp;

	tmp = a->y;a->y=b->y;b->y=tmp;
	tmp = a->u;a->u=b->u;b->u=tmp;
	tmp = a->v;a->v=b->v;b->v=tmp;
}

/* kleine Hilfsfunktion, die aus einem Bitstrom Teilstuecke ausschneiden kann */
static u_int getbits(u_char *bs,u_int bitstart,u_int nrofbits) {
	int	byte = bitstart>>3;
	unsigned long	xx,mask;
	
	// get whole long
	xx = (bs[byte]<<24)|(bs[byte+1]<<16)|(bs[byte+2]<<8)|(bs[byte+3]);

	// mask out upper bits
	static const unsigned long masks[33] = {
		0x00000000,
		0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
		0xf8000000, 0xfc000000, 0xfe000000, 0xff000000, 
		0xff800000, 0xffc00000, 0xffe00000, 0xfff00000,
		0xfff80000, 0xfffc0000, 0xfffe0000, 0xffff0000,
		0xffff8000, 0xffffc000, 0xffffe000, 0xfffff000, 
		0xfffff800, 0xfffffc00, 0xfffffe00, 0xffffff00,
		0xffffff80, 0xffffffc0, 0xffffffe0, 0xfffffff0,
		0xfffffff8, 0xfffffffc, 0xfffffffe, 0xffffffff,
	};
	mask = masks[nrofbits] >> (bitstart & 7);

	return  (xx & mask) >> (32-nrofbits-(bitstart&7));
}

/* Funktion, die den Pyramiden Datenstrom in RTP Pakete splittet und sendet 
 * Liefert die Anzahl der aktuell gesendeten Bytes zurueck.
 */
static int PyraEncoder::split_and_send_pyrastream(
	const int layernr,	/* [in] nummer des aktuellen layers */
	u_char *bs,		/* [in] bitstream */
	u_int bitcount,		/* [in] Anzahl an bits in diesem */
	u_int gobs_per_frame,	/* [in] gobs per frame */
	u_int mbs_per_gob,	/* [in] macrobloecke per gob */
	u_int32_t ts_,		/* [in] timestamp (vom VIC) */
	u_int lmask		/* [in] aktuelle layermask */
) {
	pyralayer 		*pl=pl_+layernr;	/* aktueller layer */
	pyralayerrtpheader	*prh;
	PYRAstreamheader	psh;
	Transmitter::pktbuf*	pb;
	rtphdr*			rh;
	int			i,j,sendmodeb,plen,lastgobind,lastsentbit,curind;
	int			curbit,sentbytes=0,lastind;
							// 8 ist Max headersize
	int			psize=tx_->mtu()-sizeof(rtphdr)-sizeof(pyralayerrtpheader);

	lastsentbit=0;curind=0;sendmodeb=0;curbit=0;

	/* Irgendwie kann man nicht psh = (pyrastreamheader*)bs machen...*/
	psh.syncword	= getbits(bs,curbit,24);curbit+=24;
	psh.gobnr	= getbits(bs,curbit,5);curbit+=5;
	psh.tr		= getbits(bs,curbit,8);curbit+=8;
	psh.srcformat	= getbits(bs,curbit,3);curbit+=3;
	psh.picture_coding_type = getbits(bs,curbit,1);curbit++;
	psh.scaltype	= getbits(bs,curbit,2);curbit+=2;
	psh.q		= getbits(bs,curbit,5);curbit+=5;

	while (lastsentbit<bitcount) {
		/* Letzten GOB bitindex suchen, der gerade noch so in einen
		 * block passt
		 */
		lastgobind = 0;
		for (i=0;(i<=gobs_per_frame) && (mbind_[i*mbs_per_gob]<lastsentbit-8+(psize<<3));i++)
			lastgobind = mbind_[i*mbs_per_gob];
		if (lastgobind<=lastsentbit) {
			/* nichts gefunden? */
			lastgobind = 0;
		}
		/* Wenn der letzte Block ein Mode B Block (ohne GOB Ende) war, 
		 * oder der naechste GOB nicht in ein RTP Paket passt, muessen
		 * wir einen Mode B Block senden
		 */
		if (sendmodeb || !lastgobind) {
			/* nochmal den naechsten GOB suchen, der passt */
			for (i=0;(i<=gobs_per_frame) && (mbind_[i*mbs_per_gob]<lastsentbit-8+(psize<<3));i++)
				lastgobind = mbind_[i*mbs_per_gob];
			if (sendmodeb) {
				/* nachsehen, ob wir fuer diesen Mode B block
				 * an einem GOB Ende aufhoeren koennen, oder
				 * ob wir noch ein Mode B Block brauchen
				 */
				lastgobind = -1;
				for (i=0;(i<=gobs_per_frame) && (mbind_[i*mbs_per_gob]<lastsentbit-8+(psize<<3));i++)
					lastgobind = mbind_[i*mbs_per_gob];

				if (lastgobind>lastsentbit) {
					/* wir haben ein GOB Ende,
					 * der naechste Block kann wieder ein
					 * Mode A Block werden
					 */
					lastind = -100000;
					sendmodeb = 0;
				} else {
					/* wir haben kein GOB Ende ->
					 * Wir sehen nach, bis zu welchem
					 * Macroblock wir splitten koennen
					 */
					lastgobind = -1;
					for (i=lastind;(i<=mbs_per_gob*gobs_per_frame) && (mbind_[i]<lastsentbit-8+(psize<<3));i++)
						lastgobind = mbind_[i];
					/* es _MUSS_ einer zu finden sein */
					assert(lastgobind>lastsentbit);
					sendmodeb = 1;
					lastind = i;
				}
			} else {
				/* nein, wir muessen einen Macroblock, der noch
				 * gerade so reinpasst, suchen 
				 */
				lastgobind = -1;
				for (i=0;(i<=mbs_per_gob*gobs_per_frame) && (mbind_[i]<lastsentbit-8+(psize<<3));i++)
					lastgobind = mbind_[i];
				/* es _MUSS_ einer zu finden sein */
				assert(lastgobind>lastsentbit);
				lastind = i;
				sendmodeb = 1;
			}
			
			/* ein RTP Paket vom VIC RTP layer allozieren */
			pb = tx_->alloc(ts_, RTP_PT_PYRA);
			/* in Block 1 (iov[0]) kommt der RTP header */
			pb->iov[0].iov_len=sizeof(rtphdr);
			rh = (rtphdr*)pb->iov[0].iov_base;

			/* An den Anfang von Block 2 (iov[1]) der Extra Header,
			 * und danach die Daten
			 */
			prh = (pyralayerrtpheader*)(pb->iov[1].iov_base);
			prh->layernr 			= layernr;
			prh->maxlayers 			= maxlayers_-1;
			prh->isbaselayer		= 0;
			/* nachschauen, welcher denn nun baselayer ist,
			 * und falls wir es sind, flag setzen 
			 */
			for (j=32;j--;) {
				if ((1<<j) & lmask) {
					if (j==layernr)
						prh->isbaselayer = 1;
					break;
				}
			}
			/* spatial distance berechnen aus der mask */
			for (j=layernr;j--;)
				if ((1<<j) & lmask)
					break;
			if (j==-1)
				prh->spatialdist = 0;
			else
				prh->spatialdist = layernr-j;
			/* temporal distance ... */
			prh->tempdist	= pl->freq;
			prh->modeb	= 1;
			prh->srcformat	= psh.srcformat;
			/* war der vorherige block ein Mode B Block? */

			/* Bit Magic */
			prh->sbit	= lastsentbit&7;
			prh->ebit	= 7-((lastgobind-1) &7);
			plen = ((lastgobind+7)>>3)-(lastsentbit>>3);
			/* einige sachen, die nicht passieren sollten */
			assert(plen>0);
			if(plen>psize) {
				fprintf(stderr,"argh, plen %d>psize %d, (lastgobind %d, lastsentbit %d)\n",
					plen,psize,lastgobind,lastsentbit
				);
				assert(0);
			}
			/* Daten hinter den Extraheader kopieren, Laenge
			 * anpassen 
			 */
			memcpy(pb->iov[1].iov_base+sizeof(pyralayerrtpheader),bs+(lastsentbit>>3),plen);
			pb->iov[1].iov_len = sizeof(pyralayerrtpheader)+plen;

			assert(lastsentbit!=lastgobind);
			lastsentbit 		= lastgobind;
			sentbytes		+= sizeof(rtphdr)+sizeof(pyralayerrtpheader)+plen;
			if (lastgobind == bitcount)
				rh->rh_flags |= htons(RTP_M);
			tx_->send(pb);/* und weg */
		} else {
			/* mindestens ein GOB vollstaendig, also Mode A */
			pb = tx_->alloc(ts_, RTP_PT_PYRA);
			pb->iov[0].iov_len = sizeof(rtphdr);
			rh = (rtphdr*)pb->iov[0].iov_base;
			prh = (pyralayerrtpheader*)(pb->iov[1].iov_base);
			prh->layernr 	= layernr;
			prh->maxlayers 	= maxlayers_-1;
			prh->isbaselayer= 0;
			/* sind wir baselayer? */
			for (j=32;j--;) {
				if ((1<<j) & lmask) {
					if (j==layernr)
						prh->isbaselayer = 1;
					break;
				}
			}
			/* spatial distance */
			for (j=layernr;j--;)
				if ((1<<j) & lmask)
					break;
			if (j==-1)
				prh->spatialdist = 0;
			else
				prh->spatialdist = layernr-j;
			/* temporal distance */
			prh->tempdist	= pl->freq;
			prh->modeb	= 0;
			prh->srcformat	= psh.srcformat;
			assert(psh.srcformat);
			/* bitmagic */
			prh->sbit		= lastsentbit&7;
			prh->ebit		= 7-((lastgobind-1) &7);
			plen = ((lastgobind+7)>>3)-(lastsentbit>>3);
			assert(plen>0);
			assert(lastgobind>lastsentbit);
			assert(plen<=psize);
			memcpy(pb->iov[1].iov_base+sizeof(pyralayerrtpheader),bs+(lastsentbit>>3),plen);
			pb->iov[1].iov_len = sizeof(pyralayerrtpheader)+plen;
			lastsentbit		= lastgobind;
			sentbytes		+= sizeof(rtphdr)+sizeof(pyralayerrtpheader)+plen;
			if (bitcount <= lastgobind)
				rh->rh_flags |= htons(RTP_M);
			tx_->send(pb);
			sendmodeb = 0;
		}
	}
	return sentbytes;
}

/* Hilfsfunktion zum allozieren von Pictures */
static inline void _alloc_picture(Picture *pic,int w,int h) {
	if (pic->y) delete[] pic->y;

	pic->y = new Byte[w*h*3/2];
	pic->u = pic->y+w*h;
	pic->v = pic->u+w*h/4;
	pic->ws = pic->w = w;
	pic->hs = pic->h = h;
	memset(pic->y,0,w*h*3/2);
}

extern "C" {
int split_h263stream(
        u_char *bs,                     /* bitstream [in] */
        u_int bitcount,                 /* bitstream length in bits [in] */
        u_int gobs_per_frame,           /* gobs per frame [in] */
        u_int mbs_per_gob,              /* mbs per gob [in] */
        int *mbind,                     /* macroblock indices [in] */
        int *mbquant,                   /* quantifiers [in] */
        MVField mvfield,                /* motion vectors [in] */
        u_int ts_,                      /* timestamp [in] */
        int headersize,                 /* headerlength [in] */
        h263_rtp_packet **packets       /* rtp packets [out] */
);
};

/***********************************************************************
 * PyraEncoder::consume()
 *
 * Die Hauptencoderfunktion
 * Bekommt von der VIC Grabberschicht einen VideoFrame als Input,
 * encodet ihn in H.263/Pyramid, splittet die resultierende Datenstroeme
 * in RTP Packete (observing RFC 2190 und den Pyrasplitstandard) und sendet
 * sie mit der VIC Transportschicht.
 */
int PyraEncoder::consume(const VideoFrame* vf)
{
	YuvFrame*	yuv = (YuvFrame*)vf;
	u_int		lmask,xfps,xbps,i,j,sentbytes=0;
	u_int		bps = 10000;
	int		isbaselayer,mbs_per_gob,gobs_per_frame;
	int		lastcodedlayer,timespent,w,h;
	Tcl&		tcl = Tcl::instance();
	Transmitter::pktbuf* pb;
	rtphdr*		rh;
	h263streamheader	*h263sh;
	struct timeval	tv1,tv2;
	Picture		pict;
	pyralayer	*lastpl;
	
	w = yuv->width_;
	h = yuv->height_;
	/* groesse hat sich geaendert -> Layer Daten anpassen */
	if (w!=lastw_ || h!=lasth_) {
		int		xw,xh;

		xw = w;xh = h;
		for (i=0;i<maxlayers_;i++) {
			pyralayer	*pl = pl_+i;

			if (i>0) {
				xh = xh/(pl->size/pl_[i-1].size);
				xw = xw/(pl->size/pl_[i-1].size);
			}
			pl->height = xh;
			pl->width = xw;
			delete[] pl->mvfieldin.mx;
			delete[] pl->mvfieldin.my;
			delete[] pl->mvfieldin.mode;

			_alloc_picture(&(pl->spatpredpict),xw,xh);
			_alloc_picture(&(pl->temppredpict),xw,xh);
			_alloc_picture(&(pl->origpict)    ,xw,xh);
			_alloc_picture(&(pl->oldorigpict) ,xw,xh);
			_alloc_picture(&(pl->decpict)     ,xw,xh);

			pl->mvfieldin.mx=new short[xw/16*xh/16];
			pl->mvfieldin.my=new short[xw/16*xh/16];
			pl->mvfieldin.mode=new short[xw/16*h/16];
			memset(pl->mvfieldin.mx,0,sizeof(short)*xw*xh/256);
			memset(pl->mvfieldin.my,0,sizeof(short)*xw*xh/256);
			memset(pl->mvfieldin.mode,0,sizeof(short)*xw*xh/256);
			pl->mvfieldin.w = xw/16;
			pl->mvfieldin.h = xh/16;

			pl->mvfieldout.mx=new short[xw/16*xh/16];
			pl->mvfieldout.my=new short[xw/16*xh/16];
			pl->mvfieldout.mode = new short[xw/16*xh/16];
			memset(pl->mvfieldout.mx,0,sizeof(short)*xw*xh/256);
			memset(pl->mvfieldout.my,0,sizeof(short)*xw*xh/256);
			memset(pl->mvfieldout.mode,0,sizeof(short)*xw*xh/256);
			pl->mvfieldout.w = xw/16;
			pl->mvfieldout.h = xh/16;

			pl->interpol[0] = (Byte*)malloc(sizeof(Byte)*xw*xh);
			pl->interpol[1] = (Byte*)malloc(sizeof(Byte)*xw*xh);
			pl->interpol[2] = (Byte*)malloc(sizeof(Byte)*xw*xh);

			pl->enctype	= PICTURE_CODING_TYPE_INTRA;

			pl->curcnt	= pl->freq;
			pl->intracnt	= 0;
		}
		lastw_ = w;
		lasth_ = h;
	}
	/* Derzeit eingestellte bps/fps Raten auslesen */
	tcl.evalc("$fps_slider get");sscanf(tcl.result(),"%d",&xfps);
	tcl.evalc("$bps_slider get");sscanf(tcl.result(),"%d",&xbps);
	bps = xbps*1024/xfps;

	pict.w = w;
	pict.h = h;
	pict.y = (Byte*)yuv->bp_;
	pict.u = (Byte*)yuv->bp_+w*h;
	pict.v = (Byte*)yuv->bp_+w*h+(w*h)/4;

	bitstr_.ind = 0;

	gettimeofday(&tv1,NULL);

	/* Original bild an die eingestellte Groesse anpassen */
	if (pl_[0].size==1)
		CopyPicture(&pict,&(pl_[0].origpict));
	else
		DownsamplePicture(&pict,&(pl_[0].origpict));
	/* ... fuer jeden Layer ... */
	for (i=1;i<maxlayers_;i++) {
		pyralayer *pl = pl_+i;
		if (pl->size==pl_[i-1].size)
			CopyPicture(&(pl_[i-1].origpict),&(pl->origpict));
		else
			DownsamplePicture(&(pl_[i-1].origpict),&(pl->origpict));
	}

	/* Welche layer kodieren wir in diesem Durchlauf ... */
	lmask = 0;
	for (i=maxlayers_;i--;)
		if (pl_[i].curcnt+1>=pl_[i].freq)
			lmask|=1<<i;

	/* Und LOS */
	lastcodedlayer = 0;lastpl = NULL;
	isbaselayer = 1;
	for (i=maxlayers_;i--;) {
		pyralayer	*pl = pl_+i;

		if (pl->prevenctype!=pl->enctype)
			pl->gfid++;
		pl->prevenctype = pl->enctype;

		//FIXME: braucht auch die Konstante fuer >CIF */
		mbs_per_gob	= pl->width/16;
		gobs_per_frame	= pl->height/16;
		switch (pl->width) {
		case CIF16:
			mbs_per_gob>>=2;
			break;
		case CIF4:
			mbs_per_gob>>=1;
			break;
		default:break;
		}

		/* Wird dieser Layer kodiert? */
		pl->curcnt++;
		if (pl->curcnt < pl->freq)
			continue;
		pl->curcnt=0;

		/* Intracount nur wenn wir nicht den Baselayer verwenden 
		 * und nicht bei H.263.
		 */
		pl->intracnt++;
		if ((i!=maxlayers_-1) && !isbaselayer && (pl->intracnt>10)) {
			pl->enctype = PICTURE_CODING_TYPE_INTRA;
			pl->intracnt = 0;
		}
		/* Wenn wir nicht der Baselayer sind, verwenden die 
		 * drunterliegenden MV Fields und machen spatial prediction
		 */
		if (!isbaselayer) {
			if (pl->enctype==PICTURE_CODING_TYPE_INTER) {
				/* Upsampling of reconstructed image */
				SampleUpMVField(
					lastpl->mvfieldout,lastpl->freq,
					pl->mvfieldin,pl->freq
				);
			}
			if (pl->size == lastpl->size) {
				CopyPicture(
					&(lastpl->decpict),
					&(pl->spatpredpict)
				);
			} else if (2*pl->size==lastpl->size){
				InterpolateFastPictureSub(
					&(lastpl->decpict),
					&(pl->spatpredpict)
				);
			} else {
				fprintf(stderr, "main: Can't deal with the sizes %d and %d of layer %d and %d.", pl->size,lastpl->size,i,lastcodedlayer);
				exit(1);
			}
		}

		/* temporal pictures und letztes decoded picture vertauschen*/
		_swap_pictures(&(pl->temppredpict),&(pl->decpict));
		if (i==maxlayers_-1) {
			/* H.263 */

			int		nrofpackets;
			h263_rtp_packet	*packets;

			bitstr_.ind = 0;
			if (pl->origpict.w>352)
				fprintf(stderr,"unsupported h263 width %d\n",pl->origpict.w);
			EncodeH263Q(
				pl->q,			/* [in] Quantisierer */
				pl->codingtime,		/* [in] Encodingtime */
				pl->enctype,		/* [in] Encodingtype */
				vf->ts_,		/* [in] timestamp */
				5,			/* [in] Prozent Intra */
				&(pl->origpict),	/* [in] Originalbild */
				&(pl->oldorigpict),	/* [in] altes Originalbild */
				&(pl->temppredpict),	/* [in] temp. Bild */
				(unsigned char*)yuv->crvec_,/* [in]
							 * conditional replenish
							 * ment vom VIC 
							 */
				&(pl->decpict),		/* [out] decoded Bild */
				&bitstr_,		/* [out] Bitstream */
				mbind_,			/* [out] MB indizes */
				mbquant_,		/* [out] MB quantisierer */
				&(pl->mvfieldout)	/* [out] MV Field */
			);
			mbind_[mbs_per_gob*gobs_per_frame]=bitstr_.ind;
			/* und splitten, siehe h263rtp.c */
			nrofpackets=split_h263stream(
				bitstr_.b,
				bitstr_.ind,
				gobs_per_frame,
				mbs_per_gob,
				mbind_,
				mbquant_,
				pl->mvfieldout,
				yuv->ts_,
				tx_->mtu(),
				&packets
			);
			/* und senden */
			for (j=0;j<nrofpackets;j++) {
				Transmitter::pktbuf *pb = tx_->alloc(yuv->ts_,RTP_PT_PYRA);
				rtphdr *rh = (rtphdr*)pb->iov[0].iov_base;

				pb->iov[0].iov_len = sizeof(rtphdr);
				memcpy(pb->iov[1].iov_base,&(packets[j].header.h263a),packets[j].headersize);
				memcpy(pb->iov[1].iov_base+packets[j].headersize,packets[j].data,packets[j].datasize);
				pb->iov[1].iov_len = packets[j].datasize+packets[j].headersize;
				if (j==nrofpackets-1) // Endemarkierung
					rh->rh_flags |= htons(RTP_M);
				sentbytes+=packets[j].headersize+packets[j].datasize+sizeof(rtphdr);
				tx_->send(pb);
			}
			/* Flushen und Pakete deallozieren */
			tx_->flush();
			free(packets);
		} else {
			if (pl->enctype==PICTURE_CODING_TYPE_INTER)
				InitHalfPelInterpolation(&(pl->temppredpict),(pl->interpol));
			bitstr_.ind = 0;
			for (int k=0;k<4*397*4;k++)
				mbind_[k]=0xdeadbeef;
			CodePyraLayerQ(
				NULL,
				&(pl->origpict),	/* [in] original Bild */
				&(pl->oldorigpict),	/* [in] altes orig.B. */
				&(pl->spatpredpict),	/* [in] spatialpred B.*/
				&(pl->temppredpict),	/* [in] temppred. B. */
				pl->interpol,		/* [in] Interpolation*/
				pl->mvfieldin,		/* [in] spat. MV Field*/
				pl->q,			/* [in] Quantisierer*/
				pl->enctype,		/* [in] Encodingtype*/
				pl->scaltype,		/* [in] Scaletype */
				pl->gfid,		/* [in] gfid */
				vf->ts_,		/* [in] timestamp */
				&bitstr_,		/* [out] bitstream */
				&(pl->decpict),		/* [out] decoded Bild*/
				pl->mvfieldout,		/* [out] MV field out*/
				mbind_,			/* [out] MB Indizes */
				isbaselayer,		/* [in] Baselayer */
				pl->codingtime		/* [in] Codingtime */
			);
			mbind_[mbs_per_gob*gobs_per_frame] = bitstr_.ind;
			/* splitten und senden */
			sentbytes+= split_and_send_pyrastream(i,bitstr_.b,bitstr_.ind,gobs_per_frame,mbs_per_gob,yuv->ts_,lmask);
		}
		memcpy(pl->oldorigpict.y,pl->origpict.y,pl->width*pl->height*3/2);
		pl->enctype = PICTURE_CODING_TYPE_INTER;
		lastcodedlayer = i;
		lastpl = pl_+i;
		isbaselayer = 0;
	}
	/* zeit brauchen wir evt. spaeter, jetzt nicht */
	gettimeofday(&tv2,NULL);
	timespent = (tv2.tv_sec-tv1.tv_sec)*1000000+(tv2.tv_usec-tv1.tv_usec);
	tx_->flush();
	return sentbytes;
}
