/*
 */

/* one single layer */
struct pyralayer {
	MVField	mvfieldin,mvfieldout;
	int	enctype,prevenctype,width,height,size,gfid,q,codingtime;
	int	curcnt,freq,scaltype;
	int	intracnt;
	Picture	spatpredpict,oldorigpict,origpict,decpict,temppredpict;
	Byte	**interpol;
};

class PyraEncoder : public TransmitterModule {
 public:
	PyraEncoder();
	~PyraEncoder();
	virtual int consume(const VideoFrame*);
	virtual int command(int argc,const char *const *argv);
	int split_and_send_pyrastream(int layernr,u_char *bs,u_int bitcount,u_int gobs_per_frame,u_int mbs_per_gob,u_int32_t ts_,u_int lmask);
 protected:
	Bitstr	bitstr_;
	int	*mbind_,*mbquant_;
	u_int	maxrate_,lastw_,lasth_,fpcount_;
	int	maxlayers_,maycheck_,enablecrvec_;
	struct pyralayer	*pl_;
};

static class PyraEncoderMatcher : public Matcher {
public:
	PyraEncoderMatcher() : Matcher("module") {}
	TclObject* match(const char* fmt) {
		//fprintf(stderr,"PyraEncoderMatcher::match(%s)\n",fmt);
		if (strcasecmp(fmt, "pyra") == 0)
			return (new PyraEncoder);
		return (0);
	}
} encoder_matcher_pyra;
