/*
 * All Copyright/warning texts deleted. I hate it scrolling until i came to editable code :)
 * Will be re-insert when ready
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /src/multimedia/LOCAL/vic/vic-Marcus/RCS/grabber-plx.cc,v 1.2 1998/08/19 12:46:07 msmeissn Exp msmeissn $ (LBL)";
#endif

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/param.h>

#ifdef USE_SHM
#include <sys/ipc.h>
#include <sys/shm.h>
#if !defined(__svr4__) && !defined(__hpux)
extern "C" {
#include <sys/shm.h>
int shmget(key_t, int, int);
char *shmat(int, char*, int);
int shmdt(char*);
int shmctl(int, int, struct shm_ds *);
}
#endif
#endif

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef USE_SHM
extern "C" {
#include <X11/extensions/XShm.h>
}
#endif

/*XXX*/
#ifdef __svr4__
extern "C" {
#include <XPlxExt.h>
}
#else
#include "plxfuncs.h"
#endif

#include "grabber.h"
#include "module.h"
#include "vw.h"
#include "Tcl.h"
#include "device-input.h"
#include "device-output.h"
#include "transmitter.h"
#include "rgb-converter.h"
#include "output-plx.h"

#define LOGO

#define LOGO_PERMANENT_not

#define Sr_DEBUG_not_now

// Xtr-Card from Parallax
// XXXX still not working on my local machine
// Problems is the Visualinfo on th 45z
#define XTRA_not
 
#ifdef Sr_DEBUG
#define DTEXT(x) fprintf(stderr, "grabber-plx: %s\n", x);
#else
#define DTEXT(x)
#endif


class PlxWindow : public BareWindow {
public:
	PlxWindow(const char* name, XVisualInfo* vinfo, const char* s, char* dsp=0, Tk_Window parent=0);
	virtual ~PlxWindow();
	void capture(u_int8_t* frm);
	void setsize(int w, int h);
	void specialsetsize(int w, int h);
	void resetsize(int d) ;

	void port(const char *s);
	// XXX
	inline const char* getPort() { return (port_ == PLX_INPUT_0)? "input-1": "input-2"; }
	inline void hue(int v) { hue_ = v; setctrl(); }
	inline void saturation(int v) { saturation_ = v; setctrl(); }
	inline void brightness(int v) { brightness_ = v; setctrl(); }
	inline void contrast(int v) { contrast_ = v; setctrl(); }

	void freeze_frame(sigset_t* ss);
	void release_frame(sigset_t* ss);
	virtual void redraw() { need_refresh_ = 1; }

	inline int basewidth() { return (format_width_); }
	inline int baseheight() { return (format_height_); }

	void setq(int q);
	inline GC gc() const { return (gc_); }
	void setInputStandard(const char* std);
protected:
	void doInit();
	GC gc_;
	int need_refresh_;
	u_int format_width_, format_height_, format_offset_;
	int hue_, saturation_, brightness_, contrast_;
	plx_IO* plxio_;
	int port_;
	int standard_;
	void setctrl();
	int noLiveVideo_;
};

class PlxGrabber : public Grabber {
protected:
	PlxGrabber();
	virtual ~PlxGrabber();
public:
	virtual int command(int argc, const char *const *argv);
	void init();
	void start();
	void PlxGrabber::fps(int v);
protected:
	int lookup_visual();
	virtual void setsize() = 0;
	int decimate_;
	PlxWindow* capwin_;
	XVisualInfo vinfo_;
	PlxOutputDevice* plxOutDev_;
	int logodrawn_;
	Pixmap lpm_;
	void initlogo();
	int createRemote();
#ifdef LOGO
	u_char* logo_;
	u_char* logomask_;
	int logolen_;
	int logomasklen_;
	void PmFromRas(char *file, char *filemask, Window win, GC wgc, int builtin_file_size, int builtin_filemask_size);
	XGCValues vals;
	void drawlogo();
	int lw_;
	int lh_;
	int lx_;
	int ly_;
#endif
	int halfsize_;
	Tk_Window remoteWin_;
	char *remoteDisp_;
	XVisualInfo remotevinfo_;
};

class Plx422Grabber : public PlxGrabber {
public:
	Plx422Grabber();
	~Plx422Grabber();
	virtual int grab();
	virtual void setsize();
protected:
	void capture();
	StandardVideoImage* image_;
	RGB_Converter* converter_;
};

class Plx411Grabber : public Plx422Grabber {
public:
	virtual void setsize();
};

class PlxCIFGrabber : public Plx422Grabber {
public:
	virtual void setsize();
};

class PlxJpegGrabber : public PlxGrabber {
public:
	PlxJpegGrabber();
	~PlxJpegGrabber();
	virtual int grab();
	virtual void setsize();
	virtual int command(int argc, const char *const *argv);
protected:
	int capture(u_int8_t* bp);
	int q_;
	XPlxCImage *cimage_;
};

static class PlxDevice : public InputDevice {
 public:
	PlxDevice(const char*);
	virtual int command(int argc, const char*const* argv);
	void setDevAttributes();
 protected:
 	int whichDevice_;
	plx_IO* plxio_;
} plx_device("parallax");

#define NO_PLX_DEVICE 1
#define SMALL_PLX_DEVICE 2
#define BIG_PLX_DEVICE 3
#define PLXDEVNAME "/dev/fbs/tvtwo0" // multiple devices would be nice,
								 // but neither Parallax nor we
								 // support it currently
void
PlxDevice::setDevAttributes()  {
	Tcl& tcl = Tcl::instance();
	// I used this way, to allow a kind of 'remote working'.
	// Therefore I need a window on the remote Display BEFOR
	// I analyse the card....

	if(access(PLXDEVNAME, F_OK) == -1) {
		whichDevice_= NO_PLX_DEVICE;
		attributes_ = "disabled";
		return;
	}

	tcl.evalc("option get . localPlxDisplay $V(class)");
	char *tmp = (char*)tcl.result();
	int remote =1;
	if(!strcmp(tmp, "") || strlen(tmp)<3)
	  remote=0;
	Tk_Window tk;
	if(remote) {
		tk = Tk_CreateWindow(tcl.interp(), Tk_MainWindow(tcl.interp()), ".foo", tmp);
	} else {
		// ok, we COULD use tk_
		tk = Tk_CreateWindow(tcl.interp(), Tk_MainWindow(tcl.interp()), ".foo", NULL);
	}
	Tk_MakeWindowExist(tk);
	//Tk_MapWindow(tk);
	if(!remote &&  ScreenCount(Tk_Display(tk))>1 ) {
		// popup-warning
		tcl.evalc("tk_dialog .warning Warning  {You seem to be running on multi-headed system with at least one Parallax-framegrabber. If you are starting vic in this situation on a screen which is not a parallax-device, then X will crash, and there's nothing we can do (complain with Parallax Inc.). To tell vic that you know which screen is served by the parallax device, use the following command line option: '-XlocalPlxDisplay=<plx-screen>'. To disable using the parallax-device for this vic press 'Disable' now.} \"\" 0  Disable Continue");
		char *tmp = (char*)tcl.result();
		if(tmp[0]=='0') {
			whichDevice_= NO_PLX_DEVICE;
			attributes_ = "disabled";
			return;
		}
	}
	plxio_ = XPlxQueryConfig(Tk_Display(tk), Tk_WindowId(tk), Tk_GetGC(tk, 0, 0));
	if (!plxio_ || plxio_->hardware != PLX_XVIDEO_24 || ! (plxio_->inputs)->channel ) {
		whichDevice_= NO_PLX_DEVICE;
		attributes_ = "disabled";
		// ok, it may be one. but the grabber currently just supports PLX_XVIDEO_24
	} else {
			// That damn docu says it's plx_inputs. But my debugger says no.
		plx_IO_list *inputs = plxio_->inputs;
		while(inputs->next_IO)
			inputs = inputs->next_IO;
		if(inputs->channel == PLX_INPUT_0) {
			whichDevice_ = SMALL_PLX_DEVICE;
			attributes_ = "\
				format { 422 411 jpeg } \
				size { small large cif } \
				port { Input-1 }";
		} else {
			// The max. is 2 channels, until now. 
			whichDevice_ = BIG_PLX_DEVICE;
			attributes_ = "\
				format { 422 411 jpeg } \
				size { small large cif } \
				port { Input-1 Input-2 Input-2_YC }";
		}
	}
	Tk_DestroyWindow(tk);
}
PlxDevice::PlxDevice(const char *s) : InputDevice(s) 
{
	whichDevice_=0;
}

int PlxDevice::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();
	if (argc == 3 && strcmp(argv[1], "open") == 0) {
		const char* fmt = argv[2];
		TclObject* o = 0;
		if (strcmp(fmt, "jpeg") == 0)
			o = new PlxJpegGrabber;
		else if (strcmp(fmt, "422") == 0)
			o = new Plx422Grabber;
		else if (strcmp(fmt, "411") == 0)
			o = new Plx411Grabber;
		else if (strcmp(fmt, "cif") == 0)
			o = new PlxCIFGrabber;
		if (o != 0)
			Tcl::instance().result(o->name());
		return (TCL_OK);
	} else if(argc==2) {
		if (strcmp(argv[1], "attributes") == 0) {
			if(!whichDevice_)
				setDevAttributes();
			tcl.result(attributes_);
			return (TCL_OK);
		}

	}
	return (InputDevice::command(argc, argv));
}

PlxWindow::PlxWindow(const char* name, XVisualInfo* vinfo, const char* s, char* dsp, Tk_Window parent)
	: BareWindow(name, vinfo, dsp, parent)

{
	gc_ = Tk_GetGC(tk_, 0, 0);
	
	/*
	 * query the server to get hardware/signal information.
	 */
	Tk_MakeWindowExist(tk_);

	plxio_ = XPlxQueryConfig(dpy_, Tk_WindowId(tk_), gc_);
	if (plxio_->hardware != PLX_XVIDEO_24)
		/* shouldn't happen. */
		abort();
	Tcl &tcl = Tcl::instance();
	setInputStandard(tcl.var("setPlxInput"));
	port(s);
	// Ok, set the scalebares right, just as the card thinks.
	XPlxVideoValueQuery(dpy_, Tk_WindowId(tk_), gc_,
		   &saturation_, &contrast_, &hue_, &brightness_);

	tcl.evalf("set parallaxHue %d", hue_);
	tcl.evalf("set parallaxSat %d", saturation_);
	tcl.evalf("set parallaxCon %d", contrast_);
	tcl.evalf("set parallaxBri %d", brightness_);
}

PlxWindow::~PlxWindow()
{
	Tk_FreeGC(dpy_, gc_);
}

/* XXX
 * This function is just to resize the capture-window without using the
 * format_*-variables. Perhaps I should have introduced new variables
 * to distinguish between incoming size of signal (format_* currently) and 
 * the size of the capture-window (format_* / decimate originally).
 * Currently the size of the capture-window is only stored in the grabber
 * (in?_, out?_), which is _not_ good. 
 */
void PlxWindow::specialsetsize(int sw, int sh) {
#ifdef Sr_DEBUG
	fprintf(stdout, "PlxWindow::specialsetsize(%d, %d)\n", sw, sh);
#endif /* Sr_DEBUG */
	sw -= sw%8;
	// Min/Max-Restrictions
	if(sw<48) {
		sw=48;
	} else if (sw>768) {
		sw=768;
	}
	sh = (sw *3)/4;
	sh -= sh%8;
#ifdef Sr_DEBUG
	fprintf(stdout, "PlxWindow::specialsetsize(%d, %d)\n", sw, sh);
#endif /* Sr_DEBUG */
	Tk_ResizeWindow(Tk_Parent(tkwin()), sw, sh);
	Tk_ResizeWindow(tkwin(), sw, sh);
	setsize(sw, sh);
}

void PlxWindow::setsize(int w, int h)
{
	BareWindow::setsize(w, h);
	Tcl &tcl = Tcl::instance();
	tcl.evalc("update idletasks");/*XXX*/
		// XXX
	tcl.evalc(".menu.parallax.f.lr.x.entry delete 0 end");
	tcl.evalf(".menu.parallax.f.lr.x.entry insert 0 %d", w);
	tcl.evalc(".menu.parallax.f.lr.y.entry delete 0 end");
	tcl.evalf(".menu.parallax.f.lr.y.entry insert 0 %d", h);
	if(Tk_NameToWindow(tcl.interp(), ".remotemenu", tcl.tkmain()) ) {
		tcl.evalc(".remotemenu.f.lr.x.entry delete 0 end");
		tcl.evalf(".remotemenu.f.lr.x.entry insert 0 %d", w);
		tcl.evalc(".remotemenu.f.lr.y.entry delete 0 end");
		tcl.evalf(".remotemenu.f.lr.y.entry insert 0 %d", h);
	}
	/* Start the video display */
	noLiveVideo_= atoi(tcl.var("stillButtonState"));
	if(noLiveVideo_)
		XPlxVideoSqueezeStill(dpy_, Tk_WindowId(tk_), gc_,
					 0, format_offset_, format_width_, format_height_,
					 0, 0, width_, height_);
	else
		XPlxVideoSqueezeLive(dpy_, Tk_WindowId(tk_), gc_,
					 0, format_offset_, format_width_, format_height_,
					 0, 0, width_, height_);
}

void PlxWindow::resetsize(int d) {
	Tk_ResizeWindow(tk_, format_width_/d, format_height_/d);
	Tk_ResizeWindow(Tk_Parent(tk_), format_width_/d, format_height_/d);
}

void PlxWindow::setInputStandard(const char* std) {
	standard_ = (strcmp(std, "PAL")==0) ? PLX_PAL: (strcmp(std, "NTSC")==0) ? PLX_NTSC: PLX_SECAM;
}

void PlxWindow::setctrl()
{
	if (tk_ != 0)
		XPlxVideoValueLoad(dpy_, Tk_WindowId(tk_), gc_,
				   saturation_, contrast_, hue_, brightness_);
}

void PlxWindow::port(const char* s)
{
	int whichSig;
	if (strcasecmp(s, "input-1") == 0) {
		port_ = PLX_INPUT_0;
		whichSig = PLX_COMP;
	} else if (strcasecmp(s, "input-2_YC") == 0) {
		port_ = PLX_INPUT_1;
		whichSig = PLX_YC; 
	} else { // Default
		port_ = PLX_INPUT_1;
		whichSig = PLX_COMP;
	}
	plx_IO_list *il;
	/* find a pointer to channel input */
	for (il = plxio_->inputs; il->channel != port_; il = il->next_IO)
		;

	plx_signal* sig = 0;
	plx_signal_list *sl;
	// XXX
	Window window = Tk_WindowId(tk_);

	for (sl = il->signal_list; sl != 0; sl = sl->next_signal) {
		/*
		 * do an input select
		 * we also know that all the XVideo hardware can do is PLX_RGB24
		 */
		// PLX_COMP is important if we use port_2. We should differ, I think
		
		if(standard_!=sl->signal->standard) continue;
	/*
	 * XXX This won't work if we have different signal types
	 * on the different ports.
	 * And Port-2 has: COMP, YC, ...
	 */
		XPlxVideoInputSelect(dpy_, window, gc_, port_,
				     standard_, whichSig, PLX_RGB24);

		/* now do a query video to find out if there is sync */
		sig = XPlxQueryVideo(dpy_, window, gc_);
		if (sig->sync_ok) {
#ifdef Sr_DEBUG
		fprintf(stdout, "Port: %s    Input-Standard: %s		Sync OK\n", s, (standard_==PLX_NTSC)? "NTSC":
			(standard_==PLX_PAL)? "PAL":"other");
#endif
			break;
		}
	}
	// XXX
	// Ok, it doesn't sound good, but I think we need another window afterwards....sigh
	//-SB
	if (sig == 0) {
		/*XXX don't exit!*/
		fprintf(stderr, "no video connected to %s\n", s);
		exit(1);
	}
	//port_ = port;
	/* maintain 4:3 aspect ratio */
	format_width_ = sig->w;
	format_height_ = (format_width_ * 3) / 4;
	format_offset_ = sig->h - format_height_ + 1;

	XPlxVideoTag(dpy_, window, gc_, PLX_VIDEO);
	XPlxVideoValueQuery(dpy_, window, gc_,
			    &saturation_, &contrast_, &hue_, &brightness_);
}

void PlxWindow::freeze_frame(sigset_t* ss)
{
	sigset_t fullset;
	sigfillset(&fullset);
	sigprocmask(SIG_SETMASK, &fullset, ss);
#if GRAB_SERVER
	XGrabServer(dpy_);
#endif
#ifdef notdef
	/*XXX need toplevel window */
	XRaiseWindow(dpy_, Tk_WindowId(tk_));
#endif
	if(noLiveVideo_)  {
		//XSync(dpy_, 0);
		XPlxVideoSqueezeStill(dpy_, Tk_WindowId(tk_), gc_,
					 0, format_offset_,
					 format_width_, format_height_,
					 0, 0, width_, height_);
	} else
	if (need_refresh_) {
		XPlxVideoTag(dpy_, Tk_WindowId(tk_), gc_, PLX_VIDEO);
		// XXX
		if(noLiveVideo_)  {
			XSync(dpy_, 0);
			XPlxVideoSqueezeStill(dpy_, Tk_WindowId(tk_), gc_,
						 0, format_offset_,
						 format_width_, format_height_,
						 0, 0, width_, height_);
		} else  {
			XPlxVideoSqueezeLive(dpy_, Tk_WindowId(tk_), gc_,
						 0, format_offset_,
						 format_width_, format_height_,
						 0, 0, width_, height_);
		}
	}
#ifdef notdef
	XSync(dpy_, 0);
	XPlxVideoSqueezeStill(dpy_, Tk_WindowId(tk_), gc_,
		0, format_offset_, format_width_, format_height_,
		0, 0, width_, height_);
#endif
}

void PlxWindow::release_frame(sigset_t* ss)
{
	XUngrabServer(dpy_);
	sync();
	(void)sigprocmask(SIG_SETMASK, ss, 0);
	if (need_refresh_) {
		XPlxVideoTag(dpy_, Tk_WindowId(tk_), gc_, PLX_VIDEO_OVR);
		need_refresh_ = 0;
	}
}

extern int quality_to_qfactor(int);

void PlxWindow::setq(int q)
{
	char *table;
	if(q>100) q =50;
#ifdef Sr_DEBUG
	fprintf(stdout, "PlxJpegGrabber::setq(%d)  quality_to_qfactor(q) =%d\n", q, quality_to_qfactor(q));
#endif /* Sr_DEBUG */
	int size = MakeQTables(quality_to_qfactor(q), (unsigned char**)&table);
	/*
	int size = MakeQTables((q), (unsigned char**)&table);
	*/
	XPlxPutTable(dpy_, Tk_WindowId(tk_), gc_,
#ifdef __hpux
		     (short *)
#endif
		     table, size, 0 /* compress */);
	free(table);
}

#ifdef LOGO
void PlxGrabber::initlogo() {
	// We should check if we already have initialized it!
	// FIXME
#ifdef Sr_DEBUG
	printf("Logolen_ = %d, logomasklen_= %d\n", logolen_, logomasklen_);
#endif
	u_char stdlogo[] = {
#include "mms/logo.h"
	};
	logo_ = new u_char[sizeof(stdlogo)];
	memcpy(logo_, stdlogo, (sizeof(stdlogo)));
	logolen_ = BINSIZE;

	u_char stdlogomask[] = {
#include "mms/logomask.h"
	};
	logomask_ = new u_char[sizeof(stdlogomask)];
	memcpy(logomask_, stdlogomask, (sizeof(stdlogomask)));
	logomasklen_ = BINSIZE;
	delete[] stdlogo;
	delete[] stdlogomask;
}

#endif
PlxGrabber::PlxGrabber() : capwin_(0), decimate_(0), remoteWin_(0), remoteDisp_(0)
{
	if (lookup_visual() < 0)
		status_ = -1;
	lx_ = 5;
	ly_ = 5;
	lpm_ = 0;
	halfsize_ =0;
	plxOutDev_ =0;
#ifdef 	LOGO_PERMANENT
	logodrawn_=1;
	Tcl::instance().evalc(".menu.parallax.f.qb.logo configure -state disabled -foreground gray60");
#else
	logodrawn_ =0;
#endif /* LOGO_PERMANENT */
}

PlxGrabber::~PlxGrabber()
{
}

int PlxGrabber::lookup_visual()
{
	DTEXT("lookup_visual");
	// XXX
	int res=createRemote();
	// res == -2 means: we have no remote, using normal
	if(res!=-2) {
		return res;
	}

	Tk_Window tk = Tcl::instance().tkmain();
	Display* dpy = Tk_Display(tk);
	int majop, eventbase, errbase;
	if (XQueryExtension(dpy, "ParallaxVideo", &majop,
			    &eventbase, &errbase) &&
	    (XMatchVisualInfo(Tk_Display(tk), Tk_ScreenNumber(tk),
			      24, TrueColor, &vinfo_) ||
	     XMatchVisualInfo(Tk_Display(tk), Tk_ScreenNumber(tk),
			      32, TrueColor, &vinfo_))) {
		return (0);
	}
	return (-1);
}

//overwritting Grabber::fps for halfsize: doubling fps then
void PlxGrabber::fps(int v)
{
	fps_ = v;
	if(halfsize_)
		v*=2;
	frametime_ = 1e6 / double(v);
}


void PlxGrabber::start()
{
	// Check if a Parallax-Output is running at the same time
	// The Parallax-Card doesn't like it...
	if(!plxOutDev_) {
		Tcl &tcl = Tcl::instance();
		char * tmp = tcl.var("outputDeviceList");
		if(tmp) {
			char *tmp2 = strdup(tmp);
			char *toCheck,*next,*devNick;
			toCheck = tmp2;
			while(1) {
				char	buf[200];
				next = strchr(toCheck,' ');
				if (next) 
					*next='\0';
				plxOutDev_ = (PlxOutputDevice*)TclObject::lookup(toCheck);
				sprintf(buf,"%s nickname",toCheck);
				tcl.evalc(buf);
				devNick = tcl.result();
				if(!strcmp(devNick, "parallax"))
					break;
				plxOutDev_=0;
				if (next)
					toCheck = next+1; //after space
				else
					break;
			}
			free(tmp2);
		}
	}
	if(plxOutDev_) {
		int runningplxOutDev = plxOutDev_->isActive();
		if(runningplxOutDev) {
			Tcl::instance().evalc("open_dialog \"Warning: There's a running Parallax-Output\nwhich can lead to unexpected results if you use the Parallax-Grabber at the same time!\"");
		}
	}
	Grabber::start();
}

int
PlxGrabber::createRemote() {
	Tcl &tcl = Tcl::instance();
	if(remoteWin_)
		Tk_DestroyWindow(remoteWin_);

	if(remoteDisp_) {
		free(remoteDisp_);
	}
	tcl.evalc(".menu.parallax.f.rb.entry get");
	remoteDisp_ = tcl.result();
#ifdef Sr_DEBUG
	fprintf(stdout, "PlxGrabber::createRemote()  : remoteDisp_ == #%s#\n",remoteDisp_);
#endif /* Sr_DEBUG */
	if(!remoteDisp_|| !strcmp(remoteDisp_,"")) {
		remoteDisp_ = NULL;
		//tcl.evalf(".menu.parallax.f.rb.entry insert 0 %s", remoteDisp_);
		/* XXX
		if(remotevinfo_)
			free(remotevinfo_);
		remotevinfo_=NULL;
		*/
		DTEXT("createRemote: return with -2");
		return -2;
	}
	/* useless?
	remoteWin_ = Tk_CreateWindowFromPath(tcl.interp(), tcl.tkmain(), ".remotemenu", 
		remoteDisp_);
	if(!remoteWin_) {
		tcl.evalc("open_dialog \"Cannot create remote-window for Grabber-Menu!\"");
	} else {
		tcl.evalc("build.parallax .remotemenu");
		tcl.evalc(".remotemenu.f.qb.logo  configure -state disabled");
		tcl.evalc("pack forget .remotemenu.f.rb");
		Tk_MakeWindowExist(remoteWin_);
		Tk_MapWindow(remoteWin_);
	}
	*/

	Display* dpy = XOpenDisplay(remoteDisp_);
	int scrn = DefaultScreen(dpy);
	int majop, eventbase, errbase;

	if (XQueryExtension(dpy, "ParallaxVideo", &majop,
			    &eventbase, &errbase) &&
	    (XMatchVisualInfo(dpy, scrn,
			      24, TrueColor, &remotevinfo_) ||
	     XMatchVisualInfo(dpy, scrn,
			      32, TrueColor, &remotevinfo_))) {
		DTEXT("createRemote: return with status_ = 0");
		return 0;
	}
// Xtr-Card from Parallax
// XXXX still not working on my local machine
// Problems is the Visualinfo on th 45z
#ifdef XTRA
	if (XQueryExtension(dpy, "XVideo", &majop,
			    &eventbase, &errbase) &&
	    (XMatchVisualInfo(dpy, scrn,
			       8, TrueColor, &remotevinfo_) ||
		XMatchVisualInfo(dpy, scrn,
			      24, TrueColor, &remotevinfo_) ||
	     XMatchVisualInfo(dpy, scrn,
			      32, TrueColor, &remotevinfo_))) {
		DTEXT("createRemote: return with status_ = 0,  Xtra-Card");
		return 0;
	}
#endif /* XTRA */
		DTEXT("createRemote: return with -1");
	return -1;
}

int PlxGrabber::command(int argc, const char * const*argv)
{
	Tcl &tcl = Tcl::instance();
	if (argc == 2) {
		if (strcmp(argv[1], "need-capwin") == 0) {
			tcl.result("1");
			return (TCL_OK);
		} else if (strcmp(argv[1], "half") == 0) {
			halfsize_=!halfsize_;
			capwin_->resetsize(decimate_);
			setsize();
			fps(Grabber::fps());
			return (TCL_OK);
		} else if (strcmp(argv[1], "sendStill") == 0) {
			int noLiveVideo_= atoi(tcl.var("stillButtonState"));
			if(capwin_) {
				// XXX
				capwin_->setsize(capwin_->width(), capwin_->height());
			}
			if(noLiveVideo_) {
				DTEXT("stillButtonState=1");
			} else {
				DTEXT("stillButtonState=0");
			}
			return (TCL_OK);
		}
		else if(strcmp(argv[1], "set_logo") == 0) {
#ifdef LOGO
			logodrawn_ = !logodrawn_;
			if(!logodrawn_) {
				XClearArea(Tk_Display(capwin_->tkwin()), Tk_WindowId(capwin_->tkwin()), lx_, ly_, lw_, lh_, 1);
			} else {
				if(lpm_ == 0) {
			    	DTEXT("command: RAS->PM\n");
					initlogo();
					PmFromRas((char*)logo_, (char*)logomask_, Tk_WindowId(capwin_->tkwin()), capwin_->gc(), logolen_, logomasklen_);
				}
				drawlogo();
			}
#endif /* LOGO */
			return (TCL_OK);
		}
	} else if (argc == 3) {
		if (strcmp(argv[1], "decimate") == 0) {
			int d = atoi(argv[2]);
			if (d <= 0) {
				Tcl_AppendResult(tcl.interp(),
					"%s: divide by zero",
					argv[0], 0);
				return TCL_ERROR;
			}
			if (d != decimate_) {
				decimate_ = d;
				capwin_->resetsize(decimate_);
				setsize();
			}
			return (TCL_OK);
		} else if (strcmp(argv[1], "port") == 0) {
			capwin_->port(argv[2]);
			return (TCL_OK);
		} else if (strcmp(argv[1], "contrast") == 0) {
			capwin_->contrast(atoi(argv[2]));
			return (TCL_OK);
		} else if (strcmp(argv[1], "brightness") == 0) {
			capwin_->brightness(atoi(argv[2]));
			return (TCL_OK);
		} else if (strcmp(argv[1], "hue") == 0) {
			capwin_->hue(atoi(argv[2]));
			return (TCL_OK);
		} else if (strcmp(argv[1], "saturation") == 0) {
			capwin_->saturation(atoi(argv[2]));
			return (TCL_OK);
		} else if (strcmp(argv[1], "create-capwin") == 0) {
			DTEXT("command: create-capwin");
			char* new_port = tcl.var("inputPort");
			if(remoteDisp_) {
				Tk_Window f = Tk_NameToWindow(tcl.interp(),".capture", tcl.tkmain());
				capwin_ = new PlxWindow(argv[2], &remotevinfo_, new_port, remoteDisp_, f);
			} else {
				capwin_ = new PlxWindow(argv[2], &vinfo_, new_port, 0, 0);
			}
#ifdef LOGO
			if(logodrawn_) {
				if(lpm_ == 0) {
			    	DTEXT("command: new capwin_ => RAS->PM\n");
					initlogo();
					PmFromRas((char*)logo_, (char*)logomask_, Tk_WindowId(capwin_->tkwin()), capwin_->gc(), logolen_, logomasklen_);
				}
				drawlogo();
			}
#endif
			tcl.result(capwin_->name());
			return (TCL_OK);
		} else if (strcmp(argv[1], "setInput") == 0) {
			capwin_->setInputStandard(argv[2]);
			return (TCL_OK);
		} else if (strcmp(argv[1], ".menu.parallax.f.lr.x.entry") == 0
				|| strcmp(argv[1], ".remotemenu.f.lr.x.entry") == 0) {
			// Width sets height to get a 4:3 aspect
			capwin_->specialsetsize(atoi(argv[2]), 0);
			inh_ = outh_ = capwin_->height();
			inw_ = outw_ = capwin_->width();
			return (TCL_OK);
		} else if (strcmp(argv[1], ".menu.parallax.f.lr.y.entry") == 0 
				|| strcmp(argv[1], ".remotemenu.f.lr.y.entry") == 0) {
			// XXX to keep 4:3 aspect...
			int wh = atoi(argv[2]);
			capwin_->specialsetsize( (4*wh)/3, wh);
			inh_ = outh_ = capwin_->height();
			inw_ = outw_ = capwin_->width();
			return (TCL_OK);
		} else if (strcmp(argv[1], ".menu.parallax.f.rb.entry") == 0) {
			// XXX
			createRemote();
			return (TCL_OK);
		} else if (strcmp(argv[1], "send") == 0) {
/* Disabled at the moment, due to missing checks
			if(strcmp(argv[2],"1")==0) {
				tcl.evalc(".menu.parallax.f.rb.label configure -foreground black");
				tcl.evalc(".menu.parallax.f.rb.entry configure -state normal -foreground black");
				// we should add here others too
			}
*/
			return (Grabber::command(argc, argv));
		}
	}
	return (Grabber::command(argc, argv));
}

Plx422Grabber::Plx422Grabber() : image_(0), converter_(0)
{
}

Plx422Grabber::~Plx422Grabber()
{
	delete image_;
}

void Plx422Grabber::capture()
{
	/*
	 * Grab the frame.
	 */
	sigset_t ss;
	capwin_->freeze_frame(&ss);
	Tk_Window tk = capwin_->tkwin();
	/*
	 * The parallax X server doesn't seem to support xshmgetimage.
	 */
	XImage* image = image_->ximage();
#ifdef USE_SHM
	if (image->obdata != 0)
		XShmGetImage(Tk_Display(tk), Tk_WindowId(tk), image,
			     0, 0, AllPlanes);
	else
#endif
		XGetSubImage(Tk_Display(tk), Tk_WindowId(tk),
			     0, 0, image->width, image->height,
			     AllPlanes, ZPixmap, image, 0, 0);
	capwin_->release_frame(&ss);
	converter_->convert((u_int8_t*)image->data,
			    image->width, image->height, frame_);
}

void Plx422Grabber::setsize()
{
	int w = capwin_->basewidth() / decimate_;
	int h = capwin_->baseheight() / decimate_;
	capwin_->setsize(w, h);
	converter_ = RGB_Converter_422::instance();
	image_ = StandardVideoImage::allocate(capwin_->tkwin(), w, h);
	set_size_422(w, h);
	allocref();
}

int Plx422Grabber::grab()
{
	capture();
	suppress(frame_);
	saveblks(frame_);
	YuvFrame f(media_ts(), frame_, crvec_, outw_, outh_);
	return (target_->consume(&f));
}

void Plx411Grabber::setsize()
{
	int w = capwin_->basewidth() / decimate_;
	int h = capwin_->baseheight() / decimate_;
	capwin_->setsize(w, h);
	converter_ = RGB_Converter_411::instance();
	image_ = StandardVideoImage::allocate(capwin_->tkwin(), w, h);
	set_size_411(w, h);
	allocref();
}

void PlxCIFGrabber::setsize()
{
	int w = 2 * 352 / decimate_;
	int h = 2 * 288 / decimate_;
	capwin_->setsize(w, h);
	converter_ = RGB_Converter_411::instance();
	image_ = StandardVideoImage::allocate(capwin_->tkwin(), w, h);
	set_size_411(w, h);
	allocref();
}

PlxJpegGrabber::PlxJpegGrabber() : q_(50), cimage_(0)
{
}

PlxJpegGrabber::~PlxJpegGrabber()
{
#ifdef LOGO
	// XXX
	if(lpm_!=0)
		XFreePixmap(Tk_Display(capwin_->tkwin()), vals.clip_mask);
	// XXX free logo_ && logomask_

#endif
	/*XXX free cimage_ */
}

#ifdef LOGO

#include "mms/image.h"
extern "C" int do_raster_load(FILE *fp, u_char *buf, int len, XP_Image *im, int bitmap_pad, int load_chunk);

void
PlxGrabber::PmFromRas(char *file, char *filemask, Window win, GC wgc, int builtin_file_size, int builtin_filemask_size)
{
	FILE *fp;
	XP_Image im;
	GC pmgc;
	XImage *xim;
	Tk_Window tk = capwin_->tkwin();
	Display *dpy = Tk_Display(tk);


	DTEXT("::PmFromRas()");

	/* Logo */

	if (!builtin_file_size) {
		DTEXT("::PmFromRas() : No builtin_file_size");
		// this is to load a mask via file, which is a filename.
		// if builttin_file_size != 0 file is the mask
		return;
	}
	if (!(do_raster_load(NULL, (unsigned char *)file, builtin_file_size, &im, 16, 0) == IM_OK) ||
		!(im.depth == 24 || im.depth==32))
	{
		printf("builtin file is not a 24 bit rasterfile\n");
		return;
	}
	// might be good to have these as object-wide variables
	lw_ = im.width;
	lh_ = im.height;
#ifdef Sr_DEBUG
	fprintf(stdout, " lw_ = %d, lh_= %d\n", lw_, lh_);
#endif /* Sr_DEBUG */
	/* XXX */
	xim = XCreateImage(dpy, (Visual *)Tk_Visual(tk), Tk_Depth(tk),
		ZPixmap,0,(char*)im.data,lw_,lh_,16,0);
	lpm_ = XCreatePixmap(dpy, win, lw_, lh_, Tk_Depth(tk));
	pmgc = XCreateGC(dpy, lpm_, 0, 0);
	XPutImage(dpy, lpm_, pmgc, xim, 0,0,0,0, lw_, lh_);
	XFreeGC(dpy, pmgc);
	XDestroyImage(xim);


	/* logo mask */

	if (!builtin_filemask_size) {
		DTEXT("::PmFromRas() : No builtin_filemask_size");
		// Unsupported until now.
		// this is to load a mask via file, which is a filename.
		// if builttin_filemask_size != 0 filemask is the mask
		return;
	}
		
	if (!(do_raster_load(NULL, (unsigned char *)filemask, 
		builtin_filemask_size, &im, 16, 0) == IM_OK) ||
		im.depth != 1)
	{
		printf("builtin filemask is not 1 bit (depth = %d)\n", im.depth);
		return;
	}

	vals.clip_mask = XCreatePixmapFromBitmapData(dpy, win, (char*)im.data,lw_,lh_,1,0,1);
	vals.clip_x_origin = lx_;
	vals.clip_y_origin = ly_;
	vals.foreground = 0x0000ff00;
	XChangeGC(dpy, capwin_->gc(), GCForeground, &vals);
	return;

}

void PlxGrabber::drawlogo() {
	XGCValues mvals;
	Tk_Window tk = capwin_->tkwin();
	Display *dpy = Tk_Display(tk);
	Window videowin = Tk_WindowId(tk);
	GC drawgc = capwin_->gc();

	XChangeGC(dpy, drawgc, GCClipMask | GCClipXOrigin | GCClipYOrigin , &vals);
	XPlxVideoTag(dpy, videowin, drawgc, PLX_GRAPHICS_24);
	XCopyArea(dpy, lpm_, videowin, drawgc, 0, 0, lw_, lh_, lx_, ly_);

	mvals.clip_mask = 0;
	mvals.clip_x_origin = 0;
	mvals.clip_y_origin = 0;
	XChangeGC(dpy, drawgc, GCClipMask | GCClipXOrigin | GCClipYOrigin , &mvals);
}

#endif // LOGO

void PlxJpegGrabber::setsize()
{
	int w = capwin_->basewidth() / decimate_;
	int h = capwin_->baseheight() / decimate_;
#ifdef Sr_Debug
	fprintf(stdout, "PlxJpegGrabber::setsize() : w x h: %d  x %d     ; decimate_ = %d\n", w,h, decimate_);
#endif
	if(halfsize_) {
		h /=2;
	}
	capwin_->setsize(w, h);
	inw_ = outw_ = w;
	inh_ = outh_ = h;
#ifdef notdef
	Tk_Window tk = capwin_->tkwin();
	if (cimage_ != 0)
		(void)XPlxDestroyCImage(cimage_);
	cimage_ = XPlxCreateCImage(Tk_Display(tk), DATA, SIZE, w, h);
#endif
}

int PlxJpegGrabber::capture(u_int8_t* bp)
{
	sigset_t ss;
	capwin_->freeze_frame(&ss);
	XPlxCImage* p;
	Tk_Window tk = capwin_->tkwin();
#ifdef LOGO
	// FIX ME
	if(logodrawn_) {
		if(lpm_ == 0) {
			DTEXT("RAS->PM\n");
			PmFromRas((char*)logo_, (char*)logomask_, Tk_WindowId(tk), capwin_->gc(), logolen_, logomasklen_);
		}
		drawlogo();
	}
#endif

	int w = capwin_->width();
	int h = capwin_->height();
#ifdef USE_SHM_notyet
	p = cimage_;
	XPlxShmGetCImage(Tk_Display(tk), Tk_WindowId(tk),
			 capwin_->gc(), cimage_, 0, 0, w, h);
#else
	int w2 = capwin_->width();
	int h2 = capwin_->height();

	p = XPlxGetCImage(Tk_Display(tk), Tk_WindowId(tk),
			  capwin_->gc(), 0, 0, w, h, w2, h2);
			  // w,h == source, w2,h2 == dest

#endif
	capwin_->release_frame(&ss);
	/*XXX*/
	memcpy(bp, p->data, p->size);
	int size = p->size;

#ifndef USE_SHM_notyet
	XPlxDestroyCImage(p);
#endif

	return (size);
}

int PlxJpegGrabber::grab()
{
	/*
	 * Make sure the previous frame has been completely transmitted
	 * before we overwrite the buffer.
	 */
	tx_->flush();
	XWindowChanges *xwc;
	xwc = Tk_Changes(Tk_Parent(capwin_->tkwin()));
	if (capwin_->width() != xwc->width ||
      capwin_->height() != xwc->height) {
#ifdef Sr_DEBUG
		fprintf(stdout, "capwin_: width() x height() = %d x %d		xwc: %d x %d\n",
			capwin_->width(), capwin_->height(), xwc->width, xwc->height);
#endif /* Sr_DEBUG */
		// allows us NOT to change format_width_ or remember that.
		if(halfsize_) {
			capwin_->specialsetsize(xwc->width, xwc->height/2);
			inh_ = outh_ = capwin_->height();
		} else {
			capwin_->specialsetsize(xwc->width, xwc->height);
			inh_ = outh_ = capwin_->height();
		}
		inw_ = outw_ = capwin_->width();
	}
	/*XXX*/
	static u_int32_t wrk[80*1024 / 4];
	int len = capture((u_int8_t*)wrk);

	/* these 6 lines would make a simple effect: display the field in the top,
	 * not in the middle of the window -SB
	if(halfsize_) {
		outh_ *=2;
	}
	*/
	JpegFrame f(media_ts(), (u_int8_t*)wrk, len, q_, 0, outw_, outh_);
	/*
	if(halfsize_) {
		outh_ /=2;
	}
	*/
	//printf("tx_->mtu() == %d\n", tx_->mtu()); // I can't believe it: -m isn't evaluated???
	return (target_->consume(&f));
}

int PlxJpegGrabber::command(int argc, const char* const *argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "q") == 0) {
			/* assume value is in range */
			q_ = atoi(argv[2]);
			capwin_->setq(q_);
			return (TCL_OK);
		}
	}
	return (PlxGrabber::command(argc, argv));
}
