/* MMSvideo  Copyright (c) 1994-1996 Rudolf Koenig &                        */
/*           Friedrich-Alexander Universitaet Erlangen-Nuernberg, IMMD4     */
/*           All rights reserved.                                           */

/*           THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                 */
/*           Rudolf Koenig & FAU Erlangen-Nuernberg                         */
/*           The copyright notice above does not evidence any               */
/*           actual or intended publication of such source code.            */

#define MASK_IGN	0
#define MASK_TRANSP	1
#define MASK_FG 	2
#define MASK_TILE	0x80

#ifndef NO_PNM_SUPPORT
# define PNM_SUPPORT
#endif
#ifndef NO_RLE_SUPPORT
# define RLE_SUPPORT
#endif
#ifndef NO_GIF_SUPPORT
# define GIF_SUPPORT
#endif

#define IT_RASTERFILE	1
#define IT_SHINKO	2
#define IT_JPEG		3
#define IT_PBM		4
#define IT_PGM		5
#define IT_PPM		6
#define IT_RLE		7
#define IT_GIF		8
#define IT_XBM          9
#define IT_XVICON      10

typedef struct XP_Mask
{
  int x_off, y_off;	/* mask starts at offset in image */
  int width, height;	/* size of mask (!not image) */
  int bytes_per_line;
  unsigned char *data;
  int other;		/* Bit Value for all pixels not covered by data */
  int op;		/* what to do with this mask IGN, AND, OR */
} XP_Mask;

typedef struct XP_Colormap
{
  int grayscale:1; /* nonzero if this cmap was created with grayscale_cmap() */
  int hasalpha:1; /* nonzero if an alpha channel has been explicitly added */
  int length;    /* == redlength+bluelength+greenlength */
  unsigned char *red, *green, *blue;
} XP_Colormap;

typedef struct XP_Image 
{
  int depth;
  int width, height;
  int bytes_per_line;
  unsigned char *data;
  XP_Colormap cmap;
  XP_Mask mask;	   /* partial bitmap for paste_image */
  int background;  /* 1/0 for bw, colidx for pseudo, alpha for true color */
  int foreground;  /* 1/0 for bw, colidx for pseudo, alpha for true color */
  int current_x,   /* For drawing .... */
      current_y;
  char *name;
} XP_Image;

#if defined(i386)
#define SHORTSWAP(x) ShortSwap(x)
#define LONGSWAP(x)  LongSwap(x)
#else
#define SHORTSWAP(x) x
#define LONGSWAP(x)  x
#endif

#define IM_OK              0
#define IM_CORRUPTED       1
#define IM_UNKNOWN_TYPE    2
#define IM_NO_MEM          3
#define IM_UNSUPP_VERSION  4
#define IM_UNSUPP_DEPTH    5
#define IM_WRITE_FAILED    6
#define IM_MAX_ERROR       6

extern char *image_errlist[];
extern char *im_type;		/* both used in pnm.c */

#define FRAME_USE_IMAGE  1
#define FRAME_USE_PIXMAP 2

#ifndef __P
# ifdef __STDC__
#  define __P(a) a
# else
#  define __P(a) ()
# endif
#endif

extern int raster_load __P((FILE *, XP_Image *, int, int));
extern int raster_save __P((FILE *, XP_Image *, int));
#ifdef JPEG_SUPPORT
extern int write_jpeg_file __P((FILE *, XP_Image *));
extern int read_jpeg_file  __P((FILE *, XP_Image *));
#endif
extern int shinko_save __P((FILE *, XP_Image *));
#ifdef PNM_SUPPORT
extern int pnm_load __P((FILE *, XP_Image *, int *, int));
extern int pnm_save __P((FILE *, XP_Image *, int));
extern int pbm_load_data __P((XP_Image *, int, int (*)(), FILE *));
extern int pgm_load_data __P((XP_Image *, int, int, int (*)(), FILE *));
extern int ppm_load_data __P((XP_Image *, int, int, int (*)(), FILE *));
#endif
#ifdef RLE_SUPPORT
extern int rle_load __P((FILE *, XP_Image *, int));
extern int rle_save __P((FILE *, XP_Image *));
#endif
#ifdef GIF_SUPPORT
extern int gif_load __P((FILE *, XP_Image *, int));
extern int gif_save __P((FILE *, XP_Image *));
#endif

extern void grayscale_cmap __P((XP_Colormap *));

extern XP_Image *XP_CreateImage __P((int, int, int, int, 
				 unsigned char *, unsigned char *, 
				 unsigned char *, unsigned char *, int, int));
extern void XP_FreeImage __P((XP_Image *));
extern int createimage __P((XP_Image *));
extern void *create_frame __P(());
extern int stack_name_image __P(()); /* __P((Var *, XP_Image **)); */
extern int paste_im __P((XP_Image *, XP_Image *, int, int));
