/*
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /src/multimedia/LOCAL/vic/vic-Marcus/RCS/osprey.cc,v 1.3 1997/10/07 21:03:44 msmeissn Exp msmeissn $ (LBL)";
#endif

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/param.h>
extern int errno;
#include <dlfcn.h>

#include "module.h"
#include "Tcl.h"


#include <tk.h>
#include <xil/xil.h>

#include "xil.h"
#include <thread.h>

#include <sys/audioio.h>
#include <multimedia/audio_hdr.h>
#include <multimedia/audio_device.h>
#include <multimedia/audio_filehdr.h>
typedef audio_info_t  Audio_info;

#include "/opt/MMACo1k/include/oti_libaudio.h"
#include "/opt/MMACo1k/include/oti_audio_device.h"

struct funcs {
	int (*oti_audio_init)(char*,char*);
	int (*oti_close)(int);
	int (*oti_open)(char *,int);
	int (*oti_write)(int,void*,size_t);
	int (*oti_read)(int,void*,size_t);
	int (*oti_audio_setinfo)(int,Audio_info*);
	int (*oti_audio_getinfo)(int,Audio_info*);
	int (*oti_audio__setplayhdr)(int,Audio_hdr*,unsigned int);
	int (*oti_ioctl)(int,int,void*);
	int (*oti_audio__setval)(int,unsigned*,unsigned);
	int (*oti_audio__setgain)(int,double*,unsigned);
} xfuncs;

static int init_funcs() {
	void*	otiaudiolib;
	otiaudiolib=dlopen("libotiaudio.so",RTLD_NOW);
	if (!otiaudiolib) {
		/* silent return */
		return 0;
	}
	xfuncs.oti_audio_init = (int (*)(char*,char*))dlsym(otiaudiolib,"oti_audio_init");
	xfuncs.oti_close = (int (*)(int))dlsym(otiaudiolib,"oti_close");
	xfuncs.oti_open = (int (*)(char*,int))dlsym(otiaudiolib,"oti_open");
	xfuncs.oti_write = (int (*)(int,void*,size_t))dlsym(otiaudiolib,"oti_write");
	xfuncs.oti_read = (int (*)(int,void*,size_t))dlsym(otiaudiolib,"oti_read");
	xfuncs.oti_audio_setinfo = (int (*)(int,Audio_info*))dlsym(otiaudiolib,"oti_audio_setinfo");
	xfuncs.oti_audio_getinfo = (int (*)(int,Audio_info*))dlsym(otiaudiolib,"oti_audio_getinfo");
	xfuncs.oti_audio__setplayhdr = (int (*)(int,Audio_hdr*,unsigned int))dlsym(otiaudiolib,"oti_audio__setplayhdr");
	xfuncs.oti_ioctl = (int (*)(int,int,void*))dlsym(otiaudiolib,"oti_ioctl");
	xfuncs.oti_audio__setval = (int (*)(int,unsigned*,unsigned))dlsym(otiaudiolib,"oti_audio__setval");
	xfuncs.oti_audio__setgain = (int (*)(int,double*,unsigned))dlsym(otiaudiolib,"oti_audio__setgain");
	return 1;
}

#define oti_audio_init		(*xfuncs.oti_audio_init)
#define oti_close		(*xfuncs.oti_close)
#define oti_open		(*xfuncs.oti_open)
#define oti_write		(*xfuncs.oti_write)
#define oti_read		(*xfuncs.oti_read)
#define oti_ioctl		(*xfuncs.oti_ioctl)
#define oti_audio_setinfo	(*xfuncs.oti_audio_setinfo)
#define oti_audio_getinfo	(*xfuncs.oti_audio_getinfo)
#define oti_audio__setplayhdr	(*xfuncs.oti_audio__setplayhdr)
#define oti_audio__setval	(*xfuncs.oti_audio__setval)
#define oti_audio__setgain	(*xfuncs.oti_audio__setgain)

#include "osprey.h"

static int ospreyusecnt=0;
static int osprey_socket=0;

typedef unsigned char u8;

static void
osprey_write_return(int unixs,struct o1ka_ret *ret) {
	/*fprintf(stderr,"osprey_write_return: trying to write %d bytes\n",ret->addbytes+sizeof(*ret));*/
	if (-1==write(unixs,(u8*)ret,ret->addbytes+sizeof(*ret))) {
		perror("osprey_write_res");
		return;
	}
}

static int
osprey_read_command(int unixs,struct o1ka_cmd **cmd) {
	struct	o1ka_cmd	xcmd;
	int	res;

/*	fprintf(stderr,"osprey_read_command: trying to read 4 bytes\n");*/
	if (sizeof(xcmd)!=(res=read(unixs,(u8*)&xcmd,sizeof(xcmd)))) {
		perror("osprey_read_command");
		*cmd = (struct o1ka_cmd*)malloc(sizeof(**cmd));
		return res;
	}
	*cmd = (struct o1ka_cmd*)malloc(xcmd.addbytes+sizeof(xcmd));
	memcpy((u8*)*cmd,(u8*)&xcmd,sizeof(xcmd));
	if (xcmd.addbytes) {
/*		fprintf(stderr,"osprey_read_command: trying to read %d more bytes\n",xcmd.addbytes);*/
		if (xcmd.addbytes!=(res=read(unixs,((u8*)*cmd)+sizeof(**cmd),xcmd.addbytes))) {
			perror("osprey_read_command 2");
			return res;
		}
	}
	return res;
}

/* thread main function */
void*
osprey_main(void *bla) {
	struct sockaddr_un  sunaddr;
	int	s,rc;
	int	libfd;


	if (!init_funcs())
		return NULL;
	if ((rc=oti_audio_init(NULL,NULL))<0) {
		fprintf(stderr,"oti_audio_init failed.\n");
		return NULL;
	}
	if (-1==(osprey_socket = socket(PF_UNIX,SOCK_STREAM,0))) {
		perror("unix domain socket");
		return NULL;
	}
	sunaddr.sun_family = AF_UNIX;
	strcpy(sunaddr.sun_path,"/tmp/.o1k0");
	unlink(sunaddr.sun_path);
	if (-1==bind(osprey_socket,(struct sockaddr*)&sunaddr,sizeof(sunaddr))){
		perror("bind /tmp/.o1k0");
		return NULL;
	}
	chmod("/tmp/.o1k0",S_IRWXU);
	if (-1==listen(osprey_socket,1)) {
		perror("listen ospreysocket");
		return NULL;
	}
	while (1) {
		struct sockaddr_un sun1;
		int	len;

		len=sizeof(sun1);
		if (-1==(s=accept(osprey_socket,(struct sockaddr*)&sun1,&len))) {
			perror("accept ospreysocket");
			continue;
		}
		while (1) {
			int			audiofd;
			struct	o1ka_cmd	*cmd;

			if (0>=osprey_read_command(s,&cmd)) {
				if (errno==EINTR) continue;
				perror("osprey unix socket read");
				oti_close(audiofd); /* hack */
				close(s);
				break;
			}

			/*fprintf(stderr,"osprey handler got cmd:%d\n",cmd->cmd);*/
			switch (cmd->cmd) {
			case O1KA_OPEN: {
				struct	o1ka_cmd_open	*opcmd = (struct o1ka_cmd_open*)cmd;
				struct	o1ka_ret_open	opret;

				audiofd=oti_open("/dev/o1k0",O_RDWR|O_NDELAY);
				opret.ret.addbytes = sizeof(opret)-sizeof(struct o1ka_ret);
				if (audiofd==-1) {
					perror("oti_open");
					opret.ret.ret = O1KA_FAILED;
				} else {
					opret.ret.ret = O1KA_OK;
					opret.audiofd = audiofd;
				}
				osprey_write_return(s,(struct o1ka_ret*)&opret);
				break;
			}
			case O1KA_CLOSE: {
				struct o1ka_cmd_close	*clcmd = (struct o1ka_cmd_close*)cmd;
				struct o1ka_ret_close	clret;

				clret.ret.addbytes	= 0;
				clret.ret.ret		= O1KA_OK;
				oti_close(clcmd->audiofd);
				osprey_write_return(s,(struct o1ka_ret*)&clret);
				break;
			}
			case O1KA_WRITE: {
				struct o1ka_cmd_write	*wrcmd = (struct o1ka_cmd_write*)cmd;
				struct o1ka_ret_write	wrret;

				int			res;

				res=oti_write(wrcmd->audiofd,wrcmd->buf,wrcmd->byteswanted);
				wrret.ret.addbytes = sizeof(wrret)-sizeof(struct o1ka_ret);
				if (res==-1) {
					wrret.ret.ret = O1KA_FAILED;
				} else {
					wrret.ret.ret = O1KA_OK;
					wrret.byteswritten = res;
				}
				osprey_write_return(s,(struct o1ka_ret*)&wrret);
				/*oti_write(wrcmd->audiofd,wrcmd->buf,0);*/
				break;
			}
			case O1KA_READ: {
				struct o1ka_cmd_read	*rcmd = (struct o1ka_cmd_read*)cmd;
				struct o1ka_ret_read	*rret;

				int	res;

				rret = (struct o1ka_ret_read*)malloc(sizeof(struct o1ka_ret)+rcmd->byteswanted);
				res=oti_read(rcmd->audiofd,rret->buf,rcmd->byteswanted);
				rret->ret.addbytes = sizeof(*rret)-sizeof(struct o1ka_ret);
				if (res==-1) {
					rret->ret.ret = O1KA_FAILED;
				} else {
					rret->ret.ret = O1KA_OK;
					rret->bytesread = res;
				}
				osprey_write_return(s,(struct o1ka_ret*)rret);
				free((u8*)rret);
				break;
			}
			case O1KA_SET_INFO: {
				struct o1ka_cmd_setinfo	*rcmd = (struct o1ka_cmd_setinfo*)cmd;
				struct o1ka_ret		ret;
				int	res;

				res=oti_audio_setinfo(rcmd->audiofd,&(rcmd->info));
				ret.addbytes = 0;
				if (res==-1)
					ret.ret = O1KA_FAILED;
				else
					ret.ret = O1KA_OK;
				osprey_write_return(s,&ret);
				break;
			}
			case O1KA_SET_PLAY_CONFIG: {
				struct o1ka_cmd_set_play_config *spccmd = (struct o1ka_cmd_set_play_config*)cmd;
				struct o1ka_ret	ret;
				int	res;

				res = oti_audio_set_play_config(spccmd->audiofd,&(spccmd->hdr));
				ret.addbytes=0;
				if (res==-1)	
					ret.ret = O1KA_FAILED;
				else
					ret.ret = O1KA_OK;
				osprey_write_return(s,&ret);
				break;
			}
			case O1KA_SET_RECORD_CONFIG: {
				struct o1ka_cmd_set_record_config *spccmd = (struct o1ka_cmd_set_record_config*)cmd;
				struct o1ka_ret	ret;
				int	res;

				res = oti_audio_set_record_config(spccmd->audiofd,&(spccmd->hdr));
				ret.addbytes=0;
				if (res==-1)	
					ret.ret = O1KA_FAILED;
				else
					ret.ret = O1KA_OK;
				osprey_write_return(s,&ret);
				break;
			}
			case O1KA_IOCTL: {
				struct o1ka_cmd_ioctl *icmd = (struct o1ka_cmd_ioctl*)cmd;
				struct o1ka_ret_ioctl *ret;
				int	res;

				if (icmd->databytes)
					res = oti_ioctl(icmd->audiofd,icmd->ioctlcmd,icmd->buf);
				else
					res = oti_ioctl(icmd->audiofd,icmd->ioctlcmd,*(int*)icmd->buf);
				ret = (struct o1ka_ret_ioctl*)malloc(sizeof(*ret)+icmd->databytes);
				ret->ret.addbytes=icmd->databytes;
				if (res==-1)	
					ret->ret.ret = O1KA_FAILED;
				else
					ret->ret.ret = O1KA_OK;
				memcpy(ret->buf,icmd->buf,icmd->databytes);
				osprey_write_return(s,(struct o1ka_ret*)ret);
				free(ret);
				break;
			}
			case O1KA_SET_INT: {
				struct o1ka_cmd_set_int *sicmd = (struct o1ka_cmd_set_int*)cmd;
				struct o1ka_ret_set_int	siret;
				int res=-1;

				switch (sicmd->what) {
				case O1KA_INPUT_PORT:
					res=oti_audio_set_record_port(sicmd->audiofd,(unsigned int*)&(sicmd->value));
					break;
				default:
					fprintf(stderr,"OSPREY_SET_INT: bad what %d\n",sicmd->what);
					break;
				}
				siret.value = sicmd->value;
				siret.res = res;
				osprey_write_return(s,(struct o1ka_ret*)&siret);
				break;
			}
			case O1KA_GET_INT: {
				struct o1ka_cmd_get_int *sicmd = (struct o1ka_cmd_get_int*)cmd;
				struct o1ka_ret_get_int	siret;
				int res=-1;

				switch (sicmd->what) {
				case O1KA_INPUT_PORT:
					res=oti_audio_get_record_port(sicmd->audiofd,(unsigned int*)&(siret.value));
					break;
				default:
					fprintf(stderr,"OSPREY_GET_INT: bad what %d\n",sicmd->what);
					break;
				}
				siret.res = res;
				osprey_write_return(s,(struct o1ka_ret*)&siret);
				break;
			}
			case O1KA_SET_DOUBLE: {
				struct o1ka_cmd_set_double *sicmd = (struct o1ka_cmd_set_double*)cmd;
				struct o1ka_ret_set_double	siret;
				int res=-1;

				switch (sicmd->what) {
				case O1KA_GAIN:
					res = oti_audio_set_record_gain(sicmd->audiofd,&(sicmd->value));
					break;
				case O1KA_VOLUME:
					res = oti_audio_set_play_gain(sicmd->audiofd,&(sicmd->value));
					break;
				default:
					fprintf(stderr,"OSPREY_SET_DOUBLE: bad what %d\n",sicmd->what);
					break;
				}
				siret.value = sicmd->value;
				siret.res = res;
				osprey_write_return(s,(struct o1ka_ret*)&siret);
				break;
			}
			case O1KA_GET_DOUBLE: {
				struct o1ka_cmd_get_double *sicmd = (struct o1ka_cmd_get_double*)cmd;
				struct o1ka_ret_get_double siret;
				int res=-1;

				switch (sicmd->what) {
				case O1KA_GAIN:
					res = oti_audio_get_record_gain(sicmd->audiofd,&(siret.value));
					break;
				case O1KA_VOLUME:
					res = oti_audio_get_play_gain(sicmd->audiofd,&(siret.value));
					break;
				default:
					fprintf(stderr,"OSPREY_GET_INT: bad what %d\n",sicmd->what);
					break;
				}
				siret.res = res;
				osprey_write_return(s,(struct o1ka_ret*)&siret);
				break;
			}
			default: {
				struct o1ka_ret ret;
				fprintf(stderr,"Bad Osprey Command %d\n",cmd->cmd);
				ret.ret = O1KA_FAILED;
				ret.addbytes = 0;
				osprey_write_return(s,(struct o1ka_ret*)&ret);
				break;
			}
			}
			free(cmd);
		}
	}
	return NULL;
}

static thread_t osprey_thread=0;

void
osprey_open(void) {
	if (ospreyusecnt++)
		return;
	if (-1==thr_create(
		NULL,		/* allocated by system */
		NULL,		/* 1 MB */
		osprey_main,	/* start start function */
		NULL,		/* args */
		0,		/* flags, THR_* */
		&osprey_thread	/* thread id */
	)) {
		perror("thr_create osprey_thread");
		exit(1);
	}
}

void
osprey_close() {
	if (--ospreyusecnt)
		return;
	if (-1==thr_kill(osprey_thread,SIGTERM)) {
		perror("thr_kill osprey_thread");
	}
	close(osprey_socket);
	unlink("/tmp/.o1k0");
}
