#ifndef __OSPREY_H
#define __OSPREY_H

/* 
 * Command transfer structure.
 * ->	INT command INT bytes
 * 	... optional stuff
 * <-	{ BYTE result; INT addbytes; } BYTE[addbytes]
 */

#define O1KA_OK		0
#define O1KA_FAILED	1

struct o1ka_cmd {
	int	cmd;
	int	addbytes;
};

struct o1ka_ret {
	int	ret;
	int	addbytes;
};

/* Open Osprey Audio.
 * In:	Nothing [ filename? ]
 * Out:	BYTE result, {INT audiofiledesc | INT errno }
 */
#define O1KA_OPEN	1 

struct o1ka_cmd_open {
	struct o1ka_cmd cmd;
	/* no additional things */
};

struct o1ka_ret_open {
	struct o1ka_ret	ret;
	int		audiofd;
};

/* Close Osprey Audio.
 * In:	INT audiofiledesc
 * Out:	BYTE result
 */
#define O1KA_CLOSE	2

struct o1ka_cmd_close {
	struct o1ka_cmd	cmd;
	int		audiofd;
	/* no additional stuff */
};

struct o1ka_ret_close {
	struct o1ka_ret	ret;
};

/* Read from Osprey.
 * In:	INT audiofilesdesc,INT nr of bytes to read.
 * Out:	BYTE result+ {INT nr; BYTE[nr] bytes}
 */
#define O1KA_READ	3

struct o1ka_cmd_read {
	struct o1ka_cmd	cmd;
	int		audiofd;
	int		byteswanted;
};

struct o1ka_ret_read {
	struct o1ka_ret	ret;
	int		bytesread;
	char		buf[1];
};

/* Write to Osprey. 
 * In:	INT audiofiledesc,INT nr of bytes to write, BYTE[nr] bytes 
 * Out:	BYTE result
 */
#define O1KA_WRITE	4
struct o1ka_cmd_write {
	struct o1ka_cmd	cmd;
	int		audiofd;
	int		byteswanted;
	unsigned char	buf[1]; /* buffer starts here. */
};

struct o1ka_ret_write {
	struct o1ka_ret	ret;
	int		byteswritten;
};

/* Set Info
 * In:	INT audiofiledesc, INFOstruct
 * Out: nothing
 */
#define O1KA_SET_INFO	5
struct o1ka_cmd_setinfo {
	struct o1ka_cmd	cmd;
	int		audiofd;
	audio_info_t	info;
};

struct o1ka_ret_setinfo {
	struct o1ka_ret	ret;
};

/* Set Play Config
 * In:	INT audiofiledesc, Audio_hdr
 * Out: nothing
 */
#define O1KA_SET_PLAY_CONFIG	6
struct o1ka_cmd_set_play_config {
	struct o1ka_cmd	cmd;
	int		audiofd;
	Audio_hdr	hdr;
};

struct o1ka_ret_set_play_config {
	struct o1ka_ret	ret;
};

/* Set Record Config
 * In:	INT audiofiledesc, Audio_hdr
 * Out: nothing
 */
#define O1KA_SET_RECORD_CONFIG	7
struct o1ka_cmd_set_record_config {
	struct o1ka_cmd	cmd;
	int		audiofd;
	Audio_hdr	hdr;
};

struct o1ka_ret_set_record_config {
	struct o1ka_ret	ret;
};

/* IOCTL
 * In:	INT audiofiledesc ,INT ioctlcmd, INT databytes, BYTE[databytes]
 * Out: BYTE[databytes]
 */
#define O1KA_IOCTL		10
struct o1ka_cmd_ioctl {
	struct	o1ka_cmd	cmd;
	int			audiofd;
	int			ioctlcmd;
	int			databytes;
	char			buf[1];
};

struct o1ka_ret_ioctl {
	struct	o1ka_ret	ret;
	char			buf[1];
};

/* SET INT 
 * In:	INT audiofd, INT what, INT value
 * Out: INT modifiedvalue
 */
#define O1KA_SET_INT		11

#define O1KA_INPUT_PORT	1

struct o1ka_cmd_set_int {
	struct	o1ka_cmd	cmd;
	int			audiofd;
	int			what;
	int			value;
};

struct o1ka_ret_set_int {
	struct	o1ka_cmd	cmd;
	int			res;
	int			value;
};

/* GET INT 
 * In:	INT audiofd, INT what
 * Out: INT value
 */
#define O1KA_GET_INT		12
struct o1ka_cmd_get_int {
	struct	o1ka_cmd	cmd;
	int			audiofd;
	int			what;
};

struct o1ka_ret_get_int {
	struct	o1ka_cmd	cmd;
	int			res;
	int			value;
};

/* SET DOUBLE 
 * In:	INT audiofd, INT what, DOUBLE value
 * Out: DOUBLE modifiedvalue
 */
#define O1KA_SET_DOUBLE		13

#define O1KA_GAIN	1
#define O1KA_VOLUME	2

struct o1ka_cmd_set_double {
	struct	o1ka_cmd	cmd;
	int			audiofd;
	int			what;
	double			value;
};

struct o1ka_ret_set_double {
	struct	o1ka_cmd	cmd;
	int			res;
	double			value;
};

/* GET DOUBLE 
 * In:	INT audiofd, INT what
 * Out: DOUBLE value
 */
#define O1KA_GET_DOUBLE		14
struct o1ka_cmd_get_double {
	struct	o1ka_cmd	cmd;
	int			audiofd;
	int			what;
};

struct o1ka_ret_get_double {
	struct	o1ka_cmd	cmd;
	int			res;
	double			value;
};

#endif
