/* blablabla...
*/
#ifndef lint
static char rcsid[] =
    "@(#) $Header: /home/cip/91/snbehler/vic.FAU/src/RCS/output-plx.cc,v 1.3 1997/12/10 01:40:22 snbehler Exp snbehler $ (LBL)";
#endif

#include <stdlib.h>
#include <sys/types.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "output-plx.h"

#define Sr_DEBUG_not_now
// could also be defined below when output-relevant methods come....

#ifdef Sr_DEBUG
#define DTEXT(x) fprintf(stderr, "PlxOutputAssistor: %s\n", x);
#else
#define DTEXT(x)
#endif

static PlxOutputDevice plx_output;

PlxOutputAssistor::PlxOutputAssistor( const char* opdev) :Renderer(FT_JPEG) {
	OutputDev = (char*)opdev;
	/* We set Scale-up to enabled as default. */
	// XXX not nice to use the path directly...
	Tcl::instance().evalf(".%s.frame.v.buttons.ext invoke", OutputDev);
	window_ = 0;
	PAoutput_ = 0;
}

int
PlxOutputAssistor::consume(const VideoFrame* vf) {
	//DTEXT("consume()");

#define TRY_IT_was_successful_for_jpeg_of_course
#ifdef TRY_IT
		int hue, saturation, contrast, brightness;

		Tk_Window tk = window_->tkwin();
		Display *dpy = Tk_Display(tk);
		GC gc = Tk_GetGC(tk, 0, 0);

		XPlxVideoValueQuery(dpy, Tk_WindowId(tk), gc,
					&saturation, &contrast, &hue, &brightness);
		if(brightness<240) brightness+=1;
		else brightness = 10;
#ifdef Sr_DEBUG
		fprintf(stdout, "Setting brightness  to %d\n", brightness);
#endif /* Sr_DEBUG */
		XPlxVideoValueLoad(dpy, Tk_WindowId(tk), gc,
				   saturation, contrast, hue, brightness);
#endif /* TRY_IT */
	// do nothing. Plx-Device gets everything from the WINDOW
	return 0;
}

void
PlxOutputAssistor::disableOutput() {
	if(!window_) {
		DTEXT("disableOutput()");
		PAoutput_ = 0;
		return;
	}
	disableOutput(window_->name());
}

void
PlxOutputAssistor::disableOutput(const char* which) {

#ifdef Sr_DEBUG
	fprintf(stdout, "PlxOutputAssistor::disableOutput(%s)\n", which);
#endif /* Sr_DEBUG */

	if(!PAoutput_ || !window_ || !window_->tkwin()|| strcmp(window_->name(), which)!=0)
		return;
	Tcl& tcl = Tcl::instance();
	tcl.evalf("bind %s <Destroy>  {}", window_->name());
	tcl.evalf("bind %s <Expose>  {}", window_->name());
	XPlxVideoOutputSelect(
		Tk_Display(window_->tkwin()),
		Tk_WindowId(window_->tkwin()),
		outputGC_, PLX_IO_OFF,
		0, 0, 0);
		/*
			PLX_PAL, PLX_COMP, PLX_RGB24);
		*/
	DTEXT("Output-toggled OFF");
	// ok, we detached the renderer, now we should Re-attach....
	char *tmp = (char*)tcl.rds("win_list", outputSrc->name());
	char *toCheck;
	char *tmp2 = strdup(tmp);
	VideoWindow* winToTest;
	toCheck = strtok(tmp2, " ");
	while(1) {
		if(!toCheck) 
			break;
		// XXX Easier??
		winToTest= VideoWindow::lookup(toCheck);
		if(strcmp(winToTest->name(), window_->name())!=0) {
			tmp = (char*)tcl.rds("win_target", toCheck);
			if(!tmp) {
#ifdef Sr_DEBUG
				fprintf(stdout, "****** DEBUG: attach_renderer  %s %s\n",outputSrc->name(), winToTest->name());
#endif /* Sr_DEBUG */
				tcl.evalf("attach_renderer  %s %s", outputSrc->name(), winToTest->name());
			}
#ifdef Sr_DEBUG
			else {
				fprintf(stdout, "****** DEBUG: attach_renderer  %s %s NOT\n",outputSrc->name(), winToTest->name());
			}
#endif /* Sr_DEBUG */
		}
		toCheck = strtok(NULL, " ");
	}
	window_ = 0;
	// OutputDevice && Select disablen!
	PlxOutputDevice *od = (PlxOutputDevice*)TclObject::lookup(OutputDev);
	if(OutputDev && od && od->isActive()) {
		PAoutput_ = 0; // see comment below && Controlflow
		char *buf = new char[255];
		sprintf(buf, ".%s.frame.v.tn.stamp.video", OutputDev);
		if(buf) {
			char *target = (char*)Tcl::instance().rds("win_target", buf);
			if(target)
				Tcl::instance().evalf("extout_shutdown %s .%s", OutputDev, OutputDev);
		}
		delete[] buf;
	}
	PAoutput_ = 0; // We can't set this to 0 above because of isActive().
	free(tmp2);
}

PlxOutputAssistor::~PlxOutputAssistor() {
	if(window_)
		disableOutput(window_->name());
	PlxOutputDevice *od = (PlxOutputDevice*)TclObject::lookup(OutputDev);
	if(od) {
		od->removeOutput();
	}
}

int
PlxOutputAssistor::startOutput(VideoWindow* win_) {
	if(!win_) return 0;
	window_ = win_;
	/* ignored it. 640/525 and 768/625 doesn't sound good.
	** as visible rows/lines....
		plx_IO* plxio_;
		outputGC_ = XCreateGC(Tk_Display(window_->tkwin()), Tk_WindowId(Tk_Parent(window_->tkwin())), 0, NULL); 
		plxio_ = XPlxQueryConfig(Tk_Display(window_->tkwin()), Tk_WindowId(Tk_Parent(window_->tkwin())), outputGC_);
		plx_IO_list *il;
		il = plxio_->outputs;
	*/

	outputGC_ = XCreateGC(Tk_Display(window_->tkwin()), Tk_WindowId(Tk_Parent(window_->tkwin())), 0, NULL); 
	XPlxVideoOutputSelect(
		Tk_Display(window_->tkwin()),
		Tk_WindowId(Tk_Parent(window_->tkwin())),
		outputGC_, PLX_OUTPUT_0,
	// XXX
		PLX_PAL, PLX_COMP, PLX_RGB24);
	//PLX_NTSC, PLX_COMP, PLX_RGB24);
	// I don't get that value from the VideoWindow-class, sigh
	int hoff = (Tk_Width(Tk_Parent(window_->tkwin())) - window_->width())>>1;
	if(doScale_) {
		XPlxVideoScaleOutput(Tk_Display(window_->tkwin()),
			Tk_WindowId(Tk_Parent(window_->tkwin())),
			outputGC_,
			hoff, 0, window_->width(), window_->height(),
			0, PAL_HEIGHT-525, PAL_WIDTH, PAL_HEIGHT
		);
	} else {
		XPlxVideoScaleOutput(Tk_Display(window_->tkwin()),
			Tk_WindowId(Tk_Parent(window_->tkwin())),
			outputGC_,
			hoff, 0, window_->width(), window_->height(),
			0, PAL_HEIGHT-525, window_->width(), window_->height()
		);
	}
	PAoutput_ = 1;
	Tcl& tcl = Tcl::instance();
	tcl.evalf("bind %s <Destroy>  { %s disable %s }", window_->name(), name(), window_->name());
	tcl.evalf("bind %s <Expose>  { %s expose %s }", window_->name(), name(), window_->name());
	return 1;
}

void
PlxOutputAssistor::scanAndStart(){
	Tcl& tcl = Tcl::instance();
	char* tmp = (char*)tcl.rds("win_list", outputSrc->name());
	char *toCheck;
	char *tmp2 = strdup(tmp);
	VideoWindow * win, *winToTest;
	toCheck = strtok(tmp2, " ");
	win = NULL;
	while(1) {
		if(!toCheck) 
			break;
		if(!win)  {
			win= VideoWindow::lookup(toCheck);
		} else {
			// Since we assume that the 3 to 4 aspect of width and height is
			// given for each window. If this isn't given (halfsize of parallax-grabber, e.g.
			// we need the area. we also assume the same quality for the same size.
			// If the Vic-Tool ever supports different quality for windows of same size & source
			// this must be changed.
			winToTest= VideoWindow::lookup(toCheck);
			if( winToTest->width() > win->width() ) {
				// Detach all other windows to spare time :) important esp. if we have a non-HW-dekoder!
#ifdef Sr_DEBUG
				fprintf(stdout, "****** DEBUG: detach_renderer  %s %s\n",outputSrc->name(), win->name());
#endif /* Sr_DEBUG */
				if(tcl.rds("win_target", win->name()))
					tcl.evalf("detach_renderer  %s %s",outputSrc->name(), win->name());
				win = winToTest;
			}
		}
		toCheck = strtok(NULL, " ");
	}

	startOutput(win);
	free(tmp2);
}


int
PlxOutputAssistor::command(int argc, const char*const* argv){

	Tcl& tcl = Tcl::instance();
	const char* tmp = tcl.rds("extout_src", OutputDev);

	// XXX
	// Perhaps remove the mini-frame from the decoder-list?! (detach)....

	// const char *tmp3 = tcl.rds("extout_target", OutputDev);

	if (argc == 3) {
		if (strcmp(argv[1], "scale") == 0) {
			// If we get a scale, we start the output.
			// It doesn't make much difference to start
			// it earlier/ at another place

			setScale(atoi(argv[2]));
			outputSrc = (Source*)TclObject::lookup(tmp);
			scanAndStart();
			return (TCL_OK);
		}
		if (strcmp(argv[1], "disable") == 0) {
			DTEXT("DISABLE!");
			disableOutput(argv[2]);
			return (TCL_OK);
		}
		if (strcmp(argv[1], "expose") == 0) {
			scanAndStart();
			return (TCL_OK);
		}
	}
	return (Renderer::command(argc, argv));
}


#define Sr_DEBUG_not_now

#ifdef Sr_DEBUG
#define DTEXT(x) fprintf(stderr, "PlxOutputDevice: %s\n", x);
#else
#define DTEXT(x)
#endif

#define PLXDEVNAME "/dev/fbs/tvtwo0" // multiple devices would be nice,
								 // but neither Parallax nor we
								 // support it currently

/* Overloads OutputDevice::inception()
** to check if a Parallax-Card a) exists and b) has an external output
*/
void
PlxOutputDevice::inception() {

	if(access(PLXDEVNAME, F_OK) == -1) {
		return;
	}
	Tcl::instance().evalf("lappend outputDeviceList %s", name());
}


void
PlxOutputDevice::removeOutput() {
	DTEXT("::removeOutput()");
	poa_ = 0;
}

PlxOutputDevice::~PlxOutputDevice() {
}

int
PlxOutputDevice::command(int argc, const char*const* argv) {
	Tcl& tcl = Tcl::instance();

#ifdef Sr_DEBUG
	if(argc==2)
		fprintf(stdout, "PlxOutputDevice::command: %d  %s %s\n", argc, argv[0], argv[1] );
	else if(argc==3)
		fprintf(stdout, "PlxOutputDevice::command: %d  %s %s %s\n", argc, argv[0], argv[1], argv[2] );
#endif /* Sr_DEBUG */
	if(argc==3) {
		// XXX renderer
		if (strcmp(argv[1], "assistor") == 0) {
			if(!poa_) {
				poa_ = new PlxOutputAssistor(name());
				// Parallax-card don't like grabbing/compressing and outputting at the same time
				char* currentGrabber = (char*)tcl.rds("V", "grabber");
				if(currentGrabber) {
					tcl.evalc("$videoDevice nickname");
					char *devNick = tcl.result();
					// XXX no transmit != released
					if(devNick && !strcmp(devNick, "parallax")) {
						tcl.evalc("open_dialog \"Warning: There's a running/not released Parallax-Grabber\nwhich can lead to unexpected results if you use the Parallax-output at the same time!\"");
					}
				}
				tcl.result(poa_->name());
			} else { // shouldn't be reached
				// done when deleted
				//poa_->disableOutput();
				delete poa_;
				poa_ = new PlxOutputAssistor(name());
				tcl.result(poa_->name());
			}
			return (TCL_OK);
		}
	} else if (argc == 2) {
		if (strcmp(argv[1], "nickname") == 0) {
				tcl.result(nickname_);
				return (TCL_OK);
		}
	}
	return (OutputDevice::command(argc, argv));
}
