#
# Copyright (c) 1993-1995 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the Computer Systems
#	Engineering Group at Lawrence Berkeley Laboratory.
# 4. Neither the name of the University nor of the Laboratory may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

#
# This file contains stubs for building any grabber specific controls.
# If a device is named foo, then create define build.foo proc here
# that builds UI.  If this proc doesn't exist, then it will be ommitted.
# If there are multiple devices with the same name, they should be
# called foo-1, foo-2, etc. and you'll only need build.foo
#


proc build.parallax w {
global logoButton, setPlxInput, V
	set f [smallfont]
	label $w.title -text "Parallax-Grabber"
	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.hl -relief flat

	label $w.f.hl.label  -font $f -text "Hue" -anchor s 

	label $w.f.hl.slabel -font $f -text "Saturation" -anchor s

	pack  $w.f.hl.label $w.f.hl.slabel -side left -fill x -expand 1

	frame $w.f.h -relief flat

	scale $w.f.h.hscale -orient horizontal -width 12 \
		-relief groove -showvalue 1 -from 0 -to 255 \
		-variable parallaxHue \
		-command "grabber hue"
	scale $w.f.h.sscale -orient horizontal -width 12 -relief groove \
		-showvalue 1 -from 0 -to 255 \
		-variable parallaxSat \
		-command "grabber saturation"
	pack  $w.f.h.hscale $w.f.h.sscale -side left -fill x -expand 1

	frame $w.f.ll -relief flat

	label $w.f.ll.clabel -font $f -text "Contrast" -anchor s

	label $w.f.ll.blabel -font $f -text "Brightness" -anchor s
	pack  $w.f.ll.clabel $w.f.ll.blabel -side left -fill x -expand 1

	frame $w.f.l  -relief flat

	scale $w.f.l.cscale   -orient horizontal -width 12 -relief groove \
		-showvalue 1 -from 0 -to 255 \
		-variable parallaxCon \
		-command "grabber contrast"

	scale $w.f.l.bscale -orient horizontal -width 12 -relief groove \
		-showvalue 1 -from 0 -to 255 \
		-variable parallaxBri \
		-command "grabber brightness"
	pack  $w.f.l.cscale $w.f.l.bscale  -side left -fill x -expand 1

	frame $w.f.qb  -relief flat

	set logoButton $w.f.qb.logo
	button $w.f.qb.logo -text "Logo" \
		-relief raised -command "grabber set_logo"\
		-anchor w -font $f \
		-width 5 -state normal -highlightthickness 0

	button $w.f.qb.halfbutton -font $f -text Halfsize -width 9 -command "grabber half"

	radiobutton $w.f.qb.b0 -text "PAL" -command "grabber setInput PAL" \
		-padx 0 -pady 0 \
		-anchor w -variable setPlxInput -font $f -relief flat -value "PAL"
	radiobutton $w.f.qb.b1 -text "NTSC" -command "grabber setInput NTSC" \
		-padx 0 -pady 0 \
		-anchor w -variable setPlxInput -font $f -relief flat -value "NTSC"
	radiobutton $w.f.qb.b2 -text "SECAM" -command "grabber setInput SECAM" \
		-padx 0 -pady 0 \
		-anchor w -variable setPlxInput -font $f -relief flat -value "SECAM"
	pack $w.f.qb.b0 $w.f.qb.b1 $w.f.qb.b2 -fill x -side left


	pack  $w.f.qb.logo $w.f.qb.halfbutton -side left -fill x 

	frame $w.f.rb  -relief flat

	label $w.f.rb.label -text "Remote-Display:" -font $f -anchor w -padx 1m
# XXX
	mk.entry $w.f.rb grabber [option get . localPlxDisplay $V(class)]
	$w.f.rb.entry configure -state disabled -foreground gray60
	$w.f.rb.label configure -foreground gray60

	pack  $w.f.rb.label $w.f.rb.entry -side left -fill x -expand 1
	pack  $w.f.hl $w.f.h $w.f.ll $w.f.l $w.f.qb $w.f.rb -fill x -padx 1m


	frame $w.f.lr  -relief flat
	frame $w.f.lr.x  -relief flat
	frame $w.f.lr.y  -relief flat

	label $w.f.lr.x.label -text "Capture-Window-Size: " -font $f -anchor w -padx 1m
	mk.entry $w.f.lr.x grabber  ""
	$w.f.lr.x.entry configure -width 6

	label $w.f.lr.y.label -text "x" -font $f -anchor e 
	mk.entry $w.f.lr.y grabber ""
	$w.f.lr.y.entry configure -width 6

	checkbutton $w.f.lr.stillbutton -text "Not Live" \
		-relief raised -command "grabber sendStill" \
		-anchor e -variable stillButtonState -font $f \
		-state normal -highlightthickness 0

	pack  $w.f.lr.x.label -side left -padx 1m
	pack  $w.f.lr.x.entry -side left 
	pack  $w.f.lr.y.label -side left 
	pack  $w.f.lr.y.entry -side left 
	pack  $w.f.lr.x $w.f.lr.y $w.f.lr -side left 
	pack  $w.f.lr.stillbutton -side left 


	pack  $w.title $w.f -fill x -expand 1

	$w.f.h.hscale set 128
	$w.f.h.sscale set 128
	$w.f.l.cscale set 128
	$w.f.l.bscale set 128
	set logoButtonState 0
	set stillButtonState 0
	set setPlxInput "PAL"
}


proc build.xil_SlicVideo w {
	# .menu.xil
	set f [smallfont]
	label $w.title -text "XIL SLIC Grabber"
	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.left
	frame $w.f.right

	frame $w.f.left.hue -relief flat
	label $w.f.left.hue.name -font $f -anchor e -text "Hue"
	scale $w.f.left.hue.scale -orient horizontal -width 15 \
			   -variable xilHue \
		           -relief groove -showvalue 1 -from -128 -to 127 \
                           -command "grabber set HUE"
	pack $w.f.left.hue.name $w.f.left.hue.scale -fill x -expand 1

	frame $w.f.left.lbrightness -relief flat
	label $w.f.left.lbrightness.name -font $f -anchor e -text "Luma Brightness"
	scale $w.f.left.lbrightness.scale -orient horizontal -width 15 \
			   -variable xilLumaBrightness \
		           -relief groove -showvalue 1 -from 0 -to 255 \
                           -command "grabber set LUMA_BRIGHTNESS"
	pack $w.f.left.hue $w.f.left.lbrightness.name $w.f.left.lbrightness.scale -fill x -expand 1


	frame $w.f.left.lcontrast -relief flat
	label $w.f.left.lcontrast.name -font $f -anchor e -text "Luma Contrast"
	scale $w.f.left.lcontrast.scale -orient horizontal -width 15 \
		           -relief groove -showvalue 1 -from 0 -to 127 \
			   -variable xilLumaContrast \
			   -command "grabber set LUMA_CONTRAST"
	pack $w.f.left.lcontrast.name $w.f.left.lcontrast.scale -fill x -expand 1

	pack $w.f.left.lbrightness $w.f.left.lcontrast -side left -fill x -expand 1 


	frame $w.f.right.csat -relief flat
	label $w.f.right.csat.name -font $f -anchor e -text "Chroma Saturation"
	scale $w.f.right.csat.scale -orient horizontal -width 15 \
		           -relief groove -showvalue 1 -from 0 -to 127 \
			   -variable xilChromaSaturation \
                           -command "grabber set CHROMA_SATURATION"
	pack $w.f.right.csat.name $w.f.right.csat.scale -fill x -expand 1

	frame $w.f.right.cgain -relief flat
	label $w.f.right.cgain.name -font $f -anchor e -text "Chroma Gain"
	scale $w.f.right.cgain.scale -orient horizontal -width 15 \
		           -relief groove -showvalue 1 -from 0 -to 255 \
			   -variable xilChromaGain \
                          -command "grabber set CHROMA_GAIN"
	pack $w.f.right.cgain.name $w.f.right.cgain.scale -fill x -expand 1


	pack $w.f.right.csat $w.f.right.cgain -side left -fill x -expand 1 

	pack $w.f.left $w.f.right -fill y -side top -expand 1

	pack $w.title $w.f -fill x -expand 1

	set xcsat [resource chroma_saturation]
	if { $xcsat != 0 } {
		$w.f.right.csat.scale set $xcsat
	} else {
		$w.f.right.csat.scale set 64
	}
	set xcgain [resource chroma_gain]
	if { $xcgain != 0} {
		$w.f.right.cgain.scale  set $xcgain
	} else {
		$w.f.right.csat.scale set 44
	}
	set xlcontrast [resource luma_contrast]
	if { $xlcontrast != 0 }  {
		$w.f.left.lcontrast.scale  set $xlcontrast
	} else {
		$w.f.left.lcontrast.scale  set 64
	}
	set xlbrightness [resource luma_brightness]
	if { $xlbrightness }  {
		$w.f.left.lbrightness.scale  set $xlbrightness
	} else {
		$w.f.left.lbrightness.scale  set 128
	}
}

proc build.xil_Osprey_1k w {
	# .menu.xil
	set f [smallfont]
	label $w.title -text "XIL Grabber"
	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.left
	frame $w.f.right

	frame $w.f.left.hue -relief flat
	label $w.f.left.hue.name -font $f -anchor e -text "Hue"
	scale $w.f.left.hue.scale -orient horizontal -width 15 \
			   -variable xilHue \
		           -relief groove -showvalue 1 -from -128 -to 127 \
                           -command "grabber set HUE"
	pack $w.f.left.hue.name $w.f.left.hue.scale -fill x -expand 1

#	frame $w.f.left.chromau -relief flat
#	label $w.f.left.chromau.name -font $f -anchor e -text "Gain U"
#	scale $w.f.left.chromau.scale -orient horizontal -width 15 \
#		           -relief groove -showvalue 1 -from -256 -to 255 \
#			   -variable xilChromaGainU \
#                          -command "grabber set CHROMA_GAIN_U"
#	pack $w.f.left.chromau.name $w.f.left.chromau.scale -fill x -expand 1
#
#	frame $w.f.left.chromav -relief flat
#	label $w.f.left.chromav.name -font $f -anchor e -text "Gain V"
#	scale $w.f.left.chromav.scale -orient horizontal -width 15 \
#		           -relief groove -showvalue 1 -from -256 -to 255 \
#			   -variable xilChromaGainV \
#                           -command "grabber set CHROMA_GAIN_V"
#	pack $w.f.left.chromav.name $w.f.left.chromav.scale -fill x -expand 1

	frame $w.f.left.saturation -relief flat
	label $w.f.left.saturation.name -font $f -anchor e -text "Saturation"
	scale $w.f.left.saturation.scale -orient horizontal -width 15 \
		           -relief groove -showvalue 1 -from -256 -to 255 \
			   -variable xilSaturation \
                          -command "grabber set SATURATION"
	pack $w.f.left.saturation.name $w.f.left.saturation.scale -fill x -expand 1


#	pack $w.f.left.hue $w.f.left.chromau $w.f.left.chromav -side left -fill y -expand 1 
	pack $w.f.left.hue $w.f.left.saturation -side left -fill x -expand 1 

	frame $w.f.right.brightness -relief flat
	label $w.f.right.brightness.name  -font $f -anchor e -text "Brightness"
	scale $w.f.right.brightness.scale -orient horizontal -width 15 \
		           -relief groove -showvalue 1 -from -128 -to 127 \
			   -variable xilBrightness \
			-command "grabber set BRIGHTNESS"
	pack $w.f.right.brightness.name $w.f.right.brightness.scale -fill x -expand 1

	frame $w.f.right.contrast -relief flat
	label $w.f.right.contrast.name -font $f -anchor e -text "Contrast"
	scale $w.f.right.contrast.scale -orient horizontal -width 15 \
			   -variable xilContrast \
		           -relief groove -showvalue 1 -from -256 -to 255 \
                           -command "grabber set CONTRAST"
	pack  $w.f.right.contrast.name $w.f.right.contrast.scale -fill x -expand 1

#	pack $w.f.right.brightness $w.f.right.contrast -side left -fill y -expand 1 
	pack $w.f.right.brightness $w.f.right.contrast -side left -fill x -expand 1 

	pack $w.f.left $w.f.right -fill y -side top -expand 1

	pack $w.title $w.f -fill x -expand 1

	set xhue [resource hue]
	if { $xhue != 0 } {
		$w.f.left.hue.scale set $xhue
	}
	set xchromau [resource chromau]
	if { $xchromau != 0} {
		$w.f.left.chromau.scale  set $xchromau
	}
	set xsaturation [resource saturation]
	if { $xsaturation != 0 }  {
		$w.f.left.saturation.scale  set $xsaturation
	}
	set xchromav [resource chromav]
	if { $xchromav }  {
		$w.f.left.chromav.scale  set $xchromav
	}
	set xbrightness [resource brightness]
	if { $xbrightness!=0 } {
		$w.f.right.brightness.scale  set $xbrightness
	}
	set xcontrast [resource contrast]
	if { $xcontrast != 0 } {
		$w.f.right.contrast.scale  set $xcontrast
	}
}


proc build.slicvideo w {
	set f [smallfont]
	label $w.title -text "Grabber"
	frame $w.f -relief sunken -borderwidth 2

        frame $w.f.h -relief flat
 
        label $w.f.h.label  -font $f -anchor e -text "Hue"
 
        scale $w.f.h.scale -orient horizontal -width 12 -length 20 \
                           -relief groove -showvalue 0 -from -128 -to 127 \
                            -command "grabber set HUE"
        pack  $w.f.h.label $w.f.h.scale -side left -fill x -expand 1


	frame $w.f.ll -relief flat 
       
	label $w.f.ll.label  -font $f -text "Luma" -anchor s
       
	label $w.f.ll.clabel -font $f -text "Contrast" -anchor s
      
	label $w.f.ll.blabel -font $f -text "Brightness" -anchor s
	pack  $w.f.ll.clabel $w.f.ll.label $w.f.ll.blabel \
			     -side left -fill x -expand 1

	frame $w.f.l  -relief flat
       
	scale $w.f.l.cscale   -orient horizontal -width 12 -relief groove \
                              -showvalue 0 -from 0 -to 127 \
                              -command "grabber set LUMA_CONTRAST"
       
	scale $w.f.l.bscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 255 \
                            -command "grabber set LUMA_BRIGHTNESS"
	pack  $w.f.l.cscale $w.f.l.bscale  -side left -fill x -expand 1

	frame $w.f.cl  -relief flat

	label $w.f.cl.label  -font $f -text "Chroma" -anchor n
       
	label $w.f.cl.glabel -font $f -text "Gain" -anchor n
       
	label $w.f.cl.slabel -font $f -text "Saturation" -anchor n
	pack  $w.f.cl.glabel $w.f.cl.label $w.f.cl.slabel \
			     -side left -fill x -expand 1

	frame $w.f.c -relief flat
       
	scale $w.f.c.gscale -orient horizontal -width 12 -relief groove \
                             -showvalue 0 -from 0 -to 255 \
                             -command "grabber set CHROMA_GAIN"
       
	scale $w.f.c.sscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 127 \
                            -command "grabber set CHROMA_SATURATION"
	pack  $w.f.c.gscale $w.f.c.sscale -side left -fill x -expand 1

     
	pack  $w.f.h $w.f.ll $w.f.l $w.f.c $w.f.cl \
	      -fill x -expand 1 -padx 1m 


	pack $w.title $w.f -fill x -expand 1

	$w.f.h.scale  set 0
	$w.f.l.cscale set 64
	$w.f.l.bscale set 128
	$w.f.c.gscale set 44
	$w.f.c.sscale set 64
}

proc build.still w {

    set f [smallfont]
    label $w.title -text "Grabber"

    frame $w.f -relief sunken -borderwidth 2
    
    label $w.f.label  -font $f -anchor e -text "File"
    
    mk.entry $w.f set.still.frame "frame"

    pack $w.title $w.f -fill x -expand 1
    
    pack $w.f.label -side left 
    pack $w.f.entry -side left -fill x -expand 1
}

proc set.still.frame {w s } {
    global lastDevice
    $lastDevice file $s
}

proc build.qcam {w} {
    global qcamwindow

    set f [smallfont]
    label $w.title -text "Grabber"

    frame $w.f -relief sunken -borderwidth 2

    frame $w.f.s -relief flat

    frame $w.f.s.l -relief flat
    label $w.f.s.l.bright -font $f -anchor w -text "Brightness"
    label $w.f.s.l.cont   -font $f -anchor w -text "Contrast"
    label $w.f.s.l.wbal   -font $f -anchor w -text "White balance"
    pack  $w.f.s.l.bright $w.f.s.l.cont $w.f.s.l.wbal \
	-side top -fill x -expand 1

    frame $w.f.s.s -relief flat
    scale $w.f.s.s.bright -orient horizontal -width 12 \
		          -relief groove -showvalue 0 -from 1 -to 254 \
                          -command "grabber set BRIGHT"
    scale $w.f.s.s.cont   -orient horizontal -width 12 \
                          -relief groove -showvalue 0 \
                          -from 0 -to 1.0 -resolution 0.002 \
                          -command "grabber contrast"

    frame $w.f.s.s.wbal -relief flat
    scale $w.f.s.s.wbal.scale  -orient horizontal -width 12 \
                             -relief groove -showvalue 0 -from 1 -to 254 \
                             -command "grabber set WBAL"
    button $w.f.s.s.wbal.button -font $f -text Auto \
	-command "grabber set WBAL auto"
    pack  $w.f.s.s.wbal.scale $w.f.s.s.wbal.button \
	-side left -fill x -expand 1

    pack $w.f.s.s.bright $w.f.s.s.cont $w.f.s.s.wbal \
        -side top -fill x -expand 1

    pack $w.f.s.l $w.f.s.s -side left -fill x -expand 1

    frame $w.f.bpp -relief flat
    label $w.f.bpp.label  -font $f -anchor w -text "Pixel depth"
    radiobutton $w.f.bpp.bpp4 -font $f -text "4-bit" \
	-variable qcambpp -value 4 -command "grabber set BPP 4"
    radiobutton $w.f.bpp.bpp6 -font $f -text "6-bit" \
	-variable qcambpp -value 6 -command "grabber set BPP 6"
    pack $w.f.bpp.label $w.f.bpp.bpp4 $w.f.bpp.bpp6 \
	-side left -fill x -expand 1

    pack  $w.f.s $w.f.bpp \
	 -fill x -expand 1 -padx 1m 

    pack $w.title $w.f -fill x -expand 1

    set qcamwindow(setbright) "$w.f.s.s.bright set"
    set qcamwindow(setcont) "$w.f.s.s.cont set"
    set qcamwindow(setwbal) "$w.f.s.s.wbal.scale set"
    set qcamwindow(setbpp) "set qcambpp"
}


proc build.cosmo w {
	global fieldButtonState
	set fieldButtonState 0

	set f [smallfont]
	label $w.title -text "Grabber"

	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.b -relief flat
       
# would be ok, if we could change the button text after pressing, hm.
	button $w.f.b.fieldbutton -text "Toggle send both/even fields" \
		-relief raised -command "grabber even_only" \
		-anchor w -font $f \
		-width 20 \
		-state normal -highlightthickness 0

# would be nice if this would work, sigh
#	checkbutton $w.f.b.fieldbutton -text "Send both fields" \
#	-relief raised -command "grabber even_only $fieldButtonState" \
#	-anchor w -variable fieldButtonState -font $f \
#	-state normal -highlightthickness 0

	pack  $w.f.b $w.f.b.fieldbutton -fill x -padx 1m
	pack $w.title $w.f -fill x -expand 1
}
