#include "os.h"
#include "test/test.h"


DeclareTask(H1);
DeclareTask(H2);
DeclareTask(H3);
DeclareAlarm(A1);
DeclareCounter(C1);

TEST_MAKE_OS_MAIN(StartOS(0))

TASK(H1) {
	test_trace('a');
	ActivateTask(H3);
	test_trace('b');
	TerminateTask();
}

TASK(H2) {
	test_trace('2');
	ChainTask(H1);
}

TASK(H3) {
	test_trace('3');
	TerminateTask();
}

PreIdleHook() {
	/* The testcase has finished, check the output */
	static int cycle_count;
	cycle_count++;

	if (cycle_count > 3) {
		test_trace_assert("2ab32ab32ab3");
		test_finish();
		ShutdownMachine();
	}
}
