/* Kernel entry function */
ENTRY(_start)

OUTPUT_FORMAT(elf32-i386)

SECTIONS {
    /* Memory-mapped CGA buffer */
    _scga = 0xB8000;
    cga_buffer = 0xB8000;
    _ecga = 0xB8FFF;

    /* Set kernel start address */
    . = 0x100000;

    /* Code and readonly data */
    .text : {
        /* fill gaps with int3 opcode to detect invalid jumps */
        FILL(0xcc)

        /* multiboot header */
        multiboot_header = .;
        KEEP (*(".rodata.multiboot"))

        /* fixed address for IRQ handlers */
        . = 0x1000;

        /* common text (always accessible) */
        _stext_common = .;

        /* start of FAIL* allowed code region */
        _stext_fail = .;

        /* IRQ Handlers */
        KEEP (*(".text.irqhandlers*")) /* ASM */
        *(".text.irq_handler*") /* C */
        *(".text.isrs*") /* C */
        *(".text.isr_*") /* C */
        KEEP (*(".text.idt")) /* ASM */
        . += 16; /* padding after data, workaround for import-trace */

        /* constructors */
        . = ALIGN(8);
        PROVIDE(__CTORS_START = .);
        KEEP (*(.ctors*))
        KEEP (*(.init_array*))
        PROVIDE(__CTORS_END = .);

        /* constructor code */
        _stext_constructors = .;
        KEEP (*(".text.startup"))
        _etext_constructors = .;

        /* common symbols */
        _stext_common_syms = .;
        *("_GLOBAL__I_a")
        _etext_common_syms = .;

        . += 16; /* padding after data, workaround for import-trace */

        /* compiler code (arithmetic routines...) */
        "*libgcc*.a:" ( ".text" )

        /* anonymous read only data (probably strings) */
        /* cannot be separated by source, so put it here */
        _srodata_an = .;
        *(".rodata..L*")
        _erodata_an = .;

        . += 16; /* padding after data, workaround for import-trace */

        /* architectural code and rodata */
        /* TODO: move startup code out of common text? */
        _stext_arch = .;
        *(".text._Z*4arch*")
        *(".rodata._Z*4arch*")
        "*libarch*.a:" ( ".text*" )
        "*libarch*.a:" ( ".rodata*" )
        _etext_arch = .;

        /* FAIL* tests */
        _stext_fail_test = .;
        *(".text._Z*4fail*")
        *(".rodata._Z*4fail*")
        _etext_fail_test = .;

        _etext_common = .;

        /* operating system code and data */
        . = ALIGN(4096);
        _stext_os = .;
        *(".text._Z*2os*")
        *(".rodata._Z*2os*")
        *(".text.__OS_*")
        *(".rodata.__OS_*")
        _etext_os = .;

        /* task code regions */
        . = ALIGN(4096);
        _stext_task1 = .;
        *(".text.OSEKOS_TASK_Handler12");
        *(".rodata.OSEKOS_TASK_Handler12");
        *(".text.OSEKOS_TerminateTask__ABB461");
        *(".rodata.OSEKOS_TerminateTask__ABB461");
        _etext_task1 = .;
        
        . = ALIGN(4096);
        _stext_task2 = .;
        *(".text.OSEKOS_TASK_Handler13");
        *(".rodata.OSEKOS_TASK_Handler13");
        *(".text.OSEKOS_TerminateTask__ABB465");
        *(".rodata.OSEKOS_TerminateTask__ABB465");
        _etext_task2 = .;
        
        . = ALIGN(4096);
        _stext_task3 = .;
        *(".text.OSEKOS_TASK_Handler11");
        *(".rodata.OSEKOS_TASK_Handler11");
        *(".text.OSEKOS_ActivateTask__ABB451");
        *(".rodata.OSEKOS_ActivateTask__ABB451");
        *(".text.OSEKOS_ActivateTask__ABB455");
        *(".rodata.OSEKOS_ActivateTask__ABB455");
        *(".text.OSEKOS_TerminateTask__ABB457");
        *(".rodata.OSEKOS_TerminateTask__ABB457");
        _etext_task3 = .;
        
        

        /* */
        . = ALIGN(4096);
        _etext_fail = .;
        _stext_fail_allowed = .;
        *(".text.test")

        /* remaining code */
        . = ALIGN(0x1000);
        _stext = .;
        *(".text*")
        _etext = .;

        /* remaining rodata */
        /*. = ALIGN(0x1000);*/
        _srodata = .;
        *(".rodata*")
        _erodata = .;

        _etext_fail_allowed = .;
    }

    /* Page tables and directories */
    .rodata.paging ALIGN(0x1000) : {
        _spaging = .;
        KEEP (*(".paging*"));
        _epaging = .;
    }


    /* Data and Stacks */
    . = 0x200000;
    .data : {
        _sstack = .; /* to include TSS in FAIL tests, TODO: better placing*/

        /* TSS at known address */
        _stss = .;
        tss = .;
        . += 104;
        _etss = .;

        /* Stacks */
        . = ALIGN(4096);
        /*_sstack = .;*/

        _sstack_os = .;
        *(".startup_stack")
        _estack_os = .;

        . = ALIGN(4096);
        _sstack = .;

        _sstack_os = .;
        *(".kernel_stack")
        _estack_os = .;

        . = ALIGN(4096);
        _sstack_task1 = .;
        *(".data.Handler12_stack");
        _estack_task1 = .;
        
        . = ALIGN(4096);
        _sstack_task2 = .;
        *(".data.Handler13_stack");
        _estack_task2 = .;
        
        . = ALIGN(4096);
        _sstack_task3 = .;
        *(".data.Handler11_stack");
        _estack_task3 = .;
        
        

        _estack = .;

        /* Data */
        _sdata_fail = .;

        _sdata_os = .;
        *(".data._Z*2os*")
        *(".data._Z*4arch*")
        _edata_os = .;

        *(".data._Z*4fail*")

        . = ALIGN(4096);
        _sdata_task1 = .;
        *(".data.Handler12*");
        _edata_task1 = .;
        
        . = ALIGN(4096);
        _sdata_task2 = .;
        *(".data.Handler13*");
        _edata_task2 = .;
        
        . = ALIGN(4096);
        _sdata_task3 = .;
        *(".data.Handler11*");
        _edata_task3 = .;
        
        

        . = ALIGN(4096);
        _sdata = .;
        *(".data*")
        *(COMMON);
        _edata = .;
        _edata_fail = .;
    }

    /* Memory-mapped I/O APIC */
    _sioapic = 0xFEC00000;
    ioapic = 0xFEC00000;
    _eioapic = 0xFEC00FFF;

    /* Memory-mapped Local APIC */
    _slapic = 0xFEE00000;
    lapic = 0xFEE00000;
    _elapic = 0xFEE00FFF;

    /* Get rid of unnecessary GCC bits */
    /DISCARD/ : {
        *(.comment)
        *(.eh_frame)
        *(.note.gnu.build-id)
    }
}
