/* Kernel entry function */
ENTRY(_start)

OUTPUT_FORMAT(elf32-i386)

SECTIONS {

    /DISCARD/ : {
        *(".text.inlined*")
        *(.comment)
        *(.eh_frame)
        *(.note.gnu.build-id)
    }

    /* Memory-mapped CGA buffer */
    _scga = 0xB8000;
    cga_buffer = 0xB8000;
    _ecga = 0xB8FFF;

    /* Set kernel start address */
    . = 0x100000;

    /* Code and readonly data */
    .text : {
        /* fill gaps with int3 opcode to detect invalid jumps */
        FILL(0xcc)

        /* multiboot header */
        multiboot_header = .;
        KEEP (*(".rodata.multiboot"))

        /* fixed address for IRQ handlers */
        . = 0x1000;

        /* start of interrupt handlers */
        _stext_irqs = .;

        /* IRQ Handlers */
        KEEP (*(".text.irqhandlers*")) /* ASM */
        KEEP (*(".text.irq_handler*")) /* C */
        *(".text.isrs*") /* C */
        *(".text.isr_*") /* C */
        KEEP (*(".text.OSEKOS_ISR*"))
        KEEP (*(".text.idt")) /* ASM */

        /* sysenter handler */
        KEEP (*(".text.sysenter_syscall"))

        _etext_irqs = .;
        . += 16; /* padding after data, workaround for import-trace */

        /* startup code */
        . = ALIGN(4096);
        _stext_startup = .;

        /* constructors */
        . = ALIGN(4096);
        PROVIDE(__CTORS_START = .);
        KEEP (*(.ctors*))
        KEEP (*(.init_array*))
        PROVIDE(__CTORS_END = .);

        /* constructor code */
        _stext_constructors = .;
        KEEP (*(".text.startup"))
        _etext_constructors = .;

        *(".text._Z*4arch*")
        *(".text.arch_startup")
        *(".text.run_constructors")
        *(".text.init_generic")
        _etext_startup = .;

        /* common text (always accessible) */
        . = ALIGN(4096);
        _stext_common = .;

        /* common symbols */
        _stext_common_syms = .;
        *("_GLOBAL__I_a")
        _etext_common_syms = .;

        . += 16; /* padding after data, workaround for import-trace */

        /* compiler code (arithmetic routines...) */
        "*libgcc*.a:" ( ".text" )

        /* anonymous read only data (probably strings) */
        /* cannot be separated by source, so put it here */
        _srodata_an = .;
        *(".rodata..L*")
        _erodata_an = .;

        /* architectural rodata */
        _srodata_arch = .;
        *(".rodata._Z*4arch*")
        _erodata_arch = .;

        . += 16; /* padding after data, workaround for import-trace */

        _etext_common = .;

        /* operating system code and data */
        . = ALIGN(4096);
        _stext_os = .;
        *(".text._Z*2os*")
        KEEP (*(".text.__OS_*"))

        _srodata_os = .;
        *(".rodata._Z*2os*")
        *(".rodata.__OS_*")
        _erodata_os = .;

        _etext_os = .;

        /* task code regions */
        . = ALIGN(4096);
        _stext_application = .;
        . = ALIGN(4096);
        _stext_task1 = .;
        *(".text.OSEKOS_TASK_Handler11");
        *(".rodata.OSEKOS_TASK_Handler11");
        *(".text.OSEKOS_kickoff__ABB38");
        *(".rodata.OSEKOS_kickoff__ABB38");
        *(".text.OSEKOS_ActivateTask__ABB41");
        *(".rodata.OSEKOS_ActivateTask__ABB41");
        *(".text.OSEKOS_ActivateTask__ABB45");
        *(".rodata.OSEKOS_ActivateTask__ABB45");
        *(".text.OSEKOS_TerminateTask__ABB49");
        *(".rodata.OSEKOS_TerminateTask__ABB49");
        _etext_task1 = .;
        
        . = ALIGN(4096);
        _stext_task2 = .;
        *(".text.OSEKOS_TASK_Handler12");
        *(".rodata.OSEKOS_TASK_Handler12");
        *(".text.OSEKOS_kickoff__ABB535");
        *(".rodata.OSEKOS_kickoff__ABB535");
        *(".text.OSEKOS_TerminateTask__ABB538");
        *(".rodata.OSEKOS_TerminateTask__ABB538");
        _etext_task2 = .;
        
        . = ALIGN(4096);
        _stext_task3 = .;
        *(".text.OSEKOS_TASK_Handler13");
        *(".rodata.OSEKOS_TASK_Handler13");
        *(".text.OSEKOS_kickoff__ABB232");
        *(".rodata.OSEKOS_kickoff__ABB232");
        *(".text.OSEKOS_TerminateTask__ABB235");
        *(".rodata.OSEKOS_TerminateTask__ABB235");
        _etext_task3 = .;
        
        
        _etext_application = .;

        /* remaining code and rodata*/
        . = ALIGN(0x1000);
        _stext = .;
        *(".text*")
        *(".rodata*")
        _etext = .;
    }

    /* Page tables and directories */
    .rodata.paging ALIGN(0x1000) : {
        _spaging = .;
        KEEP (*(".paging*"));
        _epaging = .;
    }


    /* Data and Stacks */
    . = 0x200000;
    .data : {
        /* TSS at known address */
        _stss = .;
        tss = .;
        . += 104;
        _etss = .;

        /* Stacks */
        . = ALIGN(4096);
        _sstack = .;

        _sstack_os = .;
        KEEP (*(".startup_stack"))
        KEEP (*(".kernel_stack"))
        _estack_os = .;

        . = ALIGN(4096);
        _sstack_task1 = .;
        *(".data.Handler11_stack");
        _estack_task1 = .;
        
        . = ALIGN(4096);
        _sstack_task2 = .;
        *(".data.Handler12_stack");
        _estack_task2 = .;
        
        . = ALIGN(4096);
        _sstack_task3 = .;
        *(".data.Handler13_stack");
        _estack_task3 = .;
        
        

        _estack = .;

        /* Data */
        . = ALIGN(4096);
        _sdata_os = .;
        *(".data._Z*2os*")
        _edata_os = .;

        . = ALIGN(4096);
        _sdata_arch = .;
        *(".data._Z*4arch*")
        _edata_arch = .;

        . = ALIGN(4096);
        _sdata_task1 = .;
        *(".data.Handler11*");
        _edata_task1 = .;
        
        . = ALIGN(4096);
        _sdata_task2 = .;
        *(".data.Handler12*");
        _edata_task2 = .;
        
        . = ALIGN(4096);
        _sdata_task3 = .;
        *(".data.Handler13*");
        _edata_task3 = .;
        
        

        . = ALIGN(4096);
        _sdata = .;
        *(".data*")
        *(COMMON);
        _edata = .;
    }

    /* Memory-mapped I/O APIC */
    _sioapic = 0xFEC00000;
    ioapic = 0xFEC00000;
    _eioapic = 0xFEC00FFF;

    /* Memory-mapped Local APIC */
    _slapic = 0xFEE00000;
    lapic = 0xFEE00000;
    _elapic = 0xFEE00FFF;
}
