#include "os.h"
#include "tcb.h"
#include "os/scheduler/task.h"
#include "os/scheduler/tasklist.h"
#include "os/scheduler/scheduler.h"
#include "os/alarm.h"
#include "machine.h"

extern "C" void  OSEKOS_TASK_CopterControlTask();
extern "C" void  OSEKOS_TASK_CopterControlWatchdogTask();
extern "C" void  OSEKOS_TASK_FlightControlActuateTask();
extern "C" void  OSEKOS_TASK_FlightControlAttitudeTask();
extern "C" void  OSEKOS_TASK_FlightControlTask();
extern "C" void  OSEKOS_TASK_MavlinkSendTask();
extern "C" void  OSEKOS_TASK_SignalGatherFinishedTask();
extern "C" void  OSEKOS_TASK_SignalGatherInitiateTask();
extern "C" void  OSEKOS_TASK_SignalGatherTimeoutTask();
extern "C" void  OSEKOS_TASK_SignalProcessingActuateTask();
extern "C" void  OSEKOS_TASK_SignalProcessingAttitudeTask();
extern "C" void  __OS_StartOS_dispatch(int);
extern "C" void  StartOS(int);
extern "C" void  __OS_ASTSchedule(int);
extern "C" void inlinehint OSEKOS_kickoff__ABB29();
extern "C" void  __OS_syscall_OSEKOS_GetResource__ABB30();
extern "C" StatusType inlinehint OSEKOS_GetResource__ABB30(ResourceType);
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB35();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB35(TaskType);
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB37();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB37(TaskType);
extern "C" void  __OS_syscall_OSEKOS_ReleaseResource__ABB39();
extern "C" StatusType inlinehint OSEKOS_ReleaseResource__ABB39(ResourceType);
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB40();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB40();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB101(TaskType);
extern "C" void inlinehint OSEKOS_kickoff__ABB143();
extern "C" void inlinehint OSEKOS_kickoff__ABB47();
extern "C" void  __OS_syscall_OSEKOS_GetResource__ABB48();
extern "C" StatusType inlinehint OSEKOS_GetResource__ABB48(ResourceType);
extern "C" void  __OS_syscall_OSEKOS_ReleaseResource__ABB49();
extern "C" StatusType inlinehint OSEKOS_ReleaseResource__ABB49(ResourceType);
extern "C" void  __OS_syscall_OSEKOS_ChainTask__ABB50();
extern "C" StatusType inlinehint OSEKOS_ChainTask__ABB50(TaskType);
extern "C" void inlinehint OSEKOS_kickoff__ABB58();
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB59();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB59(TaskType);
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB60();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB60(TaskType);
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB61();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB61(TaskType);
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB62();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB62();
extern "C" void inlinehint OSEKOS_kickoff__ABB87();
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB88();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB88();
extern "C" void inlinehint OSEKOS_kickoff__ABB64();
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB65();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB65();
extern "C" void inlinehint OSEKOS_kickoff__ABB67();
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB68();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB68();
extern "C" void inlinehint OSEKOS_kickoff__ABB75();
extern "C" void  OSEKOS_SuspendAllInterrupts__ABB76();
extern "C" void  OSEKOS_ResumeAllInterrupts__ABB77();
extern "C" void  __OS_syscall_OSEKOS_CancelAlarm__ABB79();
extern "C" StatusType inlinehint OSEKOS_CancelAlarm__ABB79(AlarmType);
extern "C" void  __OS_syscall_OSEKOS_SetRelAlarm__ABB80(TickType,TickType);
extern "C" StatusType inlinehint OSEKOS_SetRelAlarm__ABB80(AlarmType,TickType,TickType);
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB82();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB82();
extern "C" void inlinehint OSEKOS_kickoff__ABB52();
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB53();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB53();
extern "C" void inlinehint OSEKOS_kickoff__ABB144();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB102(TaskType);
extern "C" void inlinehint OSEKOS_kickoff__ABB142();
extern "C" void inlinehint OSEKOS_kickoff__ABB42();
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB43();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB43(TaskType);
extern "C" void  __OS_syscall_OSEKOS_ActivateTask__ABB44();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB44(TaskType);
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB45();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB45();
extern "C" void inlinehint OSEKOS_kickoff__ABB70();
extern "C" void  __OS_syscall_OSEKOS_GetResource__ABB71();
extern "C" StatusType inlinehint OSEKOS_GetResource__ABB71(ResourceType);
extern "C" void  __OS_syscall_OSEKOS_ReleaseResource__ABB72();
extern "C" StatusType inlinehint OSEKOS_ReleaseResource__ABB72(ResourceType);
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB73();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB73();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB100(TaskType);
extern "C" void inlinehint OSEKOS_kickoff__ABB145();
extern "C" void inlinehint OSEKOS_kickoff__ABB55();
extern "C" void  __OS_syscall_OSEKOS_TerminateTask__ABB56();
extern "C" StatusType inlinehint OSEKOS_TerminateTask__ABB56();
extern "C" void inlinehint OSEKOS_kickoff__ABB84();
extern "C" StatusType inlinehint OSEKOS_ActivateTask__ABB85(TaskType);
void  __OS_HOOK_PreIdleHook();
extern "C" void  OSEKOS_ISR_MavlinkRecvHandler();

namespace os{
    extern UnencodedCounter OS_C1_counter;
    extern UnencodedAlarm<&OS_C1_counter> OS_SignalGatherAlarm_alarm;
    extern UnencodedAlarm<&OS_C1_counter> OS_FlightControlAlarm_alarm;
    extern UnencodedAlarm<&OS_C1_counter> OS_CopterControlWatchdogAlarm_alarm;
}

namespace arch{
    extern void * OS_CopterControlTask_stackptr;
    extern void * OS_CopterControlWatchdogTask_stackptr;
    extern void * OS_FlightControlActuateTask_stackptr;
    extern void * OS_FlightControlAttitudeTask_stackptr;
    extern void * OS_FlightControlTask_stackptr;
    extern void * OS_MavlinkSendTask_stackptr;
    extern void * OS_SignalGatherFinishedTask_stackptr;
    extern void * OS_SignalGatherInitiateTask_stackptr;
    extern void * OS_SignalGatherTimeoutTask_stackptr;
    extern void * OS_SignalProcessingActuateTask_stackptr;
    extern void * OS_SignalProcessingAttitudeTask_stackptr;
    extern void * const OS_stackptrs[];
    extern const arch::TCB OS_CopterControlTask_tcb;
    extern const arch::TCB OS_CopterControlWatchdogTask_tcb;
    extern const arch::TCB OS_FlightControlActuateTask_tcb;
    extern const arch::TCB OS_FlightControlAttitudeTask_tcb;
    extern const arch::TCB OS_FlightControlTask_tcb;
    extern const arch::TCB OS_MavlinkSendTask_tcb;
    extern const arch::TCB OS_SignalGatherFinishedTask_tcb;
    extern const arch::TCB OS_SignalGatherInitiateTask_tcb;
    extern const arch::TCB OS_SignalGatherTimeoutTask_tcb;
    extern const arch::TCB OS_SignalProcessingActuateTask_tcb;
    extern const arch::TCB OS_SignalProcessingAttitudeTask_tcb;
    extern const TCB * const OS_tcbs[];
}

extern "C" uint8_t CopterControlTask_stack[4096];
extern "C" uint8_t CopterControlWatchdogTask_stack[4096];
extern "C" uint8_t FlightControlActuateTask_stack[4096];
extern "C" uint8_t FlightControlAttitudeTask_stack[4096];
extern "C" uint8_t FlightControlTask_stack[4096];
extern "C" uint8_t MavlinkSendTask_stack[4096];
extern "C" uint8_t SignalGatherFinishedTask_stack[4096];
extern "C" uint8_t SignalGatherInitiateTask_stack[4096];
extern "C" uint8_t SignalGatherTimeoutTask_stack[4096];
extern "C" uint8_t SignalProcessingActuateTask_stack[4096];
extern "C" uint8_t SignalProcessingAttitudeTask_stack[4096];
namespace os{
    namespace tasks{
        extern const os::scheduler::Task OS_CopterControlTask_task;
        extern const os::scheduler::Task OS_CopterControlWatchdogTask_task;
        extern const os::scheduler::Task OS_FlightControlActuateTask_task;
        extern const os::scheduler::Task OS_FlightControlAttitudeTask_task;
        extern const os::scheduler::Task OS_FlightControlTask_task;
        extern const os::scheduler::Task OS_MavlinkSendTask_task;
        extern const os::scheduler::Task OS_SignalGatherFinishedTask_task;
        extern const os::scheduler::Task OS_SignalGatherInitiateTask_task;
        extern const os::scheduler::Task OS_SignalGatherTimeoutTask_task;
        extern const os::scheduler::Task OS_SignalProcessingActuateTask_task;
        extern const os::scheduler::Task OS_SignalProcessingAttitudeTask_task;
    }
}


namespace os{
    UnencodedCounter OS_C1_counter(50000, 1, 1);
    UnencodedAlarm<&OS_C1_counter> OS_SignalGatherAlarm_alarm(os::tasks::OS_SignalGatherInitiateTask_task, true, 10, 30);
    UnencodedAlarm<&OS_C1_counter> OS_FlightControlAlarm_alarm(os::tasks::OS_FlightControlTask_task, true, 13, 90);
    UnencodedAlarm<&OS_C1_counter> OS_CopterControlWatchdogAlarm_alarm(os::tasks::OS_CopterControlWatchdogTask_task, false, 0, 0);
}

namespace arch{
    void * OS_CopterControlTask_stackptr;
    void * OS_CopterControlWatchdogTask_stackptr;
    void * OS_FlightControlActuateTask_stackptr;
    void * OS_FlightControlAttitudeTask_stackptr;
    void * OS_FlightControlTask_stackptr;
    void * OS_MavlinkSendTask_stackptr;
    void * OS_SignalGatherFinishedTask_stackptr;
    void * OS_SignalGatherInitiateTask_stackptr;
    void * OS_SignalGatherTimeoutTask_stackptr;
    void * OS_SignalProcessingActuateTask_stackptr;
    void * OS_SignalProcessingAttitudeTask_stackptr;
    void * const OS_stackptrs[] = {/* 0 */ &startup_sp, /* 1 */ &OS_CopterControlTask_stackptr, /* 2 */ &OS_CopterControlWatchdogTask_stackptr, /* 3 */ &OS_FlightControlActuateTask_stackptr, /* 4 */ &OS_FlightControlAttitudeTask_stackptr, /* 5 */ &OS_FlightControlTask_stackptr, /* 6 */ &OS_MavlinkSendTask_stackptr, /* 7 */ &OS_SignalGatherFinishedTask_stackptr, /* 8 */ &OS_SignalGatherInitiateTask_stackptr, /* 9 */ &OS_SignalGatherTimeoutTask_stackptr, /* 10 */ &OS_SignalProcessingActuateTask_stackptr, /* 11 */ &OS_SignalProcessingAttitudeTask_stackptr};
    constexpr const arch::TCB OS_CopterControlTask_tcb(&OSEKOS_TASK_CopterControlTask, CopterControlTask_stack, OS_CopterControlTask_stackptr, 4096);
    constexpr const arch::TCB OS_CopterControlWatchdogTask_tcb(&OSEKOS_TASK_CopterControlWatchdogTask, CopterControlWatchdogTask_stack, OS_CopterControlWatchdogTask_stackptr, 4096);
    constexpr const arch::TCB OS_FlightControlActuateTask_tcb(&OSEKOS_TASK_FlightControlActuateTask, FlightControlActuateTask_stack, OS_FlightControlActuateTask_stackptr, 4096);
    constexpr const arch::TCB OS_FlightControlAttitudeTask_tcb(&OSEKOS_TASK_FlightControlAttitudeTask, FlightControlAttitudeTask_stack, OS_FlightControlAttitudeTask_stackptr, 4096);
    constexpr const arch::TCB OS_FlightControlTask_tcb(&OSEKOS_TASK_FlightControlTask, FlightControlTask_stack, OS_FlightControlTask_stackptr, 4096);
    constexpr const arch::TCB OS_MavlinkSendTask_tcb(&OSEKOS_TASK_MavlinkSendTask, MavlinkSendTask_stack, OS_MavlinkSendTask_stackptr, 4096);
    constexpr const arch::TCB OS_SignalGatherFinishedTask_tcb(&OSEKOS_TASK_SignalGatherFinishedTask, SignalGatherFinishedTask_stack, OS_SignalGatherFinishedTask_stackptr, 4096);
    constexpr const arch::TCB OS_SignalGatherInitiateTask_tcb(&OSEKOS_TASK_SignalGatherInitiateTask, SignalGatherInitiateTask_stack, OS_SignalGatherInitiateTask_stackptr, 4096);
    constexpr const arch::TCB OS_SignalGatherTimeoutTask_tcb(&OSEKOS_TASK_SignalGatherTimeoutTask, SignalGatherTimeoutTask_stack, OS_SignalGatherTimeoutTask_stackptr, 4096);
    constexpr const arch::TCB OS_SignalProcessingActuateTask_tcb(&OSEKOS_TASK_SignalProcessingActuateTask, SignalProcessingActuateTask_stack, OS_SignalProcessingActuateTask_stackptr, 4096);
    constexpr const arch::TCB OS_SignalProcessingAttitudeTask_tcb(&OSEKOS_TASK_SignalProcessingAttitudeTask, SignalProcessingAttitudeTask_stack, OS_SignalProcessingAttitudeTask_stackptr, 4096);
    const TCB * const OS_tcbs[] = {/* 0 */ 0, /* 1 */ &OS_CopterControlTask_tcb, /* 2 */ &OS_CopterControlWatchdogTask_tcb, /* 3 */ &OS_FlightControlActuateTask_tcb, /* 4 */ &OS_FlightControlAttitudeTask_tcb, /* 5 */ &OS_FlightControlTask_tcb, /* 6 */ &OS_MavlinkSendTask_tcb, /* 7 */ &OS_SignalGatherFinishedTask_tcb, /* 8 */ &OS_SignalGatherInitiateTask_tcb, /* 9 */ &OS_SignalGatherTimeoutTask_tcb, /* 10 */ &OS_SignalProcessingActuateTask_tcb, /* 11 */ &OS_SignalProcessingAttitudeTask_tcb};
}

uint8_t CopterControlTask_stack[4096];
uint8_t CopterControlWatchdogTask_stack[4096];
uint8_t FlightControlActuateTask_stack[4096];
uint8_t FlightControlAttitudeTask_stack[4096];
uint8_t FlightControlTask_stack[4096];
uint8_t MavlinkSendTask_stack[4096];
uint8_t SignalGatherFinishedTask_stack[4096];
uint8_t SignalGatherInitiateTask_stack[4096];
uint8_t SignalGatherTimeoutTask_stack[4096];
uint8_t SignalProcessingActuateTask_stack[4096];
uint8_t SignalProcessingAttitudeTask_stack[4096];
namespace os{
    namespace tasks{
        constexpr const os::scheduler::Task OS_CopterControlTask_task(1, 2, true, arch::OS_CopterControlTask_tcb);
        constexpr const os::scheduler::Task OS_CopterControlWatchdogTask_task(2, 1, false, arch::OS_CopterControlWatchdogTask_tcb);
        constexpr const os::scheduler::Task OS_FlightControlActuateTask_task(3, 6, true, arch::OS_FlightControlActuateTask_tcb);
        constexpr const os::scheduler::Task OS_FlightControlAttitudeTask_task(4, 5, true, arch::OS_FlightControlAttitudeTask_tcb);
        constexpr const os::scheduler::Task OS_FlightControlTask_task(5, 4, false, arch::OS_FlightControlTask_tcb);
        constexpr const os::scheduler::Task OS_MavlinkSendTask_task(6, 3, true, arch::OS_MavlinkSendTask_tcb);
        constexpr const os::scheduler::Task OS_SignalGatherFinishedTask_task(7, 11, true, arch::OS_SignalGatherFinishedTask_tcb);
        constexpr const os::scheduler::Task OS_SignalGatherInitiateTask_task(8, 10, true, arch::OS_SignalGatherInitiateTask_tcb);
        constexpr const os::scheduler::Task OS_SignalGatherTimeoutTask_task(9, 9, true, arch::OS_SignalGatherTimeoutTask_tcb);
        constexpr const os::scheduler::Task OS_SignalProcessingActuateTask_task(10, 8, true, arch::OS_SignalProcessingActuateTask_tcb);
        constexpr const os::scheduler::Task OS_SignalProcessingAttitudeTask_task(11, 7, true, arch::OS_SignalProcessingAttitudeTask_tcb);
    }
}

using namespace os;
using namespace arch;
using namespace os::tasks;

// ****************************************************************
// TaskList Implementation
// ****************************************************************

namespace os { namespace scheduler {

// only needed for Tasklist constructor comma placement
class UnencodedTaskListStatic {};

/* Simpler array based task queue */
struct TaskList : public UnencodedTaskListStatic {
    typedef uint8_t id_t;
    typedef uint8_t prio_t;

    // encoded task priorities
    
    prio_t CopterControlTask;
    prio_t CopterControlWatchdogTask;
    prio_t FlightControlActuateTask;
    prio_t FlightControlAttitudeTask;
    prio_t FlightControlTask;
    prio_t MavlinkSendTask;
    prio_t SignalGatherFinishedTask;
    prio_t SignalGatherInitiateTask;
    prio_t SignalGatherTimeoutTask;
    prio_t SignalProcessingActuateTask;
    prio_t SignalProcessingAttitudeTask;
    

    // idle task id/priority
    static constexpr id_t idle_id = 0;
    static constexpr prio_t idle_prio = 0;

    
    TaskList() : UnencodedTaskListStatic() , CopterControlTask(0), CopterControlWatchdogTask(0), FlightControlActuateTask(0), FlightControlAttitudeTask(0), FlightControlTask(0), MavlinkSendTask(0), SignalGatherFinishedTask(0), SignalGatherInitiateTask(0), SignalGatherTimeoutTask(0), SignalProcessingActuateTask(0), SignalProcessingAttitudeTask(0) {}

    forceinline bool isSuspended(const prio_t id) {
    
        if(id == 1) {
            return CopterControlTask == 0;
        } else if(id == 2) {
            return CopterControlWatchdogTask == 0;
        } else if(id == 3) {
            return FlightControlActuateTask == 0;
        } else if(id == 4) {
            return FlightControlAttitudeTask == 0;
        } else if(id == 5) {
            return FlightControlTask == 0;
        } else if(id == 6) {
            return MavlinkSendTask == 0;
        } else if(id == 7) {
            return SignalGatherFinishedTask == 0;
        } else if(id == 8) {
            return SignalGatherInitiateTask == 0;
        } else if(id == 9) {
            return SignalGatherTimeoutTask == 0;
        } else if(id == 10) {
            return SignalProcessingActuateTask == 0;
        } else if(id == 11) {
            return SignalProcessingAttitudeTask == 0;
        } else {
            assert(false);
            return false;
        }
    }

    /** Set priority of task id to prio **/
    forceinline void set(const prio_t id, const prio_t prio) {

         if(id == 1) {
             CopterControlTask = prio;
         } else if(id == 2) {
             CopterControlWatchdogTask = prio;
         } else if(id == 3) {
             FlightControlActuateTask = prio;
         } else if(id == 4) {
             FlightControlAttitudeTask = prio;
         } else if(id == 5) {
             FlightControlTask = prio;
         } else if(id == 6) {
             MavlinkSendTask = prio;
         } else if(id == 7) {
             SignalGatherFinishedTask = prio;
         } else if(id == 8) {
             SignalGatherInitiateTask = prio;
         } else if(id == 9) {
             SignalGatherTimeoutTask = prio;
         } else if(id == 10) {
             SignalProcessingActuateTask = prio;
         } else if(id == 11) {
             SignalProcessingAttitudeTask = prio;
         } else {
             assert(false);
         }
    }



    /** Set priority of task id to prio **/
    forceinline void increasePrio(const prio_t id, const prio_t prio) {
        
        if(id == 1) {
            if (CopterControlTask < prio)
                CopterControlTask = prio;
        } else if(id == 2) {
            if (CopterControlWatchdogTask < prio)
                CopterControlWatchdogTask = prio;
        } else if(id == 3) {
            if (FlightControlActuateTask < prio)
                FlightControlActuateTask = prio;
        } else if(id == 4) {
            if (FlightControlAttitudeTask < prio)
                FlightControlAttitudeTask = prio;
        } else if(id == 5) {
            if (FlightControlTask < prio)
                FlightControlTask = prio;
        } else if(id == 6) {
            if (MavlinkSendTask < prio)
                MavlinkSendTask = prio;
        } else if(id == 7) {
            if (SignalGatherFinishedTask < prio)
                SignalGatherFinishedTask = prio;
        } else if(id == 8) {
            if (SignalGatherInitiateTask < prio)
                SignalGatherInitiateTask = prio;
        } else if(id == 9) {
            if (SignalGatherTimeoutTask < prio)
                SignalGatherTimeoutTask = prio;
        } else if(id == 10) {
            if (SignalProcessingActuateTask < prio)
                SignalProcessingActuateTask = prio;
        } else if(id == 11) {
            if (SignalProcessingAttitudeTask < prio)
                SignalProcessingAttitudeTask = prio;
        } else {
            assert(false);
        }
    }

    template<typename TargetHint>
    forceinline void head(id_t& id, prio_t& prio) const {
        // start with idle id/priority
        id = idle_id;
        prio = idle_prio;



        
        
                if(TargetHint::CopterControlTask_is_possible && CopterControlTask > prio) {
                    prio = CopterControlTask;
                    id = 1;
                }
        
        
                if(TargetHint::CopterControlWatchdogTask_is_possible && CopterControlWatchdogTask > prio) {
                    prio = CopterControlWatchdogTask;
                    id = 2;
                }
        
        
                if(TargetHint::FlightControlActuateTask_is_possible && FlightControlActuateTask > prio) {
                    prio = FlightControlActuateTask;
                    id = 3;
                }
        
        
                if(TargetHint::FlightControlAttitudeTask_is_possible && FlightControlAttitudeTask > prio) {
                    prio = FlightControlAttitudeTask;
                    id = 4;
                }
        
        
                if(TargetHint::FlightControlTask_is_possible && FlightControlTask > prio) {
                    prio = FlightControlTask;
                    id = 5;
                }
        
        
                if(TargetHint::MavlinkSendTask_is_possible && MavlinkSendTask > prio) {
                    prio = MavlinkSendTask;
                    id = 6;
                }
        
        
                if(TargetHint::SignalGatherFinishedTask_is_possible && SignalGatherFinishedTask > prio) {
                    prio = SignalGatherFinishedTask;
                    id = 7;
                }
        
        
                if(TargetHint::SignalGatherInitiateTask_is_possible && SignalGatherInitiateTask > prio) {
                    prio = SignalGatherInitiateTask;
                    id = 8;
                }
        
        
                if(TargetHint::SignalGatherTimeoutTask_is_possible && SignalGatherTimeoutTask > prio) {
                    prio = SignalGatherTimeoutTask;
                    id = 9;
                }
        
        
                if(TargetHint::SignalProcessingActuateTask_is_possible && SignalProcessingActuateTask > prio) {
                    prio = SignalProcessingActuateTask;
                    id = 10;
                }
        
        
                if(TargetHint::SignalProcessingAttitudeTask_is_possible && SignalProcessingAttitudeTask > prio) {
                    prio = SignalProcessingAttitudeTask;
                    id = 11;
                }
        
        
    }

    forceinline void insert(const id_t& id, const prio_t& prio) {
        increasePrio(id, prio);
    }

    forceinline void remove(const id_t& id) {
        set(id, 0);
    }

    forceinline void promote(const id_t& id, const prio_t& newprio) {
        set(id, newprio);
    }
};

}; // scheduler
}; // os
namespace os {
namespace scheduler {

using namespace os::tasks;

 
 

template<bool Idle = true, bool CopterControlTask = true, bool CopterControlWatchdogTask = true, bool FlightControlActuateTask = true, bool FlightControlAttitudeTask = true, bool FlightControlTask = true, bool MavlinkSendTask = true, bool SignalGatherFinishedTask = true, bool SignalGatherInitiateTask = true, bool SignalGatherTimeoutTask = true, bool SignalProcessingActuateTask = true, bool SignalProcessingAttitudeTask = true>
struct SchedulerTargetHint {
    static const bool Idle_is_possible = Idle;
    static const bool CopterControlTask_is_possible = CopterControlTask;
             static const bool CopterControlWatchdogTask_is_possible = CopterControlWatchdogTask;
             static const bool FlightControlActuateTask_is_possible = FlightControlActuateTask;
             static const bool FlightControlAttitudeTask_is_possible = FlightControlAttitudeTask;
             static const bool FlightControlTask_is_possible = FlightControlTask;
             static const bool MavlinkSendTask_is_possible = MavlinkSendTask;
             static const bool SignalGatherFinishedTask_is_possible = SignalGatherFinishedTask;
             static const bool SignalGatherInitiateTask_is_possible = SignalGatherInitiateTask;
             static const bool SignalGatherTimeoutTask_is_possible = SignalGatherTimeoutTask;
             static const bool SignalProcessingActuateTask_is_possible = SignalProcessingActuateTask;
             static const bool SignalProcessingAttitudeTask_is_possible = SignalProcessingAttitudeTask;
             
};

struct Scheduler {
    os::scheduler::TaskList tlist;

    typedef uint8_t prio_t;
    typedef uint8_t id_t;

    prio_t current_prio;
    id_t current_task;

    static constexpr prio_t scheduler_prio = 12;

    template<typename TargetHint = SchedulerTargetHint<> >
    forceinline void Reschedule(void) {
        // OPTIMIZATION: do not reschedule if RES_SCHEDULER is taken
        if (current_prio != scheduler_prio) {
            // set current (=next) task from task list
            tlist.head<TargetHint>(current_task, current_prio);
        }

        // dispatch or enter idle
        // TODO: generated signature

        if(TargetHint::CopterControlTask_is_possible && current_task == OS_CopterControlTask_task.id) {
            if (OS_CopterControlTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_CopterControlTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_CopterControlTask_task);
        } else if(TargetHint::CopterControlWatchdogTask_is_possible && current_task == OS_CopterControlWatchdogTask_task.id) {
            if (OS_CopterControlWatchdogTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_CopterControlWatchdogTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_CopterControlWatchdogTask_task);
        } else if(TargetHint::FlightControlActuateTask_is_possible && current_task == OS_FlightControlActuateTask_task.id) {
            if (OS_FlightControlActuateTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_FlightControlActuateTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_FlightControlActuateTask_task);
        } else if(TargetHint::FlightControlAttitudeTask_is_possible && current_task == OS_FlightControlAttitudeTask_task.id) {
            if (OS_FlightControlAttitudeTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_FlightControlAttitudeTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_FlightControlAttitudeTask_task);
        } else if(TargetHint::FlightControlTask_is_possible && current_task == OS_FlightControlTask_task.id) {
            if (OS_FlightControlTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_FlightControlTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_FlightControlTask_task);
        } else if(TargetHint::MavlinkSendTask_is_possible && current_task == OS_MavlinkSendTask_task.id) {
            if (OS_MavlinkSendTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_MavlinkSendTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_MavlinkSendTask_task);
        } else if(TargetHint::SignalGatherFinishedTask_is_possible && current_task == OS_SignalGatherFinishedTask_task.id) {
            if (OS_SignalGatherFinishedTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_SignalGatherFinishedTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_SignalGatherFinishedTask_task);
        } else if(TargetHint::SignalGatherInitiateTask_is_possible && current_task == OS_SignalGatherInitiateTask_task.id) {
            if (OS_SignalGatherInitiateTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_SignalGatherInitiateTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_SignalGatherInitiateTask_task);
        } else if(TargetHint::SignalGatherTimeoutTask_is_possible && current_task == OS_SignalGatherTimeoutTask_task.id) {
            if (OS_SignalGatherTimeoutTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_SignalGatherTimeoutTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_SignalGatherTimeoutTask_task);
        } else if(TargetHint::SignalProcessingActuateTask_is_possible && current_task == OS_SignalProcessingActuateTask_task.id) {
            if (OS_SignalProcessingActuateTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_SignalProcessingActuateTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_SignalProcessingActuateTask_task);
        } else if(TargetHint::SignalProcessingAttitudeTask_is_possible && current_task == OS_SignalProcessingAttitudeTask_task.id) {
            if (OS_SignalProcessingAttitudeTask_task.preemptable == false) {
                // promote non-preemptable task to RES_SCHEDULER
                tlist.promote(OS_SignalProcessingAttitudeTask_task.id, scheduler_prio);
                current_prio = scheduler_prio;
            }
            Dispatcher::Dispatch(OS_SignalProcessingAttitudeTask_task);
        } else if(TargetHint::Idle_is_possible && current_task == TaskList::idle_id) {
            Dispatcher::idle();
        } else {
            assert(false);
        }
    }


    forceinline void SetReady_impl(const Task &task) {
        tlist.insert(task.id, task.prio);
    }


    forceinline void Schedule_impl(void) {
        if(in_syscall()) {
            // in syscall: reschedule directly
            Reschedule();
        } else {
            // not in syscall (probably in ISR): request reschedule AST
            // Calls also Reschedule()
            request_reschedule_ast();
        }
    }

    forceinline void SetSuspended_impl(const Task &t) {
        t.tcb.reset();

        tlist.remove(t.id);
        if (t.preemptable == false) {
            // restore non-preemptable task to original priority
            // this is required for the optimization in Reschedule()
            current_prio = t.prio;
        }
    }

    forceinline void ActivateTask_impl(const Task &task) {
        SetReady_impl(task);
        Schedule_impl();
    }

    forceinline void ChainTask_impl(const Task &from, const Task &to) {
        auto from_id = from.id;
        assert(from_id == current_task);

        SetSuspended_impl(from);
        SetReady_impl(to);
        Schedule_impl();
    }

    forceinline void TerminateTask_impl(const Task &from) {
        auto id = from.id;
        assert(id == current_task);

        SetSuspended_impl(from);

        Schedule_impl();
    }

    forceinline void GetResource_impl(const Task &current_task, const int new_prio) {
        SetPriority(current_task, new_prio);
        SetSystemPriority(new_prio);
    }

    forceinline void ReleaseResource_impl(const Task &current_task, const int new_prio) {
        SetPriority(current_task, new_prio);
        SetSystemPriority(new_prio);
        Schedule_impl();
    }


    forceinline void SetReadyFromSuspended_impl(const Task &task) {
        SetPriority(task, task.prio);
    }

    // Low level interface to the task list
    forceinline void SetCurrentTask(const Task &task) {
        if (task.preemptable == false) {
            // promote non-preemptable task to RES_SCHEDULER
            tlist.set(task.id, scheduler_prio);
            current_prio = scheduler_prio;
        }
        current_task = task.id;
    }

    forceinline void SetSystemPriority(const int new_prio) {
        current_prio = new_prio;
    }

    forceinline void SetPriority(const Task &task, const int new_prio) {
        tlist.set(task.id, new_prio);
    }

    forceinline bool isSuspended(const Task &task) {
        return tlist.isSuspended(task.id);
    }

};

constexpr Scheduler::prio_t Scheduler::scheduler_prio;
Scheduler scheduler_;

}; // scheduler
}; // os
#include "counter.h"
#include "alarm.h"

namespace os {

void inlinehint Counter::tick() {
    
    OS_C1_counter.do_tick();
        Alarm::checkCounter(OS_C1_counter);
        
}

void inlinehint Alarm::checkCounter(const Counter &counter) {
    (void) counter; // unused argument warning might happen

    
    
    
    if ((&counter == &OS_C1_counter) && OS_SignalGatherAlarm_alarm.checkTrigger()) {
        debug << "Alarm triggered" << endl;
        OSEKOS_ActivateTask__ABB100(0);
    } 
    if ((&counter == &OS_C1_counter) && OS_FlightControlAlarm_alarm.checkTrigger()) {
        debug << "Alarm triggered" << endl;
        OSEKOS_ActivateTask__ABB101(0);
    } 
    if ((&counter == &OS_C1_counter) && OS_CopterControlWatchdogAlarm_alarm.checkTrigger()) {
        debug << "Alarm triggered" << endl;
        OSEKOS_ActivateTask__ABB102(0);
    } 
    
}


} // os

extern "C" void __OS_StartOS_dispatch(int arg0){
    (void) arg0;
    scheduler_.Reschedule();
}

extern "C" void StartOS(int arg0){
    (void) arg0;
    OS_CopterControlTask_task.tcb.reset();
    OS_CopterControlWatchdogTask_task.tcb.reset();
    OS_FlightControlActuateTask_task.tcb.reset();
    OS_FlightControlAttitudeTask_task.tcb.reset();
    OS_FlightControlTask_task.tcb.reset();
    OS_MavlinkSendTask_task.tcb.reset();
    OS_SignalGatherFinishedTask_task.tcb.reset();
    OS_SignalGatherInitiateTask_task.tcb.reset();
    OS_SignalGatherTimeoutTask_task.tcb.reset();
    OS_SignalProcessingActuateTask_task.tcb.reset();
    OS_SignalProcessingAttitudeTask_task.tcb.reset();
    syscall(__OS_StartOS_dispatch);
    Machine::unreachable();
}

extern "C" void __OS_ASTSchedule(int arg0){
    (void) arg0;
    scheduler_.Reschedule();
}

extern "C" void OSEKOS_kickoff__ABB29(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB29");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB29");
}

extern "C" void __OS_syscall_OSEKOS_GetResource__ABB30(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.GetResource_impl(OS_SignalGatherInitiateTask_task, 13);
    // Dispatch directly back to Userland
    Dispatcher::ResumeToTask(OS_SignalGatherInitiateTask_task);
}

extern "C" StatusType OSEKOS_GetResource__ABB30(ResourceType arg0){
    asm_label("syscall_start_OSEKOS_GetResource__ABB30");
    asm_label("syscall_start_OSEKOS_GetResource__ABB30");
    syscall(__OS_syscall_OSEKOS_GetResource__ABB30);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_GetResource__ABB30");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_GetResource__ABB30");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB35(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_SignalGatherTimeoutTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB35(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB35");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB35");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB35);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB35");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB35");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB37(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_SignalGatherFinishedTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB37(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB37");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB37");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB37);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB37");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB37");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ReleaseResource__ABB39(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ReleaseResource_impl(OS_SignalGatherInitiateTask_task, 10);
}

extern "C" StatusType OSEKOS_ReleaseResource__ABB39(ResourceType arg0){
    asm_label("syscall_start_OSEKOS_ReleaseResource__ABB39");
    asm_label("syscall_start_OSEKOS_ReleaseResource__ABB39");
    syscall(__OS_syscall_OSEKOS_ReleaseResource__ABB39);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ReleaseResource__ABB39");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ReleaseResource__ABB39");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB40(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_SignalGatherInitiateTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB40(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB40");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB40");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB40);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB40");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB40");
    return E_OK;
}

extern "C" StatusType OSEKOS_ActivateTask__ABB101(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB101");
    // Called from ISR, no disable interrupts required!
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    {
        scheduler_.ActivateTask_impl(OS_FlightControlTask_task);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(!scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB101");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB143(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB143");
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    asm_label("syscall_end_OSEKOS_kickoff__ABB143");
}

extern "C" void OSEKOS_kickoff__ABB47(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB47");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB47");
}

extern "C" void __OS_syscall_OSEKOS_GetResource__ABB48(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.GetResource_impl(OS_SignalGatherTimeoutTask_task, 13);
    // Dispatch directly back to Userland
    Dispatcher::ResumeToTask(OS_SignalGatherTimeoutTask_task);
}

extern "C" StatusType OSEKOS_GetResource__ABB48(ResourceType arg0){
    asm_label("syscall_start_OSEKOS_GetResource__ABB48");
    asm_label("syscall_start_OSEKOS_GetResource__ABB48");
    syscall(__OS_syscall_OSEKOS_GetResource__ABB48);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_GetResource__ABB48");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_GetResource__ABB48");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ReleaseResource__ABB49(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ReleaseResource_impl(OS_SignalGatherTimeoutTask_task, 9);
}

extern "C" StatusType OSEKOS_ReleaseResource__ABB49(ResourceType arg0){
    asm_label("syscall_start_OSEKOS_ReleaseResource__ABB49");
    asm_label("syscall_start_OSEKOS_ReleaseResource__ABB49");
    syscall(__OS_syscall_OSEKOS_ReleaseResource__ABB49);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ReleaseResource__ABB49");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ReleaseResource__ABB49");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ChainTask__ABB50(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ChainTask_impl(OS_SignalGatherTimeoutTask_task, OS_SignalGatherFinishedTask_task);
}

extern "C" StatusType OSEKOS_ChainTask__ABB50(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ChainTask__ABB50");
    asm_label("syscall_start_OSEKOS_ChainTask__ABB50");
    syscall(__OS_syscall_OSEKOS_ChainTask__ABB50);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ChainTask__ABB50");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ChainTask__ABB50");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB58(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB58");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB58");
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB59(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_FlightControlAttitudeTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB59(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB59");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB59");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB59);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB59");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB59");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB60(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_FlightControlActuateTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB60(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB60");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB60");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB60);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB60");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB60");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB61(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_MavlinkSendTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB61(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB61");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB61");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB61);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB61");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB61");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB62(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_FlightControlTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB62(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB62");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB62");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB62);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB62");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB62");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB87(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB87");
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB87");
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB88(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_CopterControlWatchdogTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB88(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB88");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB88");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB88);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB88");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB88");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB64(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB64");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB64");
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB65(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_FlightControlAttitudeTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB65(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB65");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB65");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB65);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB65");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB65");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB67(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB67");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB67");
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB68(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_FlightControlActuateTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB68(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB68");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB68");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB68);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB68");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB68");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB75(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB75");
    // Hook: SystemEnterHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB75");
}

extern "C" void OSEKOS_SuspendAllInterrupts__ABB76(){
    asm_label("syscall_start_OSEKOS_SuspendAllInterrupts__ABB76");
    Machine::disable_interrupts();
    // Hook: SystemEnterHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    asm_label("syscall_end_OSEKOS_SuspendAllInterrupts__ABB76");
}

extern "C" void OSEKOS_ResumeAllInterrupts__ABB77(){
    asm_label("syscall_start_OSEKOS_ResumeAllInterrupts__ABB77");
    // Hook: SystemEnterHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ResumeAllInterrupts__ABB77");
}

extern "C" void __OS_syscall_OSEKOS_CancelAlarm__ABB79(){
    // Hook: SystemEnterHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    OS_CopterControlWatchdogAlarm_alarm.setArmed(false);
    // Dispatch directly back to Userland
    Dispatcher::ResumeToTask(OS_CopterControlTask_task);
}

extern "C" StatusType OSEKOS_CancelAlarm__ABB79(AlarmType arg0){
    asm_label("syscall_start_OSEKOS_CancelAlarm__ABB79");
    asm_label("syscall_start_OSEKOS_CancelAlarm__ABB79");
    syscall(__OS_syscall_OSEKOS_CancelAlarm__ABB79);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_CancelAlarm__ABB79");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_CancelAlarm__ABB79");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_SetRelAlarm__ABB80(TickType arg0,TickType arg1){
    TickType var_TickType_2;
    asm volatile("" : "=b"(var_TickType_2));
    TickType var_TickType_1;
    asm volatile("" : "=a"(var_TickType_1));
    // Hook: SystemEnterHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    (void) arg0;
    (void) arg1;
    OS_CopterControlWatchdogAlarm_alarm.setRelativeTime(var_TickType_1);
    OS_CopterControlWatchdogAlarm_alarm.setCycleTime(var_TickType_2);
    OS_CopterControlWatchdogAlarm_alarm.setArmed(true);
    // Dispatch directly back to Userland
    Dispatcher::ResumeToTask(OS_CopterControlTask_task);
}

extern "C" StatusType OSEKOS_SetRelAlarm__ABB80(AlarmType arg0,TickType arg1,TickType arg2){
    TickType var_TickType_0;
    TickType var_TickType;
    asm_label("syscall_start_OSEKOS_SetRelAlarm__ABB80");
    (void) arg0;
    var_TickType = arg1;
    var_TickType_0 = arg2;
    asm_label("syscall_start_OSEKOS_SetRelAlarm__ABB80");
    syscall(__OS_syscall_OSEKOS_SetRelAlarm__ABB80, var_TickType, var_TickType_0);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_SetRelAlarm__ABB80");
    asm_label("syscall_end_OSEKOS_SetRelAlarm__ABB80");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB82(){
    // Hook: SystemEnterHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_CopterControlTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB82(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB82");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB82");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB82);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB82");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB82");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB52(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB52");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB52");
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB53(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_SignalProcessingActuateTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB53(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB53");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB53");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB53);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB53");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB53");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB144(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB144");
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_MavlinkSendTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB144");
}

extern "C" StatusType OSEKOS_ActivateTask__ABB102(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB102");
    // Called from ISR, no disable interrupts required!
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    {
        scheduler_.ActivateTask_impl(OS_CopterControlWatchdogTask_task);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB102");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB142(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB142");
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_CopterControlWatchdogTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    asm_label("syscall_end_OSEKOS_kickoff__ABB142");
}

extern "C" void OSEKOS_kickoff__ABB42(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB42");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB42");
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB43(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_SignalProcessingAttitudeTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB43(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB43");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB43");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB43);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB43");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB43");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ActivateTask__ABB44(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ActivateTask_impl(OS_SignalProcessingActuateTask_task);
}

extern "C" StatusType OSEKOS_ActivateTask__ABB44(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB44");
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB44");
    syscall(__OS_syscall_OSEKOS_ActivateTask__ABB44);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB44");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB44");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB45(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_SignalGatherFinishedTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB45(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB45");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB45");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB45);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB45");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB45");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB70(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB70");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB70");
}

extern "C" void __OS_syscall_OSEKOS_GetResource__ABB71(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.GetResource_impl(OS_MavlinkSendTask_task, 13);
    // Dispatch directly back to Userland
    Dispatcher::ResumeToTask(OS_MavlinkSendTask_task);
}

extern "C" StatusType OSEKOS_GetResource__ABB71(ResourceType arg0){
    asm_label("syscall_start_OSEKOS_GetResource__ABB71");
    asm_label("syscall_start_OSEKOS_GetResource__ABB71");
    syscall(__OS_syscall_OSEKOS_GetResource__ABB71);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_GetResource__ABB71");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_GetResource__ABB71");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_ReleaseResource__ABB72(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.ReleaseResource_impl(OS_MavlinkSendTask_task, 3);
}

extern "C" StatusType OSEKOS_ReleaseResource__ABB72(ResourceType arg0){
    asm_label("syscall_start_OSEKOS_ReleaseResource__ABB72");
    asm_label("syscall_start_OSEKOS_ReleaseResource__ABB72");
    syscall(__OS_syscall_OSEKOS_ReleaseResource__ABB72);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_ReleaseResource__ABB72");
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ReleaseResource__ABB72");
    return E_OK;
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB73(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_FlightControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_MavlinkSendTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_MavlinkSendTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB73(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB73");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB73");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB73);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB73");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB73");
    return E_OK;
}

extern "C" StatusType OSEKOS_ActivateTask__ABB100(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB100");
    // Called from ISR, no disable interrupts required!
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    {
        scheduler_.ActivateTask_impl(OS_SignalGatherInitiateTask_task);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(!scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB100");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB145(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB145");
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingAttitudeTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    asm_label("syscall_end_OSEKOS_kickoff__ABB145");
}

extern "C" void OSEKOS_kickoff__ABB55(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB55");
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_kickoff__ABB55");
}

extern "C" void __OS_syscall_OSEKOS_TerminateTask__ABB56(){
    // Hook: SystemEnterHook
    {
        color_assert(!(OS_CopterControlWatchdogTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_FlightControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherFinishedTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherFinishedTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherInitiateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherInitiateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalGatherTimeoutTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalGatherTimeoutTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(scheduler_.isSuspended(OS_SignalProcessingActuateTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_SignalProcessingActuateTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!scheduler_.isSuspended(OS_SignalProcessingAttitudeTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    scheduler_.TerminateTask_impl(OS_SignalProcessingAttitudeTask_task);
}

extern "C" StatusType OSEKOS_TerminateTask__ABB56(){
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB56");
    asm_label("syscall_start_OSEKOS_TerminateTask__ABB56");
    syscall(__OS_syscall_OSEKOS_TerminateTask__ABB56);
    // Hook: SystemLeaveHook
    {
    }
    Machine::enable_interrupts();
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB56");
    asm_label("syscall_end_OSEKOS_TerminateTask__ABB56");
    return E_OK;
}

extern "C" void OSEKOS_kickoff__ABB84(){
    asm_label("syscall_start_OSEKOS_kickoff__ABB84");
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    // Hook: SystemLeaveHook
    {
    }
    asm_label("syscall_end_OSEKOS_kickoff__ABB84");
}

extern "C" StatusType OSEKOS_ActivateTask__ABB85(TaskType arg0){
    asm_label("syscall_start_OSEKOS_ActivateTask__ABB85");
    // Called from ISR, no disable interrupts required!
    // Hook: SystemEnterHook
    {
        color_assert(scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
        color_assert(!(OS_CopterControlTask_task.tcb.is_running()), COLOR_ASSERT_SYSTEM_STATE);
    }
    {
        scheduler_.ActivateTask_impl(OS_CopterControlTask_task);
    }
    // Hook: SystemLeaveHook
    {
        color_assert(!scheduler_.isSuspended(OS_CopterControlTask_task), COLOR_ASSERT_SYSTEM_STATE);
    }
    (void) arg0;
    asm_label("syscall_end_OSEKOS_ActivateTask__ABB85");
    return E_OK;
}

void __OS_HOOK_PreIdleHook(){
    OSEKOS_kickoff__ABB144();
    __OS_HOOK_DEFINED_PreIdleHook();
}

ISR(37) {
    OSEKOS_ISR_MavlinkRecvHandler();
    LAPIC::send_eoi();
}

